#include <gl/gl.h>
#define	CON_RGB(r,g,b)	(r+(g*256)+(b*256*256))
#define SQR(x)	((x)*(x))
#define DEBUGGING 0	/* 0 = off 1 = on */

#define TX_ENV1  1	/* DECAL or MODULATE texture env. */
#define FACE_TXT 1	/* Number for face texture */
#define P_WINXS -1	/* Perspective Window Boundary */
#define P_WINXE 1
#define P_WINYS -1
#define P_WINYE 1
#define P_WINZS 15
#define P_WINZE 20000


typedef struct {
    Coord	vx,vy,vz;		/* Point looking at */
    Coord	px,py,pz;		/* Point looking from (eye position)*/
    Angle	twist;			/* twist about z ? */
    short	movie;			/* Write each frame to disk? */
    short	texture;		/* Activate texture map? */
    short	light;			/* Using a lighting model ?*/
    short	disp_musc;		/* Display muscles? */
    float	xrot;			/* Xrot of head */
    float	yrot;			/* Yrotation of head */
    float	zrot;			/* Zrotation of head */
    float	xpos;			/* X,Y,Z Position of Head */
    float	ypos;
    float	zpos;

} gfx_info;



typedef struct {
    float       xpos;
    float       ypos;
    float       zpos;
    float       dist;   /* distance between the two eyeballs */
    long        xrot;   /* x-rotation of  eyeball */
    long        yrot;   /* y-rotation of  eyeball */
    float       pupil;  /* 0..1 pupil dilation */
    float       iris;   /* 0..1 iris size */
    float       size;   /* amount to scale the eyeball (its radius) */
} eye_info;













