/******
  
  scrn_rot.c: This allows the numerical keypad to be used to 
  rotate the head display. Simple and crude but it works.
  
  
  This code was written with time and equipment provided by Sony Computer
  Science Lab. It is freely distributable for research purposes. 
  
  It is hoped making this available will facilitate research on facial
  animation. If you make significant changes/extensions to this, or have
  a different system I would appreciate hearing about it.
  
  
  The latest versions of this and other animation systems are
  available by anonymous FTP from:
  
  scslwide.sony.co.jp
  ftp2/SGI/Facial-Animation
  
  Copyright 1992	
  
  Written:	Steve Franks
  Sony Computer Science Labs
  Tokyo, Japan	
  Febuary 1992
  stevef@csl.sony.co.jp
  
  
  *******/
#include <gl/gl.h>
#include <gl/device.h>
#include <forms.h>
#include "standard.h"
#include "muscles.h"
#include "proto.h"



#define DELTAX 1.55
#define DELTAY 1.55
#define DELTAZ 1.0
#define DELTA_TWIST 20

extern	gfx_info	minfo; 

/*** queue_keypad() ***/
void	queue_keypad()
{
    fl_qdevice(PAD1);    /* decrease camera zpos */
    fl_qdevice(PAD2);    /* decrease camera ypos */
    fl_qdevice(PAD3);    /* increase camera zpos */
    fl_qdevice(PAD4);    /* decrease camera xpos */
    fl_qdevice(PAD5);    /* center camera position */
    fl_qdevice(PAD6);    /* increase camera xpos */
    fl_qdevice(PAD7);    /* decrease camera twist */
    fl_qdevice(PAD8);    /* increase camera ypos */
    fl_qdevice(PAD9);    /* increase camera twist */    
    
    fl_qdevice(UPARROWKEY);	/* increase viewpoint ypos */
    fl_qdevice(DOWNARROWKEY);	/* decrease viewpoint ypos */
    fl_qdevice(RIGHTARROWKEY);	/* increase viewpoint xpos */
    fl_qdevice(LEFTARROWKEY);	/* decrease viewpoint xpos */
    fl_qenter(PAD5,1);
}




/*** keypad_event ***/
int	keypad_event(long dev,short data)
{
    int			i;
    
    if (data==0) return;	
    switch(dev)  {	
      case (PAD1):
	do {	
	    minfo.vz -= DELTAZ;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD1)); 
	break;
	
      case (PAD2):
	do {	
	    minfo.vy -= DELTAY;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD2)); 
	break;
	
      case (PAD3):
	do {	
	    minfo.vz += DELTAZ;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD3)); 
	break;
	
      case (PAD4):
	do {	
	    minfo.vx -= DELTAX;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD4)); 
	break;
	
      case (PAD5):
	minfo.vx=minfo.vy=minfo.vz = 0; 
	minfo.px=minfo.py=minfo.pz = 0; 
	minfo.vz = 200;
	minfo.twist = 0;
	refresh_face(NULL,NULL);
	break;
	
	
      case (PAD6):
	do {	
	    minfo.vx += DELTAX;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD6)); 
	break;
	
      case (PAD7):
	do {	
	    minfo.twist -= DELTA_TWIST;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD7)); 
	break;
	
      case (PAD8):
	do {	
	    minfo.vy += DELTAY;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD8)); 
	break;
	
      case (PAD9):
	do {	
	    minfo.twist += DELTA_TWIST;
	    refresh_face(NULL,NULL);
	} while(getbutton(PAD9)); 
	break;
	
      case (UPARROWKEY):
	do {	
	    minfo.py += DELTAY;
	    refresh_face(NULL,NULL);
	} while(getbutton(UPARROWKEY)); 
	break;
	
      case (DOWNARROWKEY):
	do {	
	    minfo.py -= DELTAY;
	    refresh_face(NULL,NULL);
	} while(getbutton(DOWNARROWKEY)); 
	break;
	
      case (RIGHTARROWKEY):
	do {	
	    minfo.px += DELTAX;
	    refresh_face(NULL,NULL);
	} while(getbutton(RIGHTARROWKEY)); 
	break;
	
      case (LEFTARROWKEY):
	do {	
	    minfo.px -= DELTAY;
	    refresh_face(NULL,NULL);
	} while(getbutton(LEFTARROWKEY)); 
	break;	
	
      default:
	return(FALSE);
	
    }   /* end switch */
    
    return(TRUE);	/* IT was a keypad event */
}





