
/* Declarations peculiar to the SciAn NEXRAD file reader */

#define FVERSION "NEXRAD1.0"
#define FEXT "nxr"

#define N_RADS 360
#define N_REFGATES 460
#define N_VELGATES 920

struct NXRhead {
  char ident[10];
  int file_time;
  int ref_gatespace;
  int vel_gatespace;
  int vel_res;
  int num_els;
  float elevs[16];
};

#ifdef PROTO
void InitWhisselFiles(void);
void KillWhisselFiles(void);
#else
void InitWhisselFiles();
void KillWhisselFiles();
#endif

