/*ScianSockets.h
  External stuff for sockets in Scian
  Eric Pepke
*/

extern int socketState;

/*Socket connection structure*/
typedef struct 
    {
	Thing thing;			/*The thing part*/
	int sock;			/* socket fd */
	int gotCmdEnd;			/* true if we found a \n or a \0 */
	int template;			/*File descriptor template,
					  ONLY used on listener*/
    } Connection, *ConnectionPtr;

#define CMD(s)  ((s)[0] * 16777216 + (s)[1] * 65536 + (s)[2] * 256 + (s)[3])

/*Timeouts*/
#define TRYLATERTIME	5.0		/*Try later in 5.0 seconds*/
#define JOHNSTIMEOUT	10.0		/*read/write timeout for sockets */

extern ObjPtr allAdvertised;
extern ObjPtr advertiseableClass;		/*Class of advertiseable objects*/

/*Methods*/
ObjPtr AdvertiseObject();

#ifdef PROTO
int writen(int, char *, long);
int readn(int, char *, long);
void InitSockets(void);
void KillSockets(void);
Bool AllConnectionsIdle(Bool);
void IdleAllConnections(void);
void IdleConnection(ObjPtr);
void DoConnectToComputer(void);
void DoEnablePublication(void);
void SendSocketCommandLater(ObjPtr connection, char *command);
ObjPtr NewLocalDaemonConnection(void);
ObjPtr NewRemoteDaemonConnection(char *machineName);
ObjPtr NewRemoteScianConnection(char *machineName, int port, ObjPtr process);
ObjPtr NewListenerConnection(void);
ObjPtr NewLocalScianConnection(int file);
void WaitForNetObjectVar(ObjPtr, VarsPtr);
Bool ThisWouldBeAReallyBadThing(NameTyp var);
#else
int writen();
int readn();
void InitSockets();
void KillSockets();
Bool AllConnectionsIdle();
void IdleAllConnections();
void IdleConnection();
void DoConnectToComputer();
void DoEnablePublication();
void SendSocketCommandLater();
ObjPtr NewLocalDaemonConnection();
ObjPtr NewRemoteDaemonConnection();
ObjPtr NewRemoteScianConnection();
ObjPtr NewListenerConnection();
ObjPtr NewLocalScianConnection();
void WaitForNetObjectVar();
Bool ThisWouldBeAReallyBadThing();
#endif
