/*
  File: sgi2wff.c
  Author: Jill Gemmill
  Last Modified: August 15, 1991
  Purpose: 
	   USAGE:
		sgi2wff <SGI_XXXX.rgb>

	   Converts an SGI image to wff image.
	
	   The SGI image must be B&W or RGB.  (wff does
	   not know about color maps).

	   the sgi file is found in the filename indicated.
	   the wff file departs via stdout

	   This version FORCES 8 BitsPerBand
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>
#include "image.h"

#define BITSPERBAND 8

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s <SGI_XXXX.rgb>\n", RoutineName);
 }


static void
sgi2wff(ImageName,fdOut)
 char *ImageName;
 FILE *fdOut;
 {
  IMAGE *image;
  FrameBufferType *FBout;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  int xsize,ysize,zsize;
  unsigned short Pixel[100]; 
  char WhatBands[ValueLength];
  int  BitsPerBand=BITSPERBAND;
  unsigned short *rbuf;
  unsigned short *gbuf;
  unsigned short *bbuf;

  
  /* READ THE IMAGE HEADER */
  if ( (image = iopen(ImageName,"r")) == NULL )
  {	fprintf(stderr,"ERROR: Can't open input file %s\n",ImageName);
	exit(2);
  }
  xsize = image->xsize;
  ysize = image->ysize;
  zsize = image->zsize;

  FBout  = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBout)) return(-1);
  /* DEFINE wff HEADER */
  if (zsize==3) strcpy(WhatBands,"RGB");
  else if (zsize==1) strcpy(WhatBands,"I");
  else 
  {	fprintf(stderr,"ERROR: UnKnown Image Format (not RGB or I)\n");
	exit(2);
  }
  SetColorSystem(FBout,WhatBands,BitsPerBand);
  Bottom = Left = 0;
  Top = ysize - 1;
  Right = xsize - 1;
  SetBounds(FBout,Bottom,Left,Top,Right);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FBout, Name, Value);

  strcpy(Name,"X-WithHelpFrom"); strcpy(Value,"JillGemmill");
  SetDescriptor(FBout,Name,Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FBout, Name, Value);

  rbuf = (unsigned short *)malloc(xsize*sizeof(unsigned short));
  if (zsize > 1)
  {	gbuf = (unsigned short *)malloc(xsize*sizeof(unsigned short));
  	bbuf = (unsigned short *)malloc(xsize*sizeof(unsigned short));
  }

  for (y=Bottom;y<=Top;y++)
   {	getrow(image,rbuf,y,0);
	if (zsize > 1)
	{	getrow(image,gbuf,y,1);
		getrow(image,bbuf,y,2);
	}
    	for(x=Left;x<=Right;x++) /*Left IS ALWAYS 0 */
    	{	Pixel[0] = *(rbuf+x);
		if (zsize > 1)
		{	Pixel[1] = *(gbuf+x);
			Pixel[2] = *(bbuf+x);
		}
		(void) PutPixel(FBout,x,y,Pixel);
        }
   }

   iclose(image);
   WriteImage(fdOut,FBout);
  (void)CloseFB(&FBout);
 }



int main(argc,argv)
 int argc;
 char *argv[];
 {
  char *wname; 
  RoutineName = argv[0];

  if (argc != 2) { usage(); exit(-1); }
  wname = argv[1];

  sgi2wff(wname,stdout);

  fprintf(stderr,"\n%s: DONE             \n",RoutineName);
  exit (0);
}

