/*
  File: Byrd2TIFF.c
  Author: K.R. Sloan
  Last Modified: 17 January 1992
  Purpose: convert Vitria Byrd's images to TIFF

  NOTE: under development - some oversimplifications still present

  NOTE: portable?  not hardly

  ASSUMPTIONS: sizeof int   = 4   
               sizeof short = 2
 */
#include <stdio.h>
#include <math.h>

int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"usage is:\n\t%s [-h][-v]\n",
                   RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }


/* fixed size images - easy! */

#define ImageWidth  512
#define ImageLength 480

static ReadWriteImage(sIn, sOut)
 FILE *sIn, *sOut;
 {
  int x,y;
  unsigned char p;

  for(y=0;y<ImageLength;y++)
   for(x=0;x<ImageWidth;x++)
    {
     fread(&p,1,1,sIn);
     fwrite(&p,1,1,sOut);
    }
 }

int main (argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  static int WhichEndUp = 0x4D4D4949;
  static short VersionNumber = 0x002a;
  static int ImageFileDirectoryOffset;
  unsigned short Tag;
  unsigned short Type;
  int Length;
  int LongValue;  
  short ShortValue;
  static char Nulls[4] = { 0,0,0,0 };
  int BitsPerSample = 8;
  int BytesPerSample = 1;
  short Entries;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  /* Image file header */
  fwrite((char *)&WhichEndUp,2,1,stdout);

  /* version number */ 
  fwrite((char *)&VersionNumber,2,1,stdout);
  
  /* offset to Image File Directory */

  ImageFileDirectoryOffset = 8 + (ImageWidth * ImageLength * BytesPerSample);
  fwrite((char *)&ImageFileDirectoryOffset,4,1,stdout);

  /* the image */

  ReadWriteImage(stdin,stdout);

  /* Image file directory */
  /* note: sorted in ascending order by Tag */

  /* number of entries */

  Entries = 6;
  fwrite((char *)&Entries,2,1,stdout);  

  /* ImageWidth = 512 */

  Tag = 0x100;  Type = 3; Length = 1; ShortValue = 512;
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&ShortValue,2,1,stdout); 
  fwrite(Nulls,1,2,stdout);

  /* ImageLength = 486 */

  Tag = 0x101;  Type = 3; Length = 1; ShortValue = 480;
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&ShortValue,2,1,stdout); 
  fwrite(Nulls,1,2,stdout);


  /* BitsPerSample = 8 */

  Tag = 0x102;  Type = 3; Length = 1; ShortValue = BitsPerSample;
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&ShortValue,2,1,stdout); 
  fwrite(Nulls,1,2,stdout);

  /* PhotometricInterpretation = 0 (MinIsBlack) */

  Tag = 0x106;  Type = 3; Length = 1; ShortValue = 1;
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&ShortValue,2,1,stdout); 
  fwrite(Nulls,1,2,stdout);

  /* StripOffsets */

  Tag = 0x111;  Type = 4; Length = 1; LongValue = 8;
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&LongValue,4,1,stdout); 

  /* StripByteCounts */

  Tag = 0x117;  Type = 4; Length = 1; 
  LongValue = (ImageWidth * ImageLength * BytesPerSample);
  
  fwrite((char *)&Tag,2,1,stdout);
  fwrite((char *)&Type,2,1,stdout);
  fwrite((char *)&Length,4,1,stdout);
  fwrite((char *)&LongValue,4,1,stdout); 

  /* end of Image File Directory */
  fwrite(Nulls,1,4,stdout);  

 }
