/*
  File: Gamma.c
  Author: K.R. Sloan
  Last Modified: 20 January 1991
  Purpose: Gamma correct all bands of a .wff image
 */

#include <stdio.h>
#include <math.h>
#include "wff.h"

double atof();

int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-h][-v][-g gamma]\n", RoutineName);
 } 

static void
Pass(fdIn,fdOut,Gamma)
 FILE *fdIn, *fdOut;
 double Gamma;
 {
  FrameBufferType *FBin, *FBout;
  int Bottom, Left, Top, Right, Bands;
  char Name[NameLength], Value[ValueLength], WhatBands[NameLength];
  int x,y,n,b,BitsPerBand,MaxValue;
  unsigned short Pixel[99];  /* that ought to be enough... */
  int passed = 0;
  double Exponent, Scale;
  unsigned short *LUT;
  int slot;
 
  FBin  = (FrameBufferType *) 0;
  FBout = (FrameBufferType *) 0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
  GetColorSystem(FBin,WhatBands,&BitsPerBand);
  Bands = strlen(WhatBands);

  MaxValue = (1 << BitsPerBand) -1;
  LUT = (unsigned short *)calloc(MaxValue, sizeof(unsigned short));
  if ((unsigned short *)0 == LUT)
   {
    fprintf(stderr,"%s: No memory for LUT\n",RoutineName);
    (void)CloseFB(&FBin);  
    (void)CloseFB(&FBout);
    return; 
   }
  Exponent = 1.0 / Gamma;
  Scale = (double)MaxValue / pow((double)MaxValue, Exponent);

  for (slot=0;slot<=MaxValue;slot++)
   {
    LUT[slot] = Scale * pow((double)slot, Exponent);
    if (VERBOSE)
     fprintf(stderr,"%s: LUT[%d] = %d\n",RoutineName,slot,LUT[slot]);
   }

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  for (y=Bottom;y<=Top;y++)
   {
    for (x=Left;x<=Right;x++)
     {
      if (FAILURE == NextPixelIn(FBin,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

      for (b=0;b<Bands;b++) Pixel[b] = LUT[Pixel[b]];

      if (FAILURE == NextPixelOut(FBout,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
     }
    wffFlush(FBout);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

int main(argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  double Gamma =  2.0;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit (-1); }
    switch (argv[ArgsParsed++][1])
      {
       case 'g': if (argc <= ArgsParsed) { usage(); exit (-1); }
                 Gamma = atof(argv[ArgsParsed++]);
                 break;        
       case 'v': VERBOSE = -1; break;
       default:
       case 'h': { usage(); exit (-1); }
      }
   }

  Pass(stdin,stdout,Gamma);
  exit (0);
 }
