/*
 File: Triangulate.c
 Authors: K.R. Sloan
 Last Modified: 3 December 1990
 Purpose: triangulates a set of points
 */

#include <DCEL.h>
#include <GrahamHull.h>
#include <Triangulate.h>

 /*
  InsertNonHullPoints expects that the convex hull has been found, and
  triangulated. 

  The GLOBAL variable Hull (from DCEL.h) points at the 
  set of points in the hull.

  The GLOBAL variable ProbeRoot (from DCEL.h) is a hint to InsertPoint
  about where to start searching for the (existing) triangle in which 
  the new point falls.
 */  

void InsertNonHullPoints(LastPoint)
 int LastPoint;
 {
  int  i;

  ProbeRoot = Hull->P; /* just to get started */
  for (i=0;i<LastPoint;i++)
   {
    if (!InPointSet(i, Hull))
     if (InsertPoint(i))
      { /* success */
       ProbeRoot = i; 
       Optimize(); 
      }   /* success */
    }
 } /* InsertNonHullPoints */

void Triangulate(LastPoint)
 int LastPoint;
 {
  Hull =  GrahamHull(Points, LastPoint);
  ConvexTriangles(Hull); 
  Optimize();
  InsertNonHullPoints(LastPoint);
 }
