/*
 File: Storage.c
 Authors: J. Painter,
          K.R. Sloan
 Last Modified: 24 August 1990
 Purpose: storage allocation in globs.
          This module provides dynamic memory storage allocation functions
          which minimizes the cost of allocation by allocating elements in
          large "globs".  The cost of a malloc is amortized over many 
          allocations.

          For each size allocated, a free list must be maintained.
          It should be initialized to NULL.  All further maintenance of the
          free list is handle in this module.

          One disadvantage: once allocated to a particular freelist, memory
          is dedicated to that freelist.  We never give anything back.

          So, beware....

 */
#include <stdio.h>
#include <malloc.h>

void *New(sizeofelt, globsize, freelist)
 unsigned sizeofelt;
 unsigned globsize;
 void ***freelist;
 {
  void *result;
  void **next;
  int i;

  if (sizeofelt < sizeof(void *))  sizeofelt = sizeof(void*);

  if ((void **) 0 == (*freelist))
   { /* Allocate a glob */
    next = (void **) malloc( sizeofelt * globsize );
    if ((void **) 0 == next)
     {	
      fprintf(stderr, "New: malloc failure!\n");
      return (void *) 0;
     }
    *freelist = next;
    for(i=1; i<globsize; i++)
     {
      *next = (void *)(((char *) next) + sizeofelt);
      next = (void **) *next;
     }
    *next = (void *)0;
   }

  /* Get one from the free list */
  result = (void *)(*freelist);
  (*freelist) = (void **) (*(*freelist));

  return result;
 }
	

void Dispose(item, freelist)
 void **item;	          /* returned from New */
 void ***freelist;        /* Free list used when New was allocated */
 {
  *item = (void *) (*freelist);
  (*freelist) = item;
 }

