/* file: Fisher.c - extracted from tests.c - all routines to test */
/* main() added, at end  - KRS*/

#include "stdio.h"
#include "math.h"

#define X       0
#define Y       1
#define Z       2
#define W       3

/* return 'z' of left-hand or right-hand cross product */
#define GIScalerCrossZ( v0, v1 ) ( (v0)[X] * (v1)[Y] - (v0)[Y] * (v1)[X] )

/*****************************************************************************/
/*****************************************************************************/
/* Fred Fisher test */

#define	DEBUG	0
int	verbose;			/* for tracing level */

#if	DEBUG
#define GIAssure(cond)                                                  \
        if (!(cond)) {                                                  \
            printf( "\7\7\7??? 'cond' failed\n");                       \
            printf( "GIAssure: Line %d, File %s\n\n", __LINE__, __FILE__); \
        }

#define	GITrace(level, args)	if ( verbose >= level ) { args };

#else
#define GIAssure(cond)
#define	GITrace(level, args)
#endif

/*****************************************************************************/
#define	DirUnknown	0
#define	DirPlus		1
#define	DirNeg		-1

isConvexFred( nvert, pVert )
int	  nvert;
float	  pVert[][2];
/* determine if the polygon is:
 *	return 0 if degenerate (all points co-linear or co-incident)
 *	return 1 if convex
 *	return 2 if non-convex
 */
{
    int		firsti1, i1, i2, 
		xdir = DirUnknown, aturn = 0, knowOutside = 0;
    float	vec1[3], vec2[3], *pcur, *pnext, *ptemp, ccw = 0.0, 
		outside = 0.0;

    if ( nvert < 3  ) return(0);

    /***** find indices i1 and i2 to 3 non-coincident points */
    i1 = 1;
    pcur  = vec1;
    pnext = vec2;
    /* scan for first pair of non-coincident pts */
    do {
	/* this is faster than computing entire cross product and checking
	 * for zero. we'll use 'pcur' later to complete cross product.
	 */
	pcur[X] = pVert[i1][X] - pVert[0][X];
	pcur[Y] = pVert[i1][Y] - pVert[0][Y];
	if ( pcur[X] != 0.0  ||  pcur[Y] != 0.0 ) {
	    break;
	}
    } while ( ++i1 < nvert );
    if ( i1 >= nvert ) return(0);	/* all coincident */
    firsti1 = i1;			/* remember first non-coincident */

    /***** find the next point that's not coincident with coord 'i1'
     * at first I thought of looking for the next point which does not
     * produce a zero cross product (because of repeated points or movement
     * along the same edge. However, this didn't account for things like:
     * 0 0, 1 0, 0 0, 0 1 where (0 1) would be the next point and give a
     * non-zero cross product.
     */
    i2 = i1;
    while ( ++i2 < nvert ) {
	pnext[X] = pVert[i2][X] - pVert[i1][X];
	pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
	if ( pnext[X] == 0.0  &&  pnext[Y] == 0.0 )
	    continue;
	ccw = GIScalerCrossZ( pcur, pnext );
	/* must get out, consider [0,0] [1,0] [0,0] [0,1] */
	break;
    }
    if ( i2 >= nvert ) return(0);	/* all coincident */

    /* check for X coord direction change. sometimes check for Y changing */
#define	CheckNextVertexForDirection(pcur, pnext)			\
    if ( pnext[X] > 0.0 ) {						\
	if ( xdir == DirNeg ) {						\
	    aturn++;							\
	}								\
	xdir = DirPlus;							\
    } else if ( pnext[X] < 0.0 ) {					\
	if ( xdir == DirPlus ) {					\
	    aturn++;							\
	}								\
	xdir = DirNeg;							\
    } else {								\
	/* X is not changing, check last three Y's */ 			\
	if ( pcur[Y] * pnext[Y] < 0.0 ) {				\
	    aturn++; /* only y turned, x direction the same */		\
	}								\
    }									\

#define	DetermineConvexDirection( crossResult )				\
    if ( crossResult < 0 ) {						\
	knowOutside = 1; outside = -1.0;				\
    } else {								\
	if ( crossResult > 0 ) {					\
	    knowOutside = 1; outside =  1.0; 				\
        }								\
    }									\

#define	TraceResults							\
    GITrace( 5,								\
	printf(								\
"on %2d,%2d xdir,aturn,know,ccw=[%d,%d,%d,%g], pcur=[%g,%g] pnext=[%g,%g]\n",\
		i1,i2,  	xdir, aturn, knowOutside, ccw,	\
		pcur[X], pcur[Y],      pnext[X], pnext[Y] );		\
    )									\

    /***** we now have 3 non-coincident points, find first direction */
    if ( pcur[X] > 0.0 ) {
	xdir = DirPlus;
    } else {
	if ( pcur[X] < 0.0 ) {
	    xdir = DirNeg;
	}
    }
    CheckNextVertexForDirection( pcur, pnext );
    DetermineConvexDirection( ccw );

    GITrace( 5,
	printf(
	    "First three indices [%d, %d, %d], know,outside,ccw = %d, %g, %g\n",
			0, i1, i2, knowOutside, outside, ccw );
    )
    ptemp = pnext;
	    pnext = pcur;
		    pcur = ptemp;		/* swap vector ptrs */

    /***** go around polygon checking turn every 3 non-coincident vertices */
    for ( i1 = i2, ++i2;    i2 < nvert;    i2++ ) {
	pnext[X] = pVert[i2][X] - pVert[i1][X];
	pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
	if ( pnext[X] == 0.0  &&  pnext[Y] == 0.0 )
	    continue;

	/* we have another non-coincident point */
	CheckNextVertexForDirection( pcur, pnext );
        if ( aturn > 2 ) return(2);

	ccw = GIScalerCrossZ( pcur, pnext );
	if ( !knowOutside && ccw ) 
	    DetermineConvexDirection( ccw );

	TraceResults;
	if ( ccw * outside < 0.0 )
	    return(2);				/* found wrong turn */
	i1 = i2;
	ptemp = pnext;
		pnext = pcur;
			pcur = ptemp;		/* swap vector ptrs */
    }

    /***** and another cross product */
    i2 = 0;
    pnext[X] = pVert[i2][X] - pVert[i1][X];
    pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
    CheckNextVertexForDirection( pcur, pnext );
    if ( aturn > 2 ) return(2);
    ccw = GIScalerCrossZ( pcur, pnext );
    if ( !knowOutside && ccw ) 
	DetermineConvexDirection( ccw );
    TraceResults;
    if ( ccw * outside < 0.0 )
	return(2);                          /* found wrong turn */
    i1 = i2;
    ptemp = pnext;
	    pnext = pcur;
		    pcur = ptemp;           /* swap vector ptrs */

    /***** and one more cross product to first non-coincident */
    i2 = firsti1;
    pnext[X] = pVert[i2][X] - pVert[i1][X];
    pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
    ccw = GIScalerCrossZ( pcur, pnext );
    if ( !knowOutside && ccw ) 
	DetermineConvexDirection( ccw );
    TraceResults;
    if ( ccw * outside < 0.0 )
	return(2);                          /* found wrong turn */

    if ( !knowOutside ) return(0);
    return(1);
}
/* main() added, at end */

/* added by KRS */

int main()
 {
  int i;
  int nvert;
  float	  pVert[64][2];

  for(i=0;;i++)
   if (2 != fscanf(stdin," %f %f",&pVert[i][0],&pVert[i][1]))
    { nvert = i; break; }

  if (1 == isConvexFred( nvert, pVert ))
   { fprintf(stdout,"CONVEX\n"); exit(0); }
  else
   { fprintf(stdout,"NON-CONVEX OR DEGENERATE\n"); exit(-1); }
 }
