.TH XTIFF 1 "May 7, 1990" "X Version 11"
.SH NAME
xtiff \- view a TIFF file in an X window
.SH SYNOPSIS
.B xtiff
[
.IR "\-directory directory"
]
[
.IR "\-display display"
]
[
.IR "\-gamma gamma"
]
[
.IR "\-geometry geometry"
]
[
.IR "\-nopixmap"
]
[
.IR "\-sync"
]
.IR file
.SH DESCRIPTION
.IR xtiff
is a TIFF viewer for X based on the
.IR libtiff (3)
package.
It displays a single TIFF file in an X window
big enough to hold the image.
On appropriate display hardware
it can handle 24-bit RGB color TIFF files,
8, 4 and 2-bit palette color TIFF files
and 8, 4, 2 and 1-bit grayscale TIFF files.
The
.IR \-directory
option allows the user to specify
an individual page in a multi-page TIFF file.
.PP
.IR xtiff
manages the negotiation between the needs of an image
and the visual capabilities made available by an X server.
If necessary,
it will promote an image to a deeper visual,
but it will not demote an image by quantizing and/or dithering.
In that case it will fail to display the image.
.PP
.IR xtiff
reads the
.IR "Gray Response Curve" ,
.IR "Gray Response Unit"
and
.IR "Color Response Curve"
tags in a TIFF file.
The data in these tags describe gamma compensation or image companding.
Together with the
.IR \-gamma
option or the NTSC default gamma value of 2.2,
the image will be gamma corrected and displayed.
.PP
For example, if a TIFF file has been prepared for a typical display,
it has a gamma compensation of 2.2 built into either the image
or preferably the
.IR "Color Response Curve"
tag.
This is a device-dependent image and,
in this case, the value for the
.IR \-gamma
command line option should be 1.0.
If the
.IR "Color Response Curve"
tag describes a companded but otherwise device-independent image
then the command line gamma should be set according to the monitor.
.PP
Unfortunately there is no way of knowing a priori whether or not
an image is device-independent without knowing its ancestry.
If the image conforms to the TIFF 5.0 specification
it should be device-independent;
but many scanner and image processing programs
do not adhere rigorously to the standard.
.SH BUTTONS
.IR xtiff
will exit if you press any button while the
.IR xtiff
window has input focus.
.SH OPTIONS
.TP 8
.B -directory directory
Seek to
.IR directory
and display its image.
The default directory is 0.
This option can be used to display different pages
in a multi-page TIFF file.
.TP 8
.B -display display
Indicates the X server used to display an image.
.TP 8
.B -gamma gamma
Specifies the value used
to build compensation tables
for simple gamma correction.
.TP 8
.B -geometry geometry
This option is only used to indicate the placement of an
.IR xtiff
window.
.TP 8
.B -nopixmap
Indicates that
.IR xtiff
should not use a pixmap to store the image on a server.
This option is necessary
because some servers impose size limitations on pixmaps.
This method is slower because the image must be stored
on the client side and transferred for each exposure or refresh.
.TP 8
.B -sync
Run
.IR xtiff
synchronously.
.SH SEE ALSO
.IR libtiff (3),
.br
.IR "Tag Image File Format Specification \(em Revision 5.0" ,
Aldus Corporation,
August 8, 1988.
.br
.IR "The Spirit of TIFF Class F" ,
Cygnet Technologies,
revised March 29, 1990.
.SH LIMITATIONS
.IR xtiff
does not support the complete repertoire of all possible TIFF files
on all possible visual/depth combinations.
.PP
.IR xtiff
supports TIFF class B (bilevel),
class G (grayscale),
class P (palette color),
class R (RGB color) and class F (FAX).
.PP
Only the top-left orientation is supported.
This is both the X orientation and the TIFF default.
.PP
Gamma correction is simple and there is no colorimetry support.
.PP
.IR xtiff
assumes that servers with 24-bit visuals also have 8-bit visuals.
An 8-bit image is not promoted to 24-bit on the client side.
.PP
There is no support for
.IR StaticGray ,
.IR StaticColor
or
.IR TrueColor
visuals except for 1-bit images.
There is no support for 3/3/2 DirectColor visuals.
