/*
 * inherit.c,v 2.1 1992/07/22 15:57:14 pete Exp
 * inherit.c,v
 * Revision 2.1  1992/07/22  15:57:14  pete
 * Use XoNameString() instead of XtName().
 *
 * Revision 2.0  1992/04/23  02:52:35  ware
 * First public release.
 *
 * Revision 1.6  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.5  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.4  1991/08/26  11:58:23  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.3  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.2  1991/05/22  17:49:46  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.1  91/05/15  08:56:50  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xo/XoP.h>
#include <X11/Xo/ObjDraw.h>
#include <X11/Xo/dbug.h>

XoProto (static Boolean, _xoInherited, (XrmQuark * list, String name));
XoProto (static XtResourceList, add_res, (XtResourceList reslist, Cardinal num, XtResource * res));

/*
 * Pass along any inherited arguments from the parent to this child.  Typically
 * called by the parents Initialize() and SetValues() proc's.
 */

Boolean
_XoInheritedSet (parent, child, set_args, num_set_args)
	Widget          parent;
	Widget          child;
	ArgList         set_args;
	Cardinal       *num_set_args;
{
	int             i;		/* simple counter */
	Arg             args[10];	/* used to get and set values */
	Cardinal        cnt;		/* number of args */
	XrmQuark       *res_list;	/* list of inherited resources */
	Boolean         changed = False;
#ifndef DBUG_OFF
	char		buf1[80];
	char		buf2[80];
#endif

	DBUG_ENTER ("_XoInheritedSet");
	if (!parent || !child || !num_set_args || !set_args || !*num_set_args)
		DBUG_RETURN (changed);
	cnt = 0;
	res_list = NULL;
	XtSetArg (args[cnt], XtNinheritResources, &res_list);
	++cnt;
	XtGetValues (child, args, cnt);
	if (!res_list || !*res_list)
	{
		DBUG_PRINT ("inherit", ("No resources inherited for %s", XoName (child)));
		DBUG_RETURN (changed);
	}
	cnt = 0;
	for (i = 0; i < *num_set_args; i++)
	{
		if (_xoInherited (res_list, set_args[i].name))
		{
			if (cnt == XtNumber (args))
			{
				DBUG_PRINT ("inherit", ("Setting %d args", cnt));
				changed = True;
				XtSetValues (child, args, cnt);
				cnt = 0;
			}
			DBUG_PRINT ("inherit",
				    ("setting resource %s in %s by %s",
				     set_args[i].name, XoNameString (child, buf1, sizeof (buf1)),
				     XoNameString (parent, buf2, sizeof (buf2))));
			XtSetArg (args[cnt], set_args[i].name, set_args[i].value);
			++cnt;
		}
	}
	if (cnt)
	{
		DBUG_PRINT ("inherit", ("Setting %d args", cnt));
		changed = True;
		XtSetValues (child, args, cnt);
	}
	DBUG_RETURN (changed);
}

static          XtResourceList
add_res (reslist, num, res)
	XtResourceList  reslist;
	Cardinal        num;
	XtResource     *res;
{
	if (!reslist)
	{
		reslist = XtNew (XtResource);
	}
	reslist = (XtResourceList) XtRealloc ((char *) reslist,
					   (num + 1) * sizeof (XtResource));
	*(reslist + num++) = *res;
	return reslist;
}

/*
 * _XoInheritedGet - Lookup any inherited resources from the parent.  This
 *		was rewritten to use the already "spiffy fast compiled form"
 *		of the resource list.  Accordingly, it's dependent
 *		on that.
 *
 *		This could be significantly faster if XtGetApplicationResources
 *		were faster.

 */

void
_XoInheritedGet (parent, child)
	Widget          parent;
	Widget          child;
{
	int             i;		/* simple counter */
	Arg             args[10];	/* used to get and set values */
	Cardinal        cnt;		/* number of args */
	XrmQuark       *res_list;	/* list of inherited resources */
	XtResourceList *resources;
	Cardinal        num_resources;
	XrmQuark       *ptr;
	XtResourceList  get_res;
	Cardinal        get_res_num;

	if (!parent || !child)
		return;

	/*
	 * Find out what resources the child inherits from the parent.
	 */
	cnt = 0;
	res_list = NULL;
	XtSetArg (args[cnt], XtNinheritResources, &res_list);
	++cnt;
	XtGetValues (child, args, cnt);
	if (!res_list)
		return;
	resources = (XtResourceList *) XtClass ((Widget) child)->core_class.resources;
	num_resources = XtClass ((Widget) child)->core_class.num_resources;

	/*
	 * Look up each of the inherited resources and find the corresponding
	 * entry in the class hierarchy.
	 */
	get_res_num = 0;
	get_res = NULL;
	for (ptr = res_list; ptr && *ptr; ptr++)
	{
		for (i = 0; i < num_resources; i++)
		{
			if (!resources[i])
				continue;
			if (*ptr == (XrmQuark) resources[i]->resource_name)
			{
				get_res = add_res (get_res, get_res_num,
						   resources[i]);
				++get_res_num;
			}
		}
	}

	/*
	 * Now retrieve the resources from the database and update the
	 * values.
	 */

	XtGetApplicationResources (parent, (XtPointer) child, get_res, get_res_num,
				   (ArgList) NULL, (Cardinal) 0);
	XtFree ((char *) get_res);
}

static Boolean
_xoInherited (list, name)
	XrmQuark       *list;
	String          name;
{
	XrmQuark       *ptr;
	XrmQuark        q;
	int             status = False;

	if (!name)
		return status;
	q = XrmStringToQuark (name);
	for (ptr = list; ptr && *ptr; ptr++)
	{
		status = *ptr - q;
		/* stop search when found or lexically passed name */
		if (status >= 0)
			break;
	}
	return (status == 0);
}
