/*
 * Hardcopy -	Provides the general interface to hardcopy from
 *		any widget.
 *
 * hardcopy.c,v 2.1 1992/07/22 15:57:18 pete Exp
 * hardcopy.c,v
 * Revision 2.1  1992/07/22  15:57:18  pete
 * Use XoNameString() instead of XtName().
 *
 * Revision 2.0  1992/04/23  02:52:28  ware
 * First public release.
 *
 * Revision 1.5  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.4  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.3  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.2  1991/08/26  11:58:20  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.1  91/07/19  00:58:43  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/CharSet.h>
#include <X11/CompositeP.h>
#include <X11/Xo/XoP.h>
#include <X11/Xo/dbug.h>

/*
 * xoHardCopy -	Execute the specified hardcopy extension for
 *		this widget, all of it's children and any popped up
 *		children.
 */

void
XoHardcopy (tree, hardcopy, depth)
	Widget          tree;		/* widget tree to print */
	XoHardCopy     *hardcopy;	/* hardcopy info */
	int             depth;		/* current nesting depth */
{
	XoHardCopyExt  *ext;
	int             i;

	DBUG_ENTER ("xoHardCopy");
	if (!tree || !hardcopy)
		DBUG_VOID_RETURN;
	/*
	 * See if this has a matching extension record
	 */
	for (ext = (XoHardCopyExt *) XtClass (tree)->core_class.extension; ext;
	     ext = (XoHardCopyExt *) ext->next_extension)
	{
		DBUG_PRINT ("extension", ("Looking at extension in %s",
					  XoName (tree)));
		if (ext->record_type == hardcopy->h_type
		    && ext->version == hardcopy->h_version)
			break;
	}
	if (ext && ext->func)
	{
		DBUG_PRINT ("hardcopy", ("extension record for %s", XoName (tree)));
		(*ext->func) (tree, hardcopy);
	}
	else
	{
		DBUG_PRINT ("hardcopy", ("trying %s as a composite", XoName (tree)));
		_XoHardcopyComposite (tree, hardcopy, depth);
	}
	if (XtIsWidget (tree))
	{
		for (i = 0; i < tree->core.num_popups; i++)
		{
			if (_XoIsPoppedUp (tree->core.popup_list[i]))
			{
				XoHardcopy (tree->core.popup_list[i], hardcopy, depth + 1);
			}
		}
	}
	DBUG_VOID_RETURN;
}

/*
 * _XoHardcopyComposite - Traverses the children of this
 *		composite widget.  Returns immediately
 *		if this is not a composite widget
 */

void
_XoHardcopyComposite (tree, hardcopy, depth)
	Widget          tree;
	XoHardCopy     *hardcopy;
	int             depth;
{
	CompositeWidget comp;
	int             i;

	DBUG_ENTER ("_XoHardcopyComposite");
	if (!XtIsComposite (tree))
		DBUG_VOID_RETURN;
	comp = (CompositeWidget) tree;
	for (i = 0; i < comp->composite.num_children; i++)
	{
		if (XtIsManaged (comp->composite.children[i]))
		{
			XoHardcopy (comp->composite.children[i],
				    hardcopy, depth + 1);
		}
	}
	DBUG_VOID_RETURN;
}

/*
 * XoHardcopyAddExtension - Add a hardcopy extension record
 *		to this widget class.  Replaces any matching
 *		one that already existing.
 *
 *		Note that this is a non-standard extension.  This
 *		implies it cannot be set at class initialization time.
 *		The ClassPartInitialize is a good time to call this.
 *		(See Asente & Swick pg. 98)
 */

void
XoHardcopyAddExtension (class, name, version, func, private)
	WidgetClass     class;
	String          name;		/* hardcopy type (ie postscipt) */
	long            version;	/* version of hardcopy */
	XoHardCopyProc  func;		/* function to execute */
	XtPointer       private;	/* needed private data */
{
	XoHardCopyExt  *ext;
	XoHardCopyExt  *prev;
	XrmQuark        this_type;
	char            lower[512];

	DBUG_ENTER ("XoHardcopyAddExtension");
	if (!class || !name || !func)
	{
		return;
	}
	XmuCopyISOLatin1Lowered (lower, name);
	this_type = XrmStringToQuark (lower);
	prev = NULL;
	for (ext = (XoHardCopyExt *) class->core_class.extension; ext;
	     ext = (XoHardCopyExt *) ext->next_extension)
	{
		if (ext->record_type == this_type && ext->version == version)
			break;
		else
			prev = ext;
	}
	if (ext)
	{
		DBUG_PRINT ("extension", ("found duplicate extension"));
		if (prev)
			prev->next_extension = ext->next_extension;
		else
			class->core_class.extension = NULL;
		XtFree ((char *) ext);
	}
	ext = XtNew (XoHardCopyExt);
	ext->next_extension = class->core_class.extension;
	class->core_class.extension = (XtPointer) ext;
	ext->record_type = this_type;
	ext->version = version;
	ext->record_size = sizeof (XoHardCopyExt);
	ext->func = func;
	DBUG_PRINT ("extension", ("added extension %s version %ld",
				  name, version));
	DBUG_VOID_RETURN;
}
