/*
 * Obj3dBorder.c,v 2.2 1992/07/11 20:44:36 pete Exp
 * Obj3dBorder.c,v
 * Revision 2.2  1992/07/11  20:44:36  pete
 * Forgot to remove "toggles.h."
 *
 * Revision 2.1  1992/07/11  20:01:13  pete
 * Adopted use of XoDrawShadowRect() from FWF.
 *
 * Revision 2.0  1992/04/23  02:51:36  ware
 * First public release.
 *
 * Revision 1.10  1992/04/23  02:18:41  ware
 * Added several classes.  Worked on geometry management
 *
 * Revision 1.9  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.8  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.7  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.6  1991/10/19  01:49:18  pete
 * Pass the Object to XtGetGC() and XtReleaseGC() instead of the parent.
 * Worse, I was inconsistent between the two calls.
 *
 * Revision 1.5  1991/08/26  11:58:00  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.4  1991/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.3  91/06/01  10:03:18  pete
 * Working on menubar
 *
 * Revision 1.2  91/05/22  17:49:42  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.1  91/05/15  08:56:44  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/Obj3dBP.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/Obj3dBRec.h>

XoProto (static void, GetGC, (Widget gw));
/*
 * Redraw the border.  Don't attempt to determine the minimum
 * amount of work, just do it.
 */

static void
Redisplay (gw, event, region)
	Widget          gw;		/* should be subclassof ObjDraw */
	XEvent         *event;		/* the exposure event */
	Region          region;		/* the uncovered region */
{
	XoObj3dBorderWidget w = (XoObj3dBorderWidget) gw;

	if (w->obj_draw.no_draw)
		return;
	/*
	 * If the width causes things to overlap, don't bother to draw.
	 */
	if (w->rectangle.border_width * 2 >= w->rectangle.width
	    || w->rectangle.border_width * 2 >= w->rectangle.height)
		return;
	if (w->obj_border.inverted && w->obj_border.clear_inverted)
	{
		return;
	}

	XoDrawShadowRect (XtDisplayOfObject (gw), XtWindowOfObject (gw),
			  w->obj_3d_border.highlight_gc,
			  w->obj_3d_border.shadow_gc,
			  w->rectangle.x, w->rectangle.y,
			  w->rectangle.width, w->rectangle.height,
			  w->rectangle.border_width, 135*60, !w->obj_border.inverted);
}

/*
 * Initialize an instance of this object.  We allocate the GC's needed
 * to draw the highlight and shadow edges.
 */
static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* args passed to create */
	Cardinal       *num_args;	/* number of arguments */
{
	XoObj3dBorderWidget w = (XoObj3dBorderWidget) new;
	Arg             args[10];
	Cardinal        cnt;
	Pixel           bg;

	bg = w->obj_3d_border.def_background;
	if (XtClass (new) == xoObj3dBorderWidgetClass)
		_XoInheritedGet (XtParent (new), new);

	w->obj_3d_border.highlight_gc = NULL;
	w->obj_3d_border.shadow_gc = NULL;
	GetGC (new);
	if (XoWidgetIsColor (new))
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNbackground, bg);
		++cnt;
		XtSetValues (XtParent (new), args, cnt);
	}
}


static void
Destroy (gw)
	Widget          gw;
{
	XoObj3dBorderWidget w = (XoObj3dBorderWidget) gw;

	if (w->obj_3d_border.highlight_gc)
		XtReleaseGC ((Widget) w, w->obj_3d_border.highlight_gc);
	if (w->obj_3d_border.shadow_gc)
		XtReleaseGC ((Widget) w, w->obj_3d_border.shadow_gc);
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoObj3dBorderWidget w = (XoObj3dBorderWidget) new;
	XoObj3dBorderWidget cur = (XoObj3dBorderWidget) current;
	Boolean         redisplay = False;
	Boolean         calc_gc = False;

	DBUG_ENTER ("Obj3dBorder.SetValues");
	if (w->obj_3d_border.bevel_highlight != cur->obj_3d_border.bevel_highlight)
	{
		redisplay = True;
		calc_gc = True;
	}
	if (w->obj_3d_border.bevel_shadow != cur->obj_3d_border.bevel_shadow)
	{
		redisplay = True;
		calc_gc = True;
	}
	if (calc_gc)
		GetGC (new);
	if (w->obj_border.inverted != cur->obj_border.inverted)
	{
		DBUG_PRINT ("border", ("Border for %s is now %s",
				       XoName (new), w->obj_border.inverted ? "inverted" : "normal"));
		if (!XtIsRealized (new))
			redisplay = True;
		else if (w->obj_border.clear_inverted && w->obj_border.inverted)
		{
			DBUG_PRINT ("border", ("Clearing %s", XoName (new)));
			XClearArea (XtDisplayOfObject ((Widget) w),
				    XtWindowOfObject ((Widget) w),
				    w->rectangle.x, w->rectangle.y,
				    (unsigned int) w->rectangle.border_width,
				    (unsigned int) w->rectangle.height,
				    False);	/* left side */
			XClearArea (XtDisplayOfObject ((Widget) w),
				    XtWindowOfObject ((Widget) w),
				    w->rectangle.x, w->rectangle.y,
				    (unsigned int) w->rectangle.width,
				    (unsigned int) w->rectangle.border_width,
				    False);	/* top side */
			XClearArea (XtDisplayOfObject ((Widget) w),
				    XtWindowOfObject ((Widget) w),
				    w->rectangle.x + w->rectangle.width - w->rectangle.border_width,
				    w->rectangle.y,
				    (unsigned int) w->rectangle.border_width,
				    (unsigned int) w->rectangle.height,
				    False);	/* right side */
			XClearArea (XtDisplayOfObject ((Widget) w),
				    XtWindowOfObject ((Widget) w),
				    w->rectangle.x,
				    w->rectangle.y + w->rectangle.height - w->rectangle.border_width,
				    (unsigned int) w->rectangle.width,
				    (unsigned int) w->rectangle.border_width,
				    False);	/* bottom side */
			redisplay = False;
		}
		else
		{
			redisplay = False;
			_XoObjRedraw (new, (XEvent *) NULL, (Region) NULL);
		}
	}
	DBUG_RETURN (redisplay);
}

/*
 * Private procedures
 */


static void
GetGC (gw)
	Widget          gw;		/* the widget to calc gc for */
{
	XoObj3dBorderWidget w = (XoObj3dBorderWidget) gw;
	XGCValues       values;		/* filled in for gc values */

	if (w->obj_3d_border.highlight_gc)
		XtReleaseGC ((Widget) w, w->obj_3d_border.highlight_gc);
	values.foreground = w->obj_3d_border.bevel_highlight;
	w->obj_3d_border.highlight_gc = XtGetGC (gw, GCForeground, &values);

	if (w->obj_3d_border.shadow_gc)
		XtReleaseGC ((Widget) w, w->obj_3d_border.shadow_gc);
	values.foreground = w->obj_3d_border.bevel_shadow;
	w->obj_3d_border.shadow_gc = XtGetGC (gw, GCForeground, &values);
}
