/*
 * ConsBase.c,v 2.2 1992/08/11 00:12:18 pete Exp
 * ConsBase.c,v
 * Revision 2.2  1992/08/11  00:12:18  pete
 * Added stdio.h.   Added resize_flag for bad geometry managers.
 *
 * Revision 2.1  1992/07/11  19:58:44  pete
 * Added extension to handle Objects as children.  Added Border.
 *
 * Revision 2.0  1992/04/23  02:50:47  ware
 * First public release.
 *
 * Revision 1.6  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.5  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.4  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.3  1991/12/01  16:15:59  pete
 * Added traversal callback and installation of in Initialize.  Added
 * geometry management so the application can place and size widgets
 * as desired.  Added sorting so children can be arbitrarly ordered at
 * run time.
 *
 * Revision 1.2  1991/08/26  11:57:45  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.1  91/07/19  00:58:43  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ConsBaseP.h>

/*
 * Tell the intrinsics that this widget class accepts
 * objects as children.
 */

CompositeClassExtensionRec _XoConsExtensionRec =
	{
	NULL, NULLQUARK, XtCompositeExtensionVersion,
	sizeof (CompositeClassExtensionRec), True
	};

#include <X11/Xo/ConsBRec.h>

XoProto (static void, Layout, (Widget gw));

#define CON(w) ((XoConsBaseConstraint)(w)->core.constraints)
#define KEY(w) (CON(w)->cons_base.sort_order)

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInit - Insure that the traverse callback method is properly
 *		inherited
 */

static void
ClassPartInit (class)
	WidgetClassRec *class;
{
	XoConsBaseClassRec *c = (XoConsBaseClassRec *) class;
	XoConsBaseClassRec *super;

	super = (XoConsBaseClassRec *) c->core_class.superclass;
	if (c->cons_base_class.traverse == XtInheritTraversalProc)
	{
		c->cons_base_class.traverse =
			super->cons_base_class.traverse;
	}
}

/*
 * Initialize	- Called once each time a widget is created.  Used to
 *		insure any private (non-resource) fields are properly
 *		initialized and also possibly some default geometry.
 *
 *		This one sets the flag to indicate
 *		children are currently in the correct order (true since there
 *		are none and InsertChild places them in  order).  It also
 *		installs the appropriate traverse callback.
 */
static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoConsBaseWidget w = (XoConsBaseWidget) new;
	Cardinal	cnt;
	Arg		args[10];

	w->cons_base.reorder = False;
	if (ThisClass (new).cons_base_class.traverse
	    && XtHasCallbacks (new, XtNtraverse) != XtCallbackHasSome)
	{
		XtAddCallback (new, XtNtraverse,
			       ThisClass (new).cons_base_class.traverse,
			       (XtPointer) NULL);
	}
	if (w->cons_base.border_class)
	{
		/*
		 * FIX: Need to pass appropriate args along to the widget.
		 * Probably need to create it (so the border widget has a
		 * chance to indicate it's resoruces and then set them
		 * appropriately.
		 */
		cnt = 0;
		w->cons_base.border_widget =
			XtCreateWidget ("border", w->cons_base.border_class,
					(Widget) w, args, cnt);
		_XoInheritedSet (new, w->cons_base.border_widget,
				 arglist, num_args);
	}
}

/*
 * SetValues	- Reorder the children if do_layout == True and
 *		reorder == True.  Set reorder to False after
 *		children are sorted.  If do_layout changes (and is true), call
 *		core.change_managed to layout children.  This is
 *		done after they  have been sorted.  If the foregorund
 *		color changes, indicate we need to redisplay.
 */

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied, no set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoConsBaseWidget w = (XoConsBaseWidget) new;
	XoConsBaseWidget cur = (XoConsBaseWidget) current;
	Boolean         redisplay = False;

	if (w->cons_base.do_layout && w->cons_base.reorder)
	{
		(*ThisClass (new).cons_base_class.sort) ((Widget) w);
		w->cons_base.reorder = False;
	}
	if (w->cons_base.do_layout != cur->cons_base.do_layout
	    && w->cons_base.do_layout)
	{
		(*ThisClass (new).composite_class.change_managed) ((Widget) w);
	}
	if (w->cons_base.fg != cur->cons_base.fg)
	{
		redisplay = True;
	}
	if (w->cons_base.border_widget != cur->cons_base.border_widget)
	{
		redisplay = True;
		if (cur->cons_base.border_widget)
		{
			XtDestroyWidget (cur->cons_base.border_widget);
		}
	}
	_XoInheritedSet (new, w->cons_base.border_widget, args, num_args);
	return redisplay;
}

/*
 *----------------------------------------------------------------------
 * Composite Class Methods
 *----------------------------------------------------------------------
 */

/*
 * InsertChild	- Place child into a list of children sorted by the
 *		sort_order constraint field.  Children of equal
 *		sort_order are added at the end.
 */

static void
InsertChild (child)
	Widget          child;
{
	int             i;
	XoConsBaseWidget w = (XoConsBaseWidget) XtParent (child);
	Widget          save;

	_XoChildRoom ((Widget) w);
	for (i = 0; i < w->composite.num_children - 1; i++)
	{
		if (KEY (w->composite.children[i]) > KEY (child))
			break;
	}
	while (i < w->composite.num_children)
	{
		save = w->composite.children[i];
		w->composite.children[i++] = child;
		child = save;
	}
}

/*
 * GeometryManager - Responds to request for changes in size of position
 *		of children.  (See pp 228 of Asente & Swick).  This
 *		one grants all requests to change size and position --
 *		allowing the application complete control over
 *		layout.
 */

static XtGeometryResult
GeometryManager (gw, request, geo_ret)
	Widget          gw;
	XtWidgetGeometry *request;
	XtWidgetGeometry *geo_ret;
{
	XoConsBaseWidget w = (XoConsBaseWidget) XtParent (gw);

	if (request->request_mode & XtCWQueryOnly)
		return XtGeometryYes;
	/*
	 * Make the changes (always).
	 */
	XtMoveWidget (gw, request->x, request->y);
	XtResizeWidget (gw, request->width, request->height,
			request->border_width);

	Layout ((Widget) w);
	return XtGeometryDone;
}

/*
 * ChangeManaged - Called when one or more children are managed or
 *		unmanaged.  This one uses Layout() to do the work
 *		which first checks if do_layout is true, moves
 *		each of the children to the correct x&y location and
 *		then asks the parent to resize to fit furthest child
 *		to the right and furthest child down.
 */
static void
ChangeManaged (gw)
	Widget          gw;
{
	Layout (gw);
}

/*
 *----------------------------------------------------------------------
 * Constraint Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ConstraintSetValues - Handle changes to sorting order of children.
 *		if do_layout is True, then the children are sorted
 *		and change_managed is called to rearrange them appropriately.
 *		if do_layout is not set, it sets reorder to true so when
 *		the call to SetValues() changes do_layout to True the
 *		same steps can take place.
 */
static Boolean
ConstraintSetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoConsBaseConstraint c_new;	/* new constraints */
	XoConsBaseConstraint c_old;	/* original constraings */
	XoConsBaseWidgetClass c;	/* this widget class */
	XoConsBaseWidget w;

	c_new = (XoConsBaseConstraint) current->core.constraints;
	c_old = (XoConsBaseConstraint) new->core.constraints;

	if (c_new->cons_base.sort_order != c_old->cons_base.sort_order)
	{
		w = (XoConsBaseWidget) XtParent (new);
		c = (XoConsBaseWidgetClass) XtClass (w);
		if (w->cons_base.do_layout)
		{
			(*c->cons_base_class.sort) ((Widget) w);
			(*c->composite_class.change_managed) ((Widget) w);
			w->cons_base.reorder = False;
		}
		else
		{
			w->cons_base.reorder = True;
		}
	}
	return False;
}

/*
 *----------------------------------------------------------------------
 * ConsBase Class Methods
 *----------------------------------------------------------------------
 */

/*
 * Implements a simple insertion sort.  The assumption is that the widgets
 * are generally already sorted and the number of widgets is typically
 * small.  If this is called on an already sorted list, it is an O(n)
 * running time.  On an unsorted list this is O(n**2).
 */

static void
SortChildren (gw)
	Widget          gw;
{
	int             i, j;
	XoConsBaseWidget w = (XoConsBaseWidget) gw;
	Widget          key;
	Widget         *list;		/* list of children */
	int             size;		/* size of the list */

	size = w->composite.num_children;
	list = w->composite.children;

	for (j = 1; j < size; j++)
	{
		/* Insert list[j] into the sorted sequence [0 .. j-1] */
		key = list[j];
		for (i = j - 1; i >= 0 && KEY (list[i]) > KEY (key); i--)
		{
			list[i + 1] = list[i];
		}
		list[i + 1] = key;
	}
}

/*
 *----------------------------------------------------------------------
 * Private procudures.
 *----------------------------------------------------------------------
 */

/*
 * Layout	- Implements Simple policy of trying to resize to
 *		fit the child furthest to the right and the child furthest
 *		down.  Does not attempt to request a change in the x or y
 *		direction even if some children have negative x, y.
 */

static void
Layout (gw)
	Widget          gw;
{
	XoConsBaseWidget w = (XoConsBaseWidget) gw;
	Widget          child;
	int             i;
	Dimension       width;		/* how wide we should be */
	Dimension       height;		/* how tall we should be */

	if (w->cons_base.do_layout)
	{
		width = height = 0;
		for (i = 0; i < w->composite.num_children; i++)
		{
			child = w->composite.children[i];
			if (child->core.x + child->core.width > width)
				width = child->core.x + child->core.width;
			if (child->core.y + child->core.height > height)
				height = child->core.y + child->core.height;
		}
		if (width != w->core.width ||
		    height != w->core.height)
		{
			/*
			 * Set a flag so we know if the Resize Method has
			 * been called.  It is set to True by Resize().  If
			 * it is still False, then call Resize() by hand.
			 */
			w->cons_base.resize_flag = False;

			/*
			 * See if parent will grow to this size
			 */
			XtMakeResizeRequest ((Widget) w, width, height,
				    (Dimension *) NULL, (Dimension *) NULL);
			if (!w->cons_base.resize_flag)
			{
				ThisClass(w).core_class.resize (gw);
			}
		}
	}
}


