/*
 * CompBase.c,v 2.2 1992/08/11 00:11:54 pete Exp
 * CompBase.c,v
 * Revision 2.2  1992/08/11  00:11:54  pete
 * Added stdio.h
 *
 * Revision 2.1  1992/07/11  19:58:41  pete
 * Added extension to handle Objects as children.  Added Border.
 *
 * Revision 2.0  1992/04/23  02:50:44  ware
 * First public release.
 *
 * Revision 1.6  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.5  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.4  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.3  1991/08/26  11:57:44  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  1991/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.1  91/05/15  08:56:48  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/CompBaseP.h>

#include <X11/Xo/CompBRec.h>

/*
 * Tell the intrinsics that this widget class accepts
 * objects as children.
 */

CompositeClassExtensionRec _XoCompExtensionRec =
	{
	NULL, NULLQUARK, XtCompositeExtensionVersion,
	sizeof (CompositeClassExtensionRec), True
	};

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInit - Insure that the traverse callback method is properly
 *		inherited
 */

static void
ClassPartInit (class)
	WidgetClassRec *class;
{
	XoCompBaseClassRec *c = (XoCompBaseClassRec *) class;
	XoCompBaseClassRec *super;

	super = (XoCompBaseClassRec *) c->core_class.superclass;
	if (c->comp_base_class.traverse == XtInheritTraversalProc)
	{
		c->comp_base_class.traverse =
			super->comp_base_class.traverse;
	}
}

/*
 * Initialize - Install the callback for traversals.
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoCompBaseWidget	w = (XoCompBaseWidget) new;
	Arg		args[10];
	Cardinal	cnt;

	if (ThisClass (new).comp_base_class.traverse
	    && XtHasCallbacks (new, XtNtraverse) != XtCallbackHasSome)
	{
		XtAddCallback (new, XtNtraverse,
			       ThisClass (new).comp_base_class.traverse,
			       (XtPointer) NULL);
	}
	if (w->comp_base.border_class)
	{
		/*
		 * FIX: Need to pass appropriate args along to the widget.
		 * Probably need to create it (so the border widget has a
		 * chance to indicate it's resoruces and then set them
		 * appropriately.
		 */
		cnt = 0;
		w->comp_base.border_widget =
			XtCreateWidget ("border", w->comp_base.border_class,
					(Widget) w, args, cnt);
		_XoInheritedSet (new, w->comp_base.border_widget,
				 arglist, num_args);
	}
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* args applied, not set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoCompBaseWidget  w = (XoCompBaseWidget) new;
	XoCompBaseWidget  cur = (XoCompBaseWidget) current;
	Boolean         redisplay = False;

	if (w->comp_base.border_widget != cur->comp_base.border_widget)
	{
		redisplay = True;
		if (cur->comp_base.border_widget)
		{
			XtDestroyWidget (cur->comp_base.border_widget);
		}
	}
	_XoInheritedSet (new, w->comp_base.border_widget, args, num_args);
	return redisplay;
}


/*
 *----------------------------------------------------------------------
 * Composite Class Methods
 *----------------------------------------------------------------------
 */

/*
 * GeometryManager - Responds to request for changes in size of position
 *		of children.  (See pp 228 of Asente & Swick).
 */

static XtGeometryResult
GeometryManager (gw, request, geo_ret)
	Widget          gw;
	XtWidgetGeometry *request;
	XtWidgetGeometry *geo_ret;
{
	return (XtGeometryNo);
}
