#
# intrinsic.spec,v 2.0 1992/04/23 02:50:15 ware Exp
#
class Core = {
	superclass = "";
	class_prefix = "";
	class_name = Core;
	nocode = True;
	guard = "_XtCore_h";
	guardP = "XtCoreP_h";
	#class_field = core_class;
	#inst_record = CorePart;
	#inst_field = core;
	purpose  = "This is the parent class of all widgets.  It
		    provides the information needed by the Intrinsics
		    to manage windows, resources, display, etc.
		    Understanding of this class is primarily needed by
		    widget writers and not so much application writers
		    or users.
		    ";
	# Define the names of the class and instance record
	class_record  core = {
		field = ("", WidgetClass, superclass,
		         "(WidgetClass) &$superclass_rec",
			 "pointer to superclass ClassRec",
			 "(WidgetClass) &$superclass_rec");
		field = ("", String, class_name, "\"$class_name\"",
			 "widget resource class name", "\"$class_name\"");
		field = ("", Cardinal, widget_size,
			 "sizeof($instance_rec_type)",
			 "size in bytes of widget record",
			 "sizeof($instance_rec_type)");
		field = ("", XtProc, class_initialize, ClassInitialize,
			 "class initialization proc", "NULL");
		field = ("", XtWidgetClassProc, class_part_initialize,
			 ClassPartInitialize, "dynamic initialization",
			 NULL);
		field = ("", XtEnum, class_inited, False,
			 "has class been initialized?", False);
		field = ("", XtInitProc, initialize, Initialize,
			 "initialize subclass fields", NULL);
		field = ("", XtArgsProc, initialize_hook, NULL,
		         "notify that initialize called", NULL);
		field = ("", XtRealizeProc, realize, Realize,
			 "XCreateWindow for widget", XtInheritRealize);
		field = ("", XtActionList, "actions", "ACTIONS",
			 "widget semantics name to proc map", "ACTIONS");
		field = ("", Cardinal, num_actions, "ACTIONNUM",
			 "number of entries in actions", "ACTIONNUM");
		field = ("", XtResourceList, resources, "resources",
			 "resources for subclass fields", resources);
		field = ("", Cardinal, num_resources, "XtNumber(resources)",
			 "number of entries in resources",
			 "XtNumber(resources)");
		field = ("", XrmClass, xrm_class, "NULLQUARK",
			 "resource class quarkified", "NULLQUARK");
		field = ("", Boolean, compress_motion, "True",
			 "compress MotionNotify for widget", "True");
		field = ("", XtEnum, compress_exposure, "True",
			 "compress Expose events for widget", "True");
		field = ("", Boolean, compress_enterleave, "True",
			 "compress enter and leave events", "True");
		field = ("", Boolean, visible_interest, "False",
			 "select for VisibilityNotify", "False");
		field = ("", XtWidgetProc, destroy, Destroy,
			 "free data for subclass pointers", "NULL");
		field = ("", XtWidgetProc, resize, "NULL",
			 "geom manager changed widget size",
			 "XtInheritResize");
		field = ("", XtExposeProc, expose, Redisplay,
			 "redisplay window", "XtInheritExpose");
		field = ("", XtSetValuesFunc, set_values, SetValues,
			 "set subclass resource values", "NULL");
		field = ("", XtArgsFunc, set_values_hook, "NULL",
			 "notify that set_values called", "NULL");
		field = ("", XtAlmostProc, set_values_almost,
			 "XtInheritSetValuesAlmost",
			 "set_values got Almost geo reply",
			 "XtInheritSetValuesAlmost");
		field = ("", XtArgsProc, get_values_hook,
			 "NULL", "notify that get_values called", "NULL");
		field = ("", XtAcceptFocusProc, accept_focus, "NULL",
			 "assign input focus to widget",
			 "XtInheritAcceptFocus");
		field = ("", XtVersionType, version, "XtVersion",
			 "version of intrinsics used", "XtVersion");
		field = ("", XtPointer, callback_private, "NULL",
			 "list of callback offsets", "NULL");
		field = ("", String, tm_table, "NULL", "state machine",
			 "NULL");
		field = ("", XtGeometryHandler, query_geometry, "NULL",
			 "return preferred geometry",
			 "XtInheritQueryGeometry");
		field = ("", XtStringProc, display_accelerator, "NULL",
			 "display your accelerator", "NULL");
		field = ("", XtPointer, extension, "NULL",
			 "pointer to extension record", "NULL");
	}

	instance core = {
		(Widget, self, "pointer to widget itself",
		 "", "", "", "", "", "")
		(WidgetClass, widget_class, "pointer to Widget's ClassRec",
		 "", "", "", "", "", "")
		(Widget, parent, "parent widget",
		 "", "", "", "", "", "")
		(XrmName, xrm_name, "widget resource name quarkified",
		 "", "", "", "", "", "")
		(Boolean, being_destroyed, "marked for destroy",
		 "", "", "", "", "", "")
		(XtCallbackList, destroy_callbacks, "who to call when widget destroyed",
		 "destroyCallback", "Callback", "Callback", "Callback",
		 "NULL", "List of callbacks executed when the widget is destroyed.
Inherited from Object.")
		(XtPointer, "constraints", "constraint record",
		 "", "", "", "", "", "")
		(Position, x, "window position",
		 "x", "Position", "Position", "Immediate", "0",
		 "The x coordinate of this widget relative to the parent.
Inherited from RectObj.")
		(Position, y, "window position",
		 "y", "Position", "Position", "Immediate", "0",
		 "The y coordinate of this widget relative to the parent.
Inherited from RectObj.")
		(Dimension, width, "window dimensions",
		 "width", "Width", "Dimension", "Immediate", "0",
		 "The width of this widget in pixels.
Inherited from RectObj.")
		(Dimension, height, "window dimensions",
		 "height", "Height", "Dimension", "Immediate", "0",
		 "The height of this widget in pixels.
Inherited from RectObj.")
		(Dimension, border_width, "window border width",
		 "borderWidth", "BorderWidth", "Dimension", "Immediate",
		  "0", "The width of the border in pixels.
Inherited from RectObj.")
		(Boolean, managed, "is widget geometry managed?",
		 "", "", "", "", "", "")
		(Boolean, sensitive, "is widget sensitive to user events",
		 "sensitive", "Sensitive", "Boolean", "Immediate",
		 "True", "Indicates if this widget accepts any input.  Set by
calls to XtSetSensitive().
Inherited from RectObj.")
		(Boolean, ancestor_sensitive, "are all ancestors sensitive?",
		 "ancestorSensitive", "Sensitive", "Boolean", "CallProc",
		 "XtCopyAncestorSensitive",
		 "Set to False when an ancestor of this widget is no longer
accepts input.  If this is true, it may be appropriate to visually indicate
this widget cannot accept input.
Inherited from RectObj.")
		(XtEventTable, event_table, "private to event dispatcher",
		 "", "", "", "", "", "")
		(XtTMRec, tm, "translation management",
		 "translations", "Translations", "TranslationTable",
		  "TranslationTable", XtInheritTranslations, "The translation table used by this widget
to determine how it behaves.")
		(XtTranslations, accelerators, "accelerator translations",
		 "accelerators", "Accelerators", "AcceleratorTable",
		 "TranslationTable", "NULL", "Translations that can be added
to other widgets and behave as if they occured in this widget.")
		(Pixel, border_pixel, "window border pixel",
		 "borderColor", "BorderColor", "Pixel", "String",
		 "XtDefaultForeground", "Color for the border of the window.")
		(Pixmap, border_pixmap, "window border pixmap or NULL",
		 "borderPixmap", "Pixmap", "Pixmap", "Immediate",
		 "XtUnspecifiedPixmap",
		 "The pixmap used to tile the window border")
		(WidgetList, popup_list, "list of popups",
		 "", "", "", "", "", "")
		(Cardinal, num_popups, "how many popups",
		 "", "", "", "", "", "")
		(String, name, "widget resource name",
		 "", "", "", "", "", "")
		("Screen *", screen, "window's screen",
		 "screen", "Screen", "Screen", "CallProc", "XtCopyScreen",
		 "Which of the screens this widget is displayed on")
		(Colormap, colormap, "colormap",
		 "colormap", "Colormap", "Colormap", "CallProc", "XtCopyFromParent",
		  "The colormap used when displaying this widget.")
		(Window, window, "window ID",
		 "", "", "", "", "", "")
		(Cardinal, depth, "number of planes in window",
		 "depth", "Depth", "Int", "CallProc", "XtCopyFromParent",
		  "The number of planes in the window of this widget")
		(Pixel, background_pixel, "window background pixel",
		 "background", "Background", "Pixel", "String", "XtDefaultBackground",
		 "The background color of the window.")
		(Pixmap, background_pixmap, "window background pixmap or NULL",
		 "backgroundPixmap", "Pixmap", "Pixmap", "Immediate",
		 "XtUnspecifiedpixmap",
		 "The pattern to use when drawing the background")
		(Boolean, visible, "is window mapped and not occluded?",
		 "", "", "", "", "", "")
		(Boolean, mapped_when_managed, "map window if it's managed?",
		 "mappedWhenManaged", "MappedWhenManaged", "Boolean",
		 "Immediate", "True", "If this is True, then the window is
automatically mapped when it is managed.  If it is False, then the window must
be mapped by the application.")
		}
	function void expose = {
		args = {
			(Widget, gw, "this widget")
			("XEvent *", event, "exposure event")
			(Region, region, "what area is exposed")
		}
	}
	function void class_initialize = {
		args = {# no arguments
		}
	}
	function void class_part_initialize = {
		args = {
			(WidgetClass, "class", "Class being initialized")
		}
	}
	function void initialize = {
		args = {
			(Widget, request, "newly created widget")
			(Widget, new, "the modified widget")
			(ArgList, arglist, "args passed to XtCreate")
			("Cardinal*", num_args, "number of arguments")
		}
	}
	function void initialize_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void realize = {
		args = {
			(Widget, widget, widget)
			("XtValueMask*", mask, mask)
			("XSetWindowAttributes*", attributes, attributes)
		}
	}
	function void destroy = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void resize = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void expose = {
		args = {
			(Widget, widget, widget)
			("XEvent*", event, event)
			(Region, region, region)
		}
	}
	function Boolean set_values = {
		args = {
			(Widget, old, old)
			(Widget, request, request)
			(Widget, new, new)
			(ArgList, arglist, arglist)
			("Cardinal*", num_args, num_args)
		}
	}
	function Boolean set_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void set_values_almost = {
		args = {
			(Widget, old, old)
			(Widget, new, new)
			("XtWidgetGeometry*", request, request)
			("XtWidgetGeometry*", reply, reply)
		}
	}
	function void get_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function Boolean accept_focus = {
		args = {
			(Widget, widget, widget)
			("Time*", time, time)
		}
	}
	function XtGeometryResult query_geometry = {
		args = {
			(Widget, widget, widget)
			("XtWidgetGeometry*", request, request)
			("XtWidgetGeometry*", reply, reply)
		}
	}
	function void display_acclelerator = {
		args = {
			(Widget, widget, widget)
			(String, str, str)
		}
	}
}

class Object = {
	superclass = "";
	class_name = "Object";
	nocode = True;
	guard = "_XtObject_h";
	guardP = "_Xt_ObjectP_h_";
	purpose = "
This is the parent of all objects used by the Xt Intrinsics.
Unfortunately, it was grafted on after the Core widget class was
implemented so things to do not exactly follow the usual Xt model of
inheritance.
";
	class_record object = {
		field = ("", WidgetClass, superclass,
			 "(WidgetClass) &$superclass_rec",
			 "pointer to superclass ClassRec",
			 "(WidgetClass) &$superclass_rec");
		field = ("", String, class_name, "\"$class_name\"",
			 "widget resource class name", "\"$class_name\"");
		field = ("", Cardinal, widget_size,
			 "sizeof($instance_rec_type)",
			 "size in bytes of widget record",
			 "sizeof($instance_rec_type)");
		field = ("", XtProc, class_initialize, "NULL",
			 "class initialization proc", "NULL");
		field = ("", XtWidgetClassProc, class_part_initialize,
			 "NULL", "dynamic initialization", "NULL");
		field = ("", XtEnum, class_inited, "False",
			 "has class been initialized?", "False");
		field = ("", XtInitProc, initialize, "NULL",
			 "initialize subclass fields", "NULL");
		field = ("", XtArgsProc, initialize_hook, "NULL",
			 "notify that initialize called", "NULL");
		field = ("", XtProc, obj1, "NULL", NULL, "(XtProc) NULL");
		field = ("", XtProc, "obj2", "NULL", "NULL", "(XtProc) NULL");
		field = ("", Cardinal, obj3, "NULL", "NULL", "0");
		field = ("", XtResourceList, resources, "resources",
			 "resources for subclass fields", "resources");
		field = ("", Cardinal, num_resources,
			 "XtNumber(resources)",
			 "number of entries in resources",
			 "XtNumber(resources)");
		field = ("", XrmClass, xrm_class, "NULLQUARK",
			 "resource class quarkified", "NULLQUARK");
		field = ("", Boolean, obj4, "NULL", "NULL", "False");
		field = ("", Boolean, obj5, "NULL", "NULL", "False");
		field = ("", Boolean, obj6, "NULL", "NULL", "False");
		field = ("", Boolean, obj7, "NULL", "NULL", "False");
		field = ("", XtWidgetProc, destroy, "NULL", "free data for subclass pointers", "NULL");
		field = ("", XtProc, obj8, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtProc, obj9, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtSetValuesFunc, set_values, "NULL", "set subclass resource values", "NULL");
		field = ("", XtArgsFunc, set_values_hook, "NULL", "notify that set_values called", "NULL");
		field = ("", XtProc, obj10, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtArgsProc, get_values_hook, "NULL", "notify that get_values called", "NULL");
		field = ("", XtProc, obj11, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtVersionType, version, "XtVersion", "version of intrinsics used", "XtVersion");
		field = ("", XtPointer, callback_private, "NULL", "list of callback offsets", "NULL");
		field = ("", String, obj12, "NULL", "NULL", "(String) NULL");
		field = ("", XtProc, obj13, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtProc, obj14, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtPointer, extension, "NULL", "pointer to extension record", "NULL");
		}
	instance object = {
		(Widget, self, "pointer to widget itself",
		 "", "", "", "", "", "")
		(WidgetClass, widget_class, "pointer to Widget's ClassRec",
		 "", "", "", "", "", "")
		(Widget, parent, "parent widget",
		 "", "", "", "", "", "")
		(XrmName, xrm_name, "widget resource name quarkified",
		 "", "", "", "", "", "")
		(Boolean, being_destroyed, "marked for destroy",
		 "", "", "", "", "", "")
		(XtCallbackList, destroy_callbacks, "who to call when widget destroyed",
		 "destroyCallback", "Callback", "Callback", "Callback",
		 "NULL", "List of callbacks executed when the widget is destroyed.
Inherited from Object.")
		(XtPointer, "constraints", "constraint record",
		 "", "", "", "", "", "")
	}
	function void class_initialize = {
		args = {# no arguments
		}
	}
	function void class_part_initialize = {
		args = {
			(WidgetClass, "class", "Class being initialized")
		}
	}
	function void initialize = {
		args = {
			(Widget, request, "newly created widget")
			(Widget, new, "the modified widget")
			(ArgList, arglist, "args passed to XtCreate")
			("Cardinal*", num_args, "number of arguments")
		}
	}
	function void initialize_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void destroy = {
		args = {
			(Widget, gw, widget)
		}
	}
	function Boolean set_values = {
		args = {
			(Widget, old, old)
			(Widget, request, request)
			(Widget, new, new)
			(ArgList, arglist, arglist)
			("Cardinal*", num_args, num_args)
		}
	}
	function Boolean set_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void get_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
}

class RectObj = {
	superclass = Object;
	class_name = RectObj;
	nosuperclass = true;	# set this so we do not inherit class variables
	nocode = True;
	guard = "_XtRect_h";
	guardP = "_Xt_RectObjP_h_";
	purpose = "
The \class{RectObj} adds x, y, width, height and several display
oriented methods to the Object class.  Subclasses of this are
typically referred to as gadgets.  The signficance is that subclasses
of RectObj are windowless widgets.  This has several ramifications.
";
	class_record rect = {
		field = ("", WidgetClass, superclass, "(WidgetClass) &$superclass_rec", "pointer to superclass ClassRec", "(WidgetClass) &$superclass_rec");
		field = ("", String, class_name, "\"$class_name\"", "widget resource class name", "\"$class_name\"");
		field = ("", Cardinal, widget_size, "sizeof($instance_rec_type)", "size in bytes of widget record", "sizeof($instance_rec_type)");
		field = ("", XtProc, class_initialize,"NULL", "class initialization proc", "NULL");
		field = ("", XtWidgetClassProc, class_part_initialize, "NULL", "dynamic initialization", "NULL");
		field = ("", XtEnum, class_inited, "False", "has class been initialized?", "False");
		field = ("", XtInitProc, initialize, "NULL", "initialize subclass fields", "NULL");
		field = ("", XtArgsProc, initialize_hook, "NULL", "notify that initialize called", "NULL");
		field = ("", XtProc, rect1, "NULL", NULL, "(XtProc) NULL");
		field = ("", XtPointer, "rect2", "NULL", "NULL", "(XtPointer) NULL");
		field = ("", Cardinal, "rect3", "NULL", "NULL",
		         "0");
		field = ("", XtResourceList, resources, "resources", "resources for subclass fields", "resources");
		field = ("", Cardinal, num_resources, "XtNumber(resources)", "number of entries in resources", "XtNumber(resources)");
		field = ("", XrmClass, xrm_class, "NULLQUARK", "resource class quarkified", "NULLQUARK");
		field = ("", Boolean, rect4, "NULL", "NULL", "False");
		field = ("", Boolean, rect5, "NULL", "NULL", "False");
		field = ("", Boolean, rect6, "NULL", "NULL", "False");
		field = ("", Boolean, rect7, "NULL", "NULL", "False");
		field = ("", XtWidgetProc, destroy, "NULL",
			 "free data for subclass pointers",
			 "NULL");
		field = ("", XtWidgetProc, resize, "NULL", "geom manager changed widget size", "XtInheritResize");
		field = ("", XtExposeProc, expose, NULL, "rediplay window",
		         XtInheritExpose);
		field = ("", XtSetValuesFunc, set_values, "NULL", "set subclass resource values", "NULL");
		field = ("", XtArgsFunc, set_values_hook, "NULL", "notify that set_values called", "NULL");
		field = ("", XtAlmostProc, set_values_almost, "XtInheritSetValuesAlmost", "set_values got Almost geo reply", "XtInheritSetValuesAlmost");
		field = ("", XtArgsProc, get_values_hook, "NULL", "notify that get_values called", "NULL");
		field = ("", XtProc, rect9, "NULL", "NULL", "(XtProc) NULL");
		field = ("", XtVersionType, version, "XtVersion", "version of intrinsics used", "XtVersion");
		field = ("", XtPointer, callback_private, "NULL", "list of callback offsets", "NULL");
		field = ("", String, rect10, "NULL", "NULL", "NULL");
		field = ("", XtGeometryHandler, query_geometry, "NULL", "return preferred geometry", XtInheritQueryGeometry);
		field = ("", XtProc, rect11, "NULL", "NULL", "NULL");
		field = ("", XtPointer, extension, "NULL", "pointer to extension record", "NULL");
		}
	instance rectangle = {
		(Position, x, "window position",
		 "x", "Position", "Position", "Immediate", "0",
		 "The x coordinate of this widget relative to the parent.
Inherited from RectObj.")
		(Position, y, "window position",
		 "y", "Position", "Position", "Immediate", "0",
		 "The y coordinate of this widget relative to the parent.
Inherited from RectObj.")
		(Dimension, width, "window dimensions",
		 "width", "Width", "Dimension", "Immediate", "0",
		 "The width of this widget in pixels.
Inherited from RectObj.")
		(Dimension, height, "window dimensions",
		 "height", "Height", "Dimension", "Immediate", "0",
		 "The height of this widget in pixels.
Inherited from RectObj.")
		(Dimension, border_width, "window border width",
		 "borderWidth", "BorderWidth", "Dimension", "Immediate",
		  "0", "The width of the border in pixels.
Inherited from RectObj.")
		(Boolean, managed, "is widget geometry managed?",
		 "", "", "", "", "", "")
		(Boolean, sensitive, "is widget sensitive to user events",
		 "sensitive", "Sensitive", "Boolean", "Immediate",
		 "True", "Indicates if this widget accepts any input.  Set by
calls to XtSetSensitive().
Inherited from RectObj.")
		(Boolean, ancestor_sensitive, "are all ancestors sensitive?",
		 "ancestorSensitive", "Sensitive", "Boolean", "CallProc",
		 "XtCopyAncestorSensitive",
		 "Set to False when an ancestor of this widget is no longer
accepts input.  If this is true, it may be appropriate to visually indicate
this widget cannot accept input.
Inherited from RectObj.")
	  }
	function void class_initialize = {
		args = {# no arguments
		}
	}
	function void class_part_initialize = {
		args = {
			(WidgetClass, "class", "Class being initialized")
		}
	}
	function void initialize = {
		args = {
			(Widget, request, "newly created widget")
			(Widget, new, "the modified widget")
			(ArgList, arglist, "args passed to XtCreate")
			("Cardinal*", num_args, "number of arguments")
		}
	}
	function void initialize_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void destroy = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void resize = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void expose = {
		args = {
			(Widget, widget, widget)
			("XEvent*", event, event)
			(Region, region, region)
		}
	}
	function Boolean set_values = {
		args = {
			(Widget, old, old)
			(Widget, request, request)
			(Widget, new, new)
			(ArgList, arglist, arglist)
			("Cardinal*", num_args, num_args)
		}
	}
	function Boolean set_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function void set_values_almost = {
		args = {
			(Widget, old, old)
			(Widget, new, new)
			("XtWidgetGeometry*", request, request)
			("XtWidgetGeometry*", reply, reply)
		}
	}
	function void get_values_hook = {
		args = {
			(Widget, gw, "widget")
			(ArgList, arglist,	"args")
			("Cardinal*", num_args, "num_args")
		}
	}
	function XtGeometryResult query_geometry = {
		args = {
			(Widget, widget, widget)
			("XtWidgetGeometry*", request, request)
			("XtWidgetGeometry*", reply, reply)
		}
	}
}

class Composite = {
	superclass = Core;
	class_name = Composite;
	nocode = True;
	guard = "_XtComposite_h";
	guardP = "_XtCompositeP_h";
	purpose = "
This class allows other widgets to be it's children.
";
	class_record composite = {
		field = ("", XtGeometryHandler, "geometry_manager", "GeometryHandler", "geometry manager for children",
			 XtInheritGeometryManager);
		field = ("", XtWidgetProc, "change_managed", "ChangeManaged",
			 "change managed state of child",
			 "XtInheritChangeManaged");
		field = ("", XtWidgetProc, "insert_child", "InsertChild",
			 "physically add child to parent",
			 "XtInheritInsertChild");
    		field = ("", XtWidgetProc, "delete_child", "DeleteChild",
			 "physically remove child", "XtInheritDeleteChild");
		field = ("", XtPointer, extension, "NULL",
			 "pointer to extension record", "NULL");
	}
	instance composite = {
		(WidgetList, children, "array of ALL widget children",
		"children", "ReadOnly", "WidgetList", "Immediate", "NULL",
		"A read only list of children of the widget.")
		(Cardinal, "num_children", "total number of widget children",
		"numChildren", "ReadOnly", "Cardinal", "Immediate", "NULL",
		"The number of children in \res{children}.")
		(Cardinal, "num_slots", "number of slots in children array",
		"", "", "", "", "",
		"The amount of space allocated for \res{children}.")
		(XtOrderProc, "insert_position", "compute position of new child",
		"insertPosition", "InsertPosition", "Function", "Immediate", "NULL",
		"Points to a function that should return the insertion order
for a widget.  The declaration is
\begin{verbatim}
	Cardinal OrderProc (Widget gw);
\end{verbatim}
it should return a number indicating how many children should go
before the widget.  Return zero indicates that the widget should go
before all other children, and returning \code{num\_children} indicates
that it should go after all other children.  The default
\res{insertPosition} returns \code{num\_children}.")
	}
	function XtGeometryResult geometry_manager = {
		args = {
			(Widget, widget, widget)
			("XtWidgetGeometry*", request, request)
			("XtWidgetGeometry*", reply, reply)
		}
	}
	function void change_managed = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void insert_child = {
		args = {
			(Widget, gw, widget)
		}
	}
	function void delete_child = {
		args = {
			(Widget, gw, widget)
		}
	}
}

class Constraint = {
	superclass = Composite;
	class_name = Constraint;
	nocode = True;
	guard = "_XtConstraint_h";
	guardP = "_XtConstraintP_h";
	purpose = "
This class allows other widgets to be it's children.
";
	class_record "constraint" = {
		field = ("", XtResourceList, resources, "constraintResources",
			 "constraint resource list", "constraintResources");
		field = ("", Cardinal, num_resources, "XtNumber(constraintResources)",
			 "number of constraints in list", "XtNumber(constraintResources)");
		field = ("", Cardinal, constraint_size, "sizeof($constraint_rec_type)",
			 "size of constraint record", "sizeof($constraint_rec_type)");
		field = ("", XtInitProc, initialize, ConstraintInitialize,
			 "constraint initialization", "NULL");
		field = ("", XtWidgetProc, destroy, ConstraintDestroy,
			 "constraint destroy proc", "NULL");
		field = ("", XtSetValuesFunc, set_values, ConstraintSetValues,
			 "constraint set_values proc", "NULL");
		field = ("", XtPointer, extension, NULL,
			"pointer to extension record", "NULL");
	}
	instance "constraint" = {
		(XtPointer, mumble, "No new fields, keep C compiler happy",
		"", "", "", "", "", "")
	}
	function void initialize = {
		args = {
			(Widget, request, "newly created widget")
			(Widget, new, "the modified widget")
			(ArgList, arglist, "args passed to XtCreate")
			("Cardinal*", num_args, "number of arguments")
		}
	}
	function void destroy = {
		args = {
			(Widget, gw, widget)
		}
	}
	function Boolean set_values = {
		args = {
			(Widget, old, old)
			(Widget, request, request)
			(Widget, new, new)
			(ArgList, arglist, arglist)
			("Cardinal*", num_args, num_args)
		}
	}
}

class Shell = {
	superclass = Composite;
	class_name = Shell;
	nocode = True;
	guard = "_XtShell_h";
	guardP = "_XtShellPrivate_h";
	purpose = "
Shell widgets hold an applications's top-level widgets to allow them
to communicate with the window manager.  Shells have been designed to
be as nearly invisible as possible.  Clients have to create them, but
they should never have to worry about sizes.
";
	class_record "shell" = {
		field = ("", XtPointer, extension, NULL, "pointer to extension record",
			 NULL);
	}
	instance "shell" = {
		(String, geometry, "geometry specification",
		 geometry, Geometry, String, Immediate, NULL,
		 "Specifies the x, y, width and height of this widget
with a specific format.")

		(XtCreateChildPopupChildProc, "create_popup_child_proc",
		 "method to make the child",
		 createPopupChildProc, CreatePopupChildProc, Function,
		 Immediate, NULL,
		 "Function called to make the popup widget.  This is
called by XtPopup().  NULL means to not execute the method.  The only
argument passed is this widget -- notably, there is no client\_data
passed so you cannot have any additional information.")
		(XtGrabGind, grab_kind, "grab to execute",
		 "", "", "", "", "",
		 "Internal value that is initialized by the call to XtPopup().")
		(Boolean, "spring_loaded", "is this spring loaded",
		 "", "", "", "", "",
		 "Internal flag set by XtPopupSpringLoaded() to indicate this
is popped up by a button down event.")
		(Boolean, popped_up, "popped up",
		 "", "", "", "", "",
		 "Internal flag set to indicate this shell is already
popped up.  Set by XtPopup() and cleared by XtPopdown().  There is a
\Ws\ public function, \Ws IsPoppedUp() that returns the value of this field.")
		(Boolean, allow_shell_resize, "request new sizes from child",
		 allowShellResize, AllowShellResize, Boolean, Immediate, False,
		 "Controls wheter the widget contained by the child is
allowed to try to resize itself.  If allow\_shell\_resize is False,
any geometry requests made by the child will always return
XtGeometryNo without interacting with the window manager.")
		(Boolean, client_specified, "internal state",
		 "", "", "", "", "",
		 "Internal state.  Probably indicates or of
\_XtShellPositionValid (1), \_XtShellNotReparented (2),
\_XtShellPPositionOK (4), \_XtShellGeometryParsed (8).")
		(Boolean, save_under, "tell server to try save under",
		 saveUnder, SaveUnder, Boolean, Immediate, False,
		 "Instructs the server to attempt
to save the contents of windows obscured by the shell when it is
mapped (popped up) and to restore those contents when the shell is
unmapped.  It is useful for pop-up menus.")
		(Boolean, override_redirect, "if window manager can effect",
		 overrideRedirect, OverrideRedirect, Boolean, Immediate, False,
		 "Determines whether the window manager can intercede
when the shell window is mapped.")
		(XtCallbackList, popup_callback, "executed on popup",
		 popupCallback, Callback, Callback, Immediate, NULL,
		 "Called during XtPopup().")
		(XtCallbackList, popdown_callback, "executed on popdown",
		 popdownCallback, Callback, Callback, Immediate, NULL,
		 "Called during XtPopdown().")
		("Visual *", visual, "visual to use",
		 visual, Visual, Visual, Immediate, "(XtPointer) CopyFromParent",
		 "The visual to use for this widget and all of it's children")
	}
}

class OverrideShell = {
	superclass = Shell;
	class_name = OverrideShell;
	nocode = True;
	private_include = "Shell";
	public_include = "Shell";
	guard = "_XtShell_h";
	guardP = "_XtShellPrivate_h";
	purpose = "
Used for shell windows that completely bypass the window manager (for
example, pop-up menu shells).
";
	class_record "override_shell" = {
		field = ("", XtPointer, extension, NULL, "pointer to extension record",
			 NULL);
	}
	instance "override_shell" = {
		(int, emptry, "keep compiler happy", "", "", "", "", "", "")
	}
}
