/*
 * output.c,v 2.0 1992/04/23 02:47:50 ware Exp
 *
 * output.c,v
 * Revision 2.0  1992/04/23  02:47:50  ware
 * First public release.
 *
 * Revision 1.20  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.19  1991/12/01  16:11:45  pete
 * Fixed bug in output_cpp_include() that caused the ifndef to use
 * the name without ".h".  Added feature so class can define it's own
 * "guard" symbol.  Needd for the intrinsic's header files.
 *
 * Revision 1.18  1991/11/30  16:54:09  pete
 * Changed output_cpp_include() to make ifdef optional.  Better for docs.
 *
 * Revision 1.17  1991/08/30  11:19:03  pete
 * Changed output_actions_code() to use XoProto() instead of surrounding
 * it with ifdef's NeedFunctionPrototypes.
 *
 * Revision 1.16  91/08/26  11:25:11  pete
 * Use XoProto() to handle conditional compilation of function prototypes.
 * Implemented output of constraint records.  Force file names to be
 * limited in length.  Wrap the inclusion of file names in ifdef's to
 * improve compile time efficiency.  Allow the name of the include file
 * to be overriden.  Write out the complete summary instead of relying on
 * including the file multiple times.  Allow default values to be overridden.
 * 
 * Revision 1.15  91/06/14  04:53:28  pete
 * Made output_cpp_include() a global function.  It's needed in the
 * output_tex() functions to document the public include file.
 * 
 * Revision 1.14  91/05/29  14:39:41  pete
 * Only declare resources if there are some
 * 
 * Revision 1.13  1991/05/14  18:05:41  pete
 * Do not make a backup copy if file did not change
 *
 * Revision 1.12  91/05/09  17:08:46  pete
 * Fixed a typo in output the Action record.
 * 
 * Revision 1.11  91/05/08  17:12:01  pete
 * Add declaration of the calss ariable.  Avoid dumping superclass for
 * RectObj.
 * 
 * Revision 1.10  91/05/07  14:53:15  pete
 * Added checks for "nocode" flag to keep intrinsic classes from generating
 * any .h files.  Fixed bug in output_resource_define() that was just
 * repeating the definition of the class and not any new resource.
 * 
 * Revision 1.9  1991/05/06  16:07:05  pete
 * A working version
 *
 * Revision 1.8  1991/05/03  18:53:04  pete
 * Output is working again.
 *
 * Revision 1.7  91/05/03  06:35:42  pete
 * Reached stage of it compiling
 * 
 * Revision 1.6  1991/05/02  17:15:43  pete
 * Compete rewrite
 *
 * Revision 1.5  91/05/02  15:22:10  pete
 * Working on output.
 * 
 * Revision 1.4  1991/04/11  05:02:13  pete
 * Added options so documentation and include files can be placed elsewhere.
 * Elminated the access field in the resource table so they can squeeze
 * on one line.
 *
 * Revision 1.3  1991/03/11  15:58:45  pete
 * Added actions and translations to grammar.
 *
 * Revision 1.2  1991/02/21  16:18:51  pete
 * Make the <Class>Rec.h output the correct definition of the resources
 * and initialize the class variables.
 *
 * Revision 1.1  1991/02/21  05:39:19  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "build.h"
#include "output.h"
#include "str_util.h"

XoProto (extern char *, index, (char *ptr, int ch));

#define VARINSTANCE	0
#define VARCLASS	1
#define VARCONSTRAINT	2
XoProto (static void, output_methods, (FILE *fptr, class_t *class));
XoProto (static void, output_args, (FILE *fptr, arg_list_t *args, int col));
XoProto (static void, output_record_part, (FILE *fptr, class_t *class, char **vars, int type));
XoProto (static void, output_field, (FILE *fptr, field_t *field));
XoProto (static void, output_class_record_full, (FILE *fptr, class_t *class));
XoProto (static void, output_instance_record_full, (FILE *fptr, class_t *class));
XoProto (static void, output_constraint_record_full, (FILE *fptr, class_t *class));
XoProto (static void, output_constraint_comment, (FILE *fptr, class_t *class));
XoProto (static void, output_resource_comment_start, (FILE *fptr));
XoProto (static void, output_resource_comment_class, (FILE *fptr, class_t *class));
XoProto (static void, output_resource_comment_line, (FILE *fptr, field_t *res, int override));
XoProto (static void, output_resource_comment, (FILE *fptr, class_t *class));
XoProto (static void, output_resource_c, (FILE *fptr, class_t *class, field_t *resource, int override));
XoProto (static void, declare_class_rec, (FILE *fptr, class_t *class, class_t *base));
XoProto (static void, name_resource_instance, (field_t *field, char *buf, char *value));
XoProto (static void, name_resource_class, (field_t *field, char *buf, char *value));
XoProto (static void, name_resource_res, (field_t *field, char *buf, char *value));
XoProto (static void, output_instance_defines, (FILE *fptr, class_t *class, void (*func)(), char **reslist));
XoProto (static int, output_defined, (class_t *class, char *name));
XoProto (static int, output_defined_globally, (char *name));
XoProto (static int, output_defined_locally, (class_t *class, char *name));
XoProto (static void, output_define_add, (class_t *class, char *name));
XoProto (static void, output_actions_code, (FILE *fptr, class_t *class));
XoProto (static void, output_translation_code, (FILE *fptr, class_t *class));
XoProto (static void, output_start_include, (FILE *fptr, char *prefix, char *name));
XoProto (static void, output_end_include, (FILE *fptr, char *prefix, char *name));
XoProto (static void, output_macroize, (char *word, char *define));
XoProto (static void, output_define, (FILE *fptr, char *name, char *value));
XoProto (static int, output_has_constraints, (class_t *class));

static Table	*GlobalDefines;

/*
 * Write out the <class>P.h file.
 */

int
output_includep (options, class)
options_t	*options;
class_t		*class;			/* the class to write */
{
	FILE		*fptr;		/* where to write */
	char		inc[2048];	/* name of the include file */
	char		filename[2048];
	char		tmp[2048];	/* for temporary  name */
	char		old[2048];	/* the old file name */
	class_t		*parent;	/* parent of this class */
	char		name[BUFSIZ];	/* for various names */
	char		*decl;		/* any public declarations */
	char		*include;
	int		diff = FALSE;

	if (!options)
	{
		fprintf (stderr, "Options are NULL\n");
		return (diff);
	}
	if (!options->opt_doinc)
	{
		return (diff);
	}
	if (!class)
	{
		fprintf (stderr, "Class is NULL\n");
		return (diff);
	}
	if (!class->cl_name || !*class->cl_name)
	{
		fprintf (stderr, "Class has no name\n");
		return (diff);
	}
	if (var_lookup (class->cl_vars, "nocode") != NULL)
	{
		return (diff);
	}
#define SUFFIX_INCLUDE_PRIV	"P.h"
	output_filename (class->cl_name, SUFFIX_INCLUDE_PRIV, tmp);
	sprintf (filename, "%s/%s", options->opt_incdir, tmp);
	fptr = output_open (filename, old);
	if (!fptr) 
	{
		return (diff);
	}
	sprintf (inc, "%sP.h", class->cl_name);
	/*
	 * Make sure the include file is wrapped in ifdefs.
	 */
	output_start_include (fptr, class->cl_name_set, inc);


	/*
	 * 1. Print the include files we will need, which is our parents
	 *    private include file and this classes public include file.
	 */
	parent = class_lookup (class->cl_superclass);
	if (parent && parent->cl_name)
	{
		include = var_lookup (parent->cl_vars, "private_include");
		if (!include)
			include = parent->cl_name;
		output_cpp_include (fptr, parent, include, "P", TRUE);
	}
	include = var_lookup (class->cl_vars, "public_include");
	if (!include)
		include = class->cl_name;
	output_cpp_include (fptr, class, include, "", TRUE);
	fprintf (fptr, "\n");

	/*
	 * 2. Print any initial definitions needed.
	 */
	if ((decl = var_lookup (class->cl_vars, "private_pre_defines")) != NULL)
	{
		fprintf (fptr, "%s\n", decl);
	}

	/*
	 * 3. Write the class part record.
	 */

	fprintf (fptr, "/*\n * %s's class record.\n */\n", class->cl_name);
	fprintf (fptr, "typedef struct\n{\n");
	output_record_part (fptr, class, class->cl_class_vars, VARCLASS);
	output_type (class, "ClassPart", name);
	fprintf (fptr, "} %s;\n", name);
	
	/*
	 * 4. Write the class record.  This is the concatenation of
	 *    this and the superclasses class part record.
	 */

	fprintf (fptr, "/*\n * Full class record for %s widget.\n */\n",
		 class->cl_name);
	fprintf (fptr, "typedef struct _");
	output_type (class, "ClassRec", name);
	fprintf (fptr, "%s\n{\n", name);
	output_class_record_full (fptr, class);
	fprintf (fptr, "} %s;\n\n", name);

	/*
	 * 5. Output the extern declaration of the class variable
	 */

	fprintf (fptr, "extern ");
	output_type (class, "ClassRec", name);
	fprintf (fptr, "%s\t", name);
	output_var (class, "ClassRec", name);
	fprintf (fptr, "%s;\n\n", name);

	/*
	 * 6. Write the instance part record.
	 */
	fprintf (fptr, "/*\n * %s's instance record.\n */\n", class->cl_name);
	fprintf (fptr, "typedef struct\n{\n");
	output_record_part (fptr, class, class->cl_instance_vars, VARINSTANCE);
	output_type (class, "Part", name);
	fprintf (fptr, "} %s;\n\n", name);

	/*
	 * 7. Write the complete instance record.
	 */
	fprintf (fptr, "/*\n * %s's complete instance record.\n */\n",
		 class->cl_name);
	output_type (class, "Rec", name);
	fprintf (fptr, "typedef struct _%s\n{\n", name);
	output_instance_record_full (fptr, class);
	fprintf (fptr, "} %s;\n", name);

	/*
	 * 8. Write the constraint part record, if one exists.
	 */
	if (class->cl_cons_field && *class->cl_cons_field)
	{
		fprintf (fptr, "/*\n * %s's partial constraint record.\n */\n",
			 class->cl_name);
		fprintf (fptr, "typedef struct\n{\n");
		output_record_part (fptr, class, class->cl_constraint_vars,
				    VARCONSTRAINT);
		output_type (class, "ConstraintPart", name);
		fprintf (fptr, "} %s;\n\n", name);
	}

	/*
	 * 9. Write the complete constraint record, if one exists.
	 */
	if (output_has_constraints (class))
	{
		fprintf (fptr, "/*\n * %s's complete constraint record.\n */\n",
			 class->cl_name);
		output_type (class, "ConstraintRec", name);
		fprintf (fptr, "typedef struct _%s\n{\n", name);
		output_constraint_record_full (fptr, class);
		fprintf (fptr, "} %s, ", name);
		output_type (class, "Constraint", name);
		fprintf (fptr, "*%s;\n", name);
	}

	/*
	 * 10. Print any after the fact definitions needed.
	 */
	if ((decl = var_lookup (class->cl_vars, "private_post_defines")) != NULL)
	{
		fprintf (fptr, "%s\n", decl);
	}

	/*
	 * Put whatever is needed at the end of an include file
	 */
	output_end_include (fptr, class->cl_name_set, inc);
	if (output_close (fptr, filename, old))
		diff = TRUE;
	return (diff);
}

/*
 * Write out the <class>.h file
 */

int
output_include (options, class)
options_t	*options;
class_t		*class;			/* the class to describe */
{
	FILE		*fptr;		/* where to write */
	char		inc[2048];	/* name of the include file */
	char		tmp[2048];	/* for temporary  name */
	char		old[2048];	/* name of the backup file */
	char		filename[2048];
	class_t		*parent;	/* parent of this class */
	char		name[BUFSIZ];	/* for various names */
	int		col;		/* current column */
	char		*decl;		/* any public declarations */
	int		nobackup;
	char		**reslist;	/* list of resources */
	char		*include;
	int		diff = FALSE;

	if (!options)
	{
		fprintf (stderr, "Options are NULL\n");
		return (diff);
	}
	if (!options->opt_doinc)
	{
		return (diff);
	}
	if (!class)
	{
		fprintf (stderr, "Class is NULL\n");
		return (diff);
	}
	if (!class->cl_name || !*class->cl_name)
	{
		fprintf (stderr, "Class has no name\n");
		return (diff);
	}
	/*
	 * An unfortunate kludge.  First check if we should not output
	 * any code for this class.  If not, we still need to get the
	 * #define's entered in for the resources.
	 */
	if (var_lookup (class->cl_vars, "nocode") != NULL)
	{
		fptr = fopen ("/dev/null", "w");
		nobackup = 1;
	}
	else
	{
#define SUFFIX_INCLUDE	".h"
		output_filename (class->cl_name, SUFFIX_INCLUDE, tmp);
		sprintf (filename, "%s/%s", options->opt_incdir, tmp);
		fptr = output_open (filename, old);
		nobackup = 0;
	}
	if (!fptr)
	{
		return (diff);
	}
	sprintf (inc, "%s.h", class->cl_name);

	/*
	 * Make sure the include file is wrapped in ifdefs.
	 */
	output_start_include (fptr, class->cl_name_set, inc);

	/*
	 * 1. Print the include files we will need, which is our parents
	 *    include file..
	 */
	parent = class_lookup (class->cl_superclass);
	if (parent && parent->cl_name)
	{
		include = var_lookup (parent->cl_vars, "private_include");
		if (!include)
			include = parent->cl_name;
		output_cpp_include (fptr, parent, include, "", TRUE);
	}
	fprintf (fptr, "\n");

	/*
	 * 2. Output any needed public declarations
	 */

	if ((decl = var_lookup (class->cl_vars, "public_pre_defines")) != NULL)
	{
		fprintf (fptr, "%s\n", decl);
	}

	/*
	 * 3. Describe the resources used by this widget.
	 */

	fprintf (fptr, "/*\n");
	output_resource_comment (fptr, class);
	fprintf (fptr, " */\n");

	/*
	 * 3.5. Describe any constraint parameters.
	 */
	if (output_has_constraints (class))
	{
		fprintf (fptr, "/*\n");
		output_constraint_comment (fptr, class);
		fprintf (fptr, " */\n");
	}

	/*
	 * 4. Declare the class variable.
	 */
	col = output_str (fptr, "extern WidgetClass", 0);
	col = output_goto (fptr, 32, col);
	output_var (class, "WidgetClass", name);
	col = output_str (fptr, name, col);
	col = output_str (fptr, ";\n\n", col);

	/*
	 * 5. Add some typedefs for the widget's structures.
	 */
	col = output_str (fptr, "typedef struct _", 0);
	output_type (class, "ClassRec", name);
	col = output_str (fptr, name, col);
	col = output_goto (fptr, 32, col);
	col = output_str (fptr, "*", col);
	output_type(class, "WidgetClass", name);
	col = output_str (fptr, name, col);
	col = output_str (fptr, ";\n", col);

	col = output_str (fptr, "typedef struct _", 0);
	output_type (class, "Rec", name);
	col = output_str (fptr, name, col);
	col = output_goto (fptr, 32, col);
	col = output_str (fptr, "*", col);
	output_type (class, "Widget", name);
	col = output_str (fptr, name, col);
	col = output_str (fptr, ";\n\n", col);

	/*
	 * 6. Write the defines names for resources and classes
	 */
	reslist = str_list_copy (class->cl_instance_vars);
	reslist = str_list_merge (reslist, class->cl_constraint_vars);
	str_list_sort (reslist);
	output_instance_defines (fptr, class, name_resource_instance, reslist);
	output_instance_defines (fptr, class, name_resource_class, reslist);
	output_instance_defines (fptr, class, name_resource_res, reslist);
	str_list_free (reslist);

	/*
	 * 7. Print any after the fact definitions needed.
	 */
	if ((decl = var_lookup (class->cl_vars, "public_post_defines")) != NULL)
	{
		fprintf (fptr, "%s\n", decl);
	}

	/*
	 * Put whatever is needed at the end of an include file
	 */
	output_end_include (fptr, class->cl_name_set, inc);

	if (nobackup)
	{
		if (fclose (fptr) < 0)
		{
			perror (filename);
		}
	}
	else
	{
		diff = output_close (fptr, filename, old);
	}
	return diff;
}

/*
 * Output a file that can be included and that describes the resources
 * and initializes the class.
 */

int
output_c (options, class)
options_t	*options;
class_t		*class;			/* class to describe */
{
	FILE		*fptr;		/* where to write */
	char		inc[2048];	/* name of the include file */
	char		old[2048];	/* name of the backup file */
	char		tmp[2048];	/* for temporary  name */
	char		filename[2048];
	char		name[1024];	/* for variables and types */
	int		col;		/* current column */
	char		**ptr;		/* pointer into list of names */
	field_t		*instance;	/* an instance variable */
	int		override;
	int		added_decl;	/* set when resources declared */
	int		diff = FALSE;

	if (!options)
	{
		fprintf (stderr, "Options are NULL\n");
		return (diff);
	}
	if (!options->opt_doinc)
	{
		return (diff);
	}
	if (!class)
	{
		fprintf (stderr, "Class is NULL\n");
		return (diff);
	}
	if (!class->cl_name || !*class->cl_name)
	{
		fprintf (stderr, "Class has no name\n");
		return (diff);
	}
	if (var_lookup (class->cl_vars, "nocode") != NULL)
	{
		return (diff);
	}
#define SUFFIX_REC	"Rec.h"
	output_filename (class->cl_name, SUFFIX_REC, tmp);
	sprintf (filename, "%s/%s", options->opt_incdir, tmp);
	fptr = output_open (filename, old);
	if (!fptr) 
	{
		return (diff);
	}
	sprintf (inc, "%sRec.h", class->cl_name);

	/*
	 * 1. Wrap the include file in ifdefs.  It could almost make sense
	 * to do this multiple times, but the variables would complain
	 * about being multiply defined.
	 */
	output_start_include (fptr, class->cl_name_set, inc);

	/*
	 * 2. Output the prototypes for the actions and
	 * the action table.
	 */
	output_actions_code (fptr, class);

	/*
	 * 3. Output the translation table
	 */
	if (class->cl_translations && class->cl_translations->tl_count > 0)
	{
		output_translation_code (fptr, class);
	}

	/*
	 * 4. Declare the resources
	 */
	output_type (class, "Widget", name);
	fprintf (fptr, "#define offset(field) XtOffset(%s, %s.field)\n",
		 name, class->cl_inst_field);
	added_decl = 0;
	for (ptr = class->cl_instance_vars; ptr && *ptr; ptr++)
	{
		instance = lookup_instance_var (class, *ptr, &override);
		if ((override = is_override (instance)))
		{
			instance = lookup_instance_override (class, instance);
		}
		if (instance  && instance->vf_name && *instance->vf_name)
		{
			if (!added_decl)
			{
				added_decl = 1;
				col = output_str (fptr,
						  "static XtResource resources[] = {\n", 0);
			}
			output_resource_c (fptr, class, instance, override);
		}
		if (override)
			instance_var_free (instance);
	}
	if (added_decl)
		output_str (fptr, "};\n", 0);
	fprintf (fptr, "#undef offset\n");

	/*
	 * 4.5. Output the constraint resources, if any
	 */
	added_decl = 0;
	for (ptr = class->cl_constraint_vars; ptr && *ptr; ptr++)
	{
		instance = lookup_constraint_var (class, *ptr, &override);
		if (is_override (instance))
		{
			override = 1;
		}
		if (instance && instance->vf_name && *instance->vf_name)
		{
			if (!added_decl)
			{
				added_decl = 1;
				output_type (class, "Constraint", name);
				fprintf (fptr, "#define offset(field) XtOffset(%s, %s.field)\n",
					 name, class->cl_cons_field);
				col = output_str (fptr, "static XtResource constraintResources[] = {\n", 0);
			}
			output_resource_c (fptr, class, instance, override);
		}
		if (override)
			instance_var_free (instance);
	}
	if (added_decl)
	{
		output_str (fptr, "};\n", 0);
		fprintf (fptr, "#undef offset\n");
	}
	
	/*
	 * 5. Output the declarations of any new methods.
	 */
	output_methods (fptr, class);

	/*
	 * 6. Output the class record.
	 */
	output_type (class, "ClassRec", name);
	col = output_str (fptr, name, 0);
	output_var (class, "ClassRec", name);
	col = output_str (fptr, " ", col);
	col = output_str (fptr, name, col);
	col = output_str (fptr, " = {\n", col);
	declare_class_rec (fptr, class, class);
	col = output_str (fptr, "};\n", col);
	output_var (class, "WidgetClass", name);
	fprintf (fptr, "WidgetClass %s = (WidgetClass) ", name);
	output_var (class, "ClassRec", name);
	fprintf (fptr, "&%s;\n", name);

	/*
	 * 7. Give some macros to make accessing class variables easier.
	 */
	fprintf (fptr, "\n/*\n * The following make it easier to access class methods.\n */\n");
	if (var_lookup (class->cl_vars, "superclass_rec"))
	{
		fprintf (fptr, "#define MySuperClass %s\n",
			 var_lookup (class->cl_vars, "superclass_rec"));
	}
	fprintf (fptr, "#define MyClass %s\n", name);
	output_type (class, "ClassRec", name);
	fprintf (fptr, "#define ThisSuperClass(gw) (*(%s *)XtSuperClass(gw))\n",
		 name);
	fprintf (fptr, "#define ThisClass(gw) (*(%s *)XtClass(gw))\n",
		 name);
	/*
	 * Put whatever is needed at the end of an include file
	 */

	output_end_include (fptr, class->cl_name_set, inc);
	diff = output_close (fptr, filename, old);
	return diff;
}

static void
output_methods (fptr, class)
FILE		*fptr;
class_t		*class;
{
	char		**ptr;		/* list of class variables */
	char		**l;
	field_t		*field;
	int		override;
	function_t	*method;
	class_t		*c;
	char		classname[512];
	char		fieldname[512];
	char		buf[BUFSIZ];
	int		col;

	if (!fptr || !class)
		return;
	l = str_list_copy (class->cl_class_vars);
	str_list_sort (l);
	for (ptr = l; ptr && *ptr; ptr++)
	{
		class_split (*ptr, classname, fieldname);
		if (classname[0])
			c = class_lookup (classname);
		else
			c = class;
		field = lookup_class_var (class, *ptr, &override);
		if (!field)
			continue;
		method = lookup_class_method (class, *ptr);
		if (method && field->vf_storage && *field->vf_storage)
		{
			/*
			 * FIX: Need to declare the prototype correctly
			 *	for the class the defines it.  This is wrong
			 *	to assume it is static.
			 */
			sprintf (buf, "XoProto (%s %s,",
				 field->vf_storage,
				 method->f_type);
			col = output_str (fptr, buf, 0);
#define METHOD_START_COL 24
			if (col > METHOD_START_COL)
				col = output_str (fptr, "\n", col);
			col = output_goto (fptr, METHOD_START_COL, col);
			col = output_str (fptr, field->vf_value, col);
			col = output_str (fptr, ", (", col);
			output_args (fptr, method->f_args, col);
			fprintf (fptr, "));\n");
		}
	}
	if (l)
		free ((char *)l);
}

static void
output_args (fptr, args, col)
FILE		*fptr;
arg_list_t	*args;
int		col;			/* current column */
{
	int		i;
	char		buf[BUFSIZ];
	char		pre[BUFSIZ];
	int		indent_to = col;

#define MAX_COLUMN 79
	if (!args)
	{
		fprintf (fptr, "void");
	}
	else
	{
		pre[0] = '\0';
		for (i = 0; i < args->al_count; i++)
		{
			sprintf (buf, "%s %s", args->al_list[i].a_type,
				 args->al_list[i].a_field);
			col = output_str (fptr, pre, col);
			strcpy (pre, ", ");
			if (col + strlen (buf) + strlen (pre) > MAX_COLUMN)
			{
				col = output_str (fptr, "\n", col);
				col = output_goto (fptr, indent_to, col);
			}
			col = output_str (fptr, buf, col);
		}
	}
}

static void
output_record_part (fptr, class, vars, type)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* this class */
char		**vars;			/* list of variables */
int		type;			/* whether a class or instance var */
{
	char		**ptr;		/* list of instance fields */
	field_t		dummy;		/* dummy field */
	field_t		*field;
	int		override;
	int		one = FALSE;

	for (ptr = vars; ptr && *ptr; ptr++)
	{
		if (type == VARINSTANCE)
			field = lookup_instance_var (class, *ptr, &override);
		else if (type == VARCLASS)
			field = lookup_class_var (class, *ptr, &override);
		else if (type == VARCONSTRAINT)
			field = lookup_constraint_var (class, *ptr, &override);
		else
			field = NULL;
		/*
		 * Do not output anything if this is an override field
		 */
		if (!is_override (field))
		{
			one = TRUE;
			output_field (fptr, field);
		}
	}
	if (!one)
	{
		dummy.vf_type = "int";
		dummy.vf_field = "dummy";
		dummy.vf_comment = "keep compiler happy";
		dummy.vf_default = "0";
		output_field (fptr, &dummy);
		return;
	}
}

static void
output_field (fptr, field)
FILE		*fptr;			/* where to write to */
field_t		*field;			/* what to write */
{
	int	col;			/* current column */

	if (!field || !fptr)
		return;
	col = output_goto (fptr, 8, 0);
	col = output_str (fptr, field->vf_type, col);
	col = output_goto (fptr, 24, col);
	col = output_str (fptr, field->vf_field, col);
	col = output_str (fptr, ";", col);
	if (!field->vf_comment || !*field->vf_comment)
	{
		col = output_str (fptr, "\n", col);
	}
	else
	{
		col = output_goto (fptr, 40, col);
		col = output_str (fptr, "/* ", col);
		col = output_str (fptr, field->vf_comment, col);
		col = output_str (fptr, " */\n", col);
	}
}

static void
output_class_record_full (fptr, class)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* the class */
{
	int	col;			/* current column */
	char	name[BUFSIZ];		/* unstylized version of class */
	class_t	*parent;		/* the parent superclass */

	if (!class)
		return;

	/*
	 * Dump all the superclasses info first.  If the variable
	 * "nosuperclass" is set, we skip th
	 */
	if ((parent = class_lookup (class->cl_superclass))
	    && var_lookup (class->cl_vars, "nosuperclass") == NULL)
	{
		output_class_record_full (fptr, parent);
	}
	/* output the type */
	col = output_goto (fptr, 8, 0);
	if (class->cl_name_set && *class->cl_name_set)
	{
		col = output_str (fptr, "X", col);
		col = output_str (fptr, class->cl_name_set, col);
	}
	col = output_str (fptr, class->cl_name, col);
	col = output_str (fptr, "ClassPart", col);
	col = output_goto (fptr, 24, col);

	/* output the name of the field */
	if (class->cl_class_field)
		col = output_str (fptr, class->cl_class_field, col);
	else
	{
		output_unstylized (class->cl_name, name);
		col = output_str (fptr, name, col);
	}
	col = output_str (fptr, "_class", col);
	col = output_str (fptr, ";", col);

	/* now add a comment */
	col = output_goto (fptr, 40, col);
	col = output_str (fptr, "/* the ", col);
	col = output_str (fptr, class->cl_name, col);
	col = output_str (fptr, " class variables */\n", col);
}

static void
output_instance_record_full (fptr, class)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* the class */
{
	int	col;			/* current column */
	char	name[BUFSIZ];		/* unstylized version of class */
	class_t	*parent;

	/*
	 * Dump all the parent's info first
	 */
	if ((parent = class_lookup (class->cl_superclass)))
	{
		output_instance_record_full (fptr, parent);
	}
	/* output the type */
	col = output_goto (fptr, 8, 0);
	output_type (class, "Part", name);
	col = output_str (fptr, name, col);
	col = output_goto (fptr, 24, col);

	/* output the name of the field */
	if (class->cl_inst_field)
		col = output_str (fptr, class->cl_inst_field, col);
	else
	{
		output_unstylized (class->cl_name, name);
		col = output_str (fptr, name, col);
	}
	col = output_str (fptr, ";", col);

	/* now add a comment */
	col = output_goto (fptr, 40, col);
	col = output_str (fptr, "/* the ", col);
	col = output_str (fptr, class->cl_name, col);
	col = output_str (fptr, " instance variables */\n", col);
}

static void
output_constraint_record_full (fptr, class)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* the class */
{
	int	col;			/* current column */
	char	name[BUFSIZ];		/* unstylized version of class */
	class_t	*parent;

	/*
	 * Dump all the parent's info first
	 */
	if ((parent = class_lookup (class->cl_superclass)))
	{
		output_constraint_record_full (fptr, parent);
	}
	/*
	 * If there are no constraints for this class, don't
	 * put anything
	 */
	if (!class->cl_cons_field || !*class->cl_cons_field)
		return;

	/* output the type */
	col = output_goto (fptr, 8, 0);
	output_type (class, "ConstraintPart", name);
	col = output_str (fptr, name, col);
	col = output_goto (fptr, 24, col);

	/*
	 * Output the name of the field.
	 */
	col = output_str (fptr, class->cl_cons_field, col);
	col = output_str (fptr, ";", col);

	/* now add a comment */
	col = output_goto (fptr, 40, col);
	col = output_str (fptr, "/* the ", col);
	col = output_str (fptr, class->cl_name, col);
	col = output_str (fptr, " constraint variables */\n", col);
}

/*
 * Write out a comment describing the resources available for
 * this widget.  Do it in superclass to subclass order.
 */
static void
output_resource_comment (fptr, class)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* class to describe */
{
	field_t		*res;		/* pointer to current resource */
	class_t		*parent;	/* parent superclass */
	char		**ptr;		/* for list of instance variables */
	int		override;
	char		**reslist;

	if (!fptr || !class)
		return;
	/*
	 * If there is no parent to this class, go ahead and output
	 * the starting comment
	 */
	parent = class_lookup (class->cl_superclass);
	if (!parent)
	{
		output_resource_comment_start (fptr);
	}
	else 
	{
		output_resource_comment (fptr, parent);
	}

	output_resource_comment_class (fptr, class);
	reslist = str_list_copy (class->cl_instance_vars);
	str_list_sort (reslist);
	for (ptr = reslist; ptr && *ptr; ptr++)
	{
		res = lookup_instance_var (class, *ptr, &override);
		output_resource_comment_line (fptr, res, override);
	}
	str_list_free (reslist);
}

/*
 * Write out a comment describing the constraint resources defined by
 * this widget.  Do it in superclass to subclass order.
 */
static void
output_constraint_comment (fptr, class)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* class to describe */
{
	field_t		*res;		/* pointer to current resource */
	class_t		*parent;	/* parent superclass */
	char		**ptr;		/* for list of instance variables */
	int		override;
	char		**reslist;

	if (!fptr || !class)
		return;
	/*
	 * If there is no parent to this class, go ahead and output
	 * the starting comment
	 */
	parent = class_lookup (class->cl_superclass);
	if (!parent)
	{
		fprintf (fptr, " * Constraint Parameters:\n *\n");
		output_resource_comment_start (fptr);
	}
	else 
	{
		output_constraint_comment (fptr, parent);
	}

	output_resource_comment_class (fptr, class);
	reslist = str_list_copy (class->cl_constraint_vars);
	str_list_sort (reslist);
	for (ptr = reslist; ptr && *ptr; ptr++)
	{
		res = lookup_constraint_var (class, *ptr, &override);
		output_resource_comment_line (fptr, res, override);
	}
	str_list_free (reslist);
}

static void
output_resource_comment_start (fptr)
FILE		*fptr;
{
	fprintf (fptr, "\
 * Name		     Class		RepType		Default Value\n\
 * ----		     -----		-------		-------------\n");
}


static void
output_resource_comment_class (fptr, class)
FILE		*fptr;
class_t		*class;
{
	int		col;

	col = output_str (fptr, " *", 0);
	col = output_goto (fptr, (80 - strlen (class->cl_name) - 9)/2, col);
	fprintf (fptr, "*** %s ***\n", class->cl_name);
}

static void
output_resource_comment_line (fptr, res, override)
FILE		*fptr;
field_t		*res;
int		override;
{
	int		col;

	if (!res || !res->vf_name || !*res->vf_name)
		return;
	col = output_str (fptr, " * ", 0);
	col = output_str (fptr, res->vf_name, col);
	col = output_goto (fptr, 21, col);
	col = output_str (fptr, res->vf_class, col);
	col = output_goto (fptr, 40, col);
	col = output_str (fptr, res->vf_type, col);
	col = output_goto (fptr, 56, col);
	col = output_str (fptr, res->vf_default, col);
	if (override)
	{
		col = output_str (fptr, "*", col);
		instance_var_free (res);
	}
	col = output_str (fptr, "\n", col);
}

void
output_type (class, type, name)
class_t		*class;			/* the class */
char		*type;			/* suffix for type */
char		*name;
{
	if (!name)
		return;
	if (!type)
	{
		*name = '\0';
		return;
	}
	if (class->cl_name_set && *class->cl_name_set)
		sprintf (name, "X%s%s%s", class->cl_name_set,
			 class->cl_name, type);
	else
		sprintf (name, "%s%s", class->cl_name, type);

}

void
output_var (class, type, name)
class_t		*class;			/* the class */
char		*type;			/* suffix for type */
char		*name;			/* where to put the name */
{
	if (!name)
		return;
	if (!type || !class)
	{
		*name = '\0';
		return;
	}
	if (class->cl_name_set && *class->cl_name_set)
	{
		sprintf (name, "x%s%s%s", class->cl_name_set,
			 class->cl_name, type);
	}
	else
	{
		if (isupper (*class->cl_name))
			*name++ = tolower (*class->cl_name);
		else
			*name++ = *class->cl_name;
		sprintf (name, "%s%s", &class->cl_name[1], type);
	}
}

static void
output_resource_c (fptr, class, resource, override)
FILE		*fptr;			/* the output file */
class_t		*class;			/* this class */
field_t		*resource;		/* resource to output */
int		override;		/* if this is an override value */
{
	char	buf[BUFSIZ];
	char	class_name[256];
	char	field_name[256];
	char	name[256];
	class_t	*def_class;

	if (!fptr || !resource)
		return;
	if (override && !class)
		return;
	/*
	 * Just an instance variable and not a resource.
	 */
	if (!resource->vf_name || !*resource->vf_name)
		return;

	fprintf (fptr, "\t{XtN%s, XtC%s, XtR%s, sizeof(%s),\n",
		 resource->vf_name, resource->vf_class, resource->vf_res_type,
		 resource->vf_type);
	if (override)
	{
		class_split (resource->vf_field, class_name, field_name);
		if ((def_class = class_lookup (class_name)) == NULL)
		{
			fprintf (stderr, "lookup_instance_override: No such class %s for %s\n",
				 class_name, resource->vf_field);
			sprintf (buf, "offset(%s)", resource->vf_field);
		}
		else
		{
			output_type (class, "Widget", name);
			sprintf (buf, "XtOffset(%s,%s.%s)", name,
				 def_class->cl_inst_field, field_name);
		}
	}
	else
	{
		sprintf (buf, "offset(%s)", resource->vf_field);
	}
	fprintf (fptr, "\t    %s, XtR%s, %s},\n",
		 buf, resource->vf_res_def, resource->vf_default);
}

void
class_split (word, class, field)
char		*word;
char		*class;
char		*field;
{
	char	buf[BUFSIZ];
	char	*field_name;

	/*
	 * Split the field name into a class and instance name components
	 */
	strcpy (buf, word);
	field_name = index (buf, '.');
	if (!field_name)
	{
		strcpy (field, word);
		class[0] = '\0';
	}
	else
	{
		*field_name++ = '\0';
		strcpy (field, field_name);
		strcpy (class, buf);
	}
}

static void
declare_class_rec (fptr, class, base)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* this class */
class_t		*base;			/* where it started */
{
	int		col;		/* current column */
	char		**ptr;		/* list of class variables */
	field_t		*field;
	int		override;
	char		buf[BUFSIZ];
	int		one = FALSE;

	if (!fptr || !class)
		return;
	/*
	 * Output these records in superclass to subclass order.
	 */
	if (var_lookup (class->cl_vars, "nosuperclass") == NULL)
		declare_class_rec (fptr, class_lookup (class->cl_superclass),
				   base);

	if (!class->cl_class_vars || !*class->cl_class_vars)
		return;
	col = output_goto (fptr, 8, 0);
	col = output_str (fptr, "{ /* ", col);
	col = output_str (fptr, class->cl_name, col);
	col = output_str (fptr, " */\n", col);
	for (ptr = class->cl_class_vars; ptr && *ptr; ptr++)
	{
		if (index (*ptr, '.') != NULL)
			continue;
		field = lookup_class_override (class, *ptr, &override, base);
		if (override || class == base)
		{
			col = output_goto  (fptr, 16, 0);
			var_expand (base, field->vf_value, buf);
			col = output_str (fptr, buf, col);
			col = output_str (fptr, ",", col);
			col = output_goto (fptr, 48, col);
			col = output_str (fptr, "/* ", col);
			col = output_str (fptr, field->vf_field, col);
			col = output_str (fptr, " */\n", col);
			one = TRUE;
		}
		else if (!override)
		{
			col = output_goto  (fptr, 16, 0);
			var_expand (base, field->vf_default, buf);
			col = output_str (fptr, buf, col);
			col = output_str (fptr, ",", col);
			col = output_goto (fptr, 48, col);
			col = output_str (fptr, "/* ", col);
			col = output_str (fptr, field->vf_field, col);
			col = output_str (fptr, " */\n", col);
			one = TRUE;
		}
	}
	if (!one)
	{
		col = output_goto  (fptr, 16, 0);
		col = output_str (fptr, "0", col);
		col = output_str (fptr, ",", col);
		col = output_goto (fptr, 48, col);
		col = output_str (fptr, "/* ", col);
		col = output_str (fptr, "dummy", col);
		col = output_str (fptr, " */\n", col);
	}
	col = output_goto (fptr, 8, 0);
	col = output_str (fptr, "},\n", col);
}

static void
name_resource_instance (field, name, value)
field_t		*field;
char		*name;
char		*value;
{
	strcat (strcpy (name, "XtN"), field->vf_name);
	strcpy (value, field->vf_name);
}

static void
name_resource_class (field, name, value)
field_t		*field;
char		*name;
char		*value;
{
	char		buf[128];

	strcpy (buf, field->vf_class);
	if (islower (buf[0]))
		buf[0] = toupper (buf[0]);
	strcpy (value, buf);
	strcat (strcpy (name, "XtC"), buf);
}

static void
name_resource_res (field, name, value)
field_t		*field;
char		*name;
char		*value;
{
	char	buf[128];

	strcpy (buf, field->vf_res_type);
	if (islower (buf[0]))
		buf[0] = toupper (buf[0]);
	strcpy (value, buf);
	strcat (strcpy (name, "XtR"), buf);
}

static void
output_instance_defines (fptr, class, name_define, reslist)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* class to describe */
void		(*name_define) ();	/* function to construct the name */
char		**reslist;		/* list of resource names */
{
	char		**ptr;		/* for going down instance variables */
	field_t		*field;		/* current instance variable */
	char		buf[BUFSIZ];
	char		value[BUFSIZ];
	int		override;

	if (!fptr || !class || !reslist)
		return;
	for (ptr = reslist; ptr && *ptr; ptr++)
	{
		field = lookup_instance_var (class, *ptr, &override);
		if (!field)
		{
			field = lookup_constraint_var (class, *ptr, &override);
		}
		if (is_override (field))
		{
			override = 1;
			field = lookup_instance_override (class, field);
		}
		if (field && field->vf_name && *field->vf_name)
		{
			(*name_define) (field, buf, value);
			if (!output_defined (class, buf))
			{
				output_define (fptr, buf, value);
				output_define_add (class, str_new (buf));
			}
		}
	}
}

static int
output_defined (class, name)
class_t		*class;			/* class to check */
char		*name;			/* value to look up */
{
	/*
	 * First check if it is globally defined
	 */
	if (output_defined_globally (name))
		return 1;
	/*
	 * Now check in class to superclass order
	 */
	if (!class || !name)
		return 0;
	return output_defined_locally (class, name);
}

static int
output_defined_globally (name)
char		*name;
{
	if (table_find (GlobalDefines, name) != NULL)
		return 1;
	else
		return 0;
}

static int
output_defined_locally (class, name)
class_t		*class;			/* class to check */
char		*name;			/* value to look up */
{
	if (!class || !name || !*name)
		return 0;
	if (table_find (class->cl_defines, name))
		return 1;
	else
		return output_defined_locally (class_lookup (class->cl_superclass),
					       name);
}

static void
output_define_add (class, name)
class_t		*class;
char		*name;
{
	if (!class || !name)
		return;
	table_add (class->cl_defines, name);
}

static void
output_actions_code (fptr, class)
FILE		*fptr;			/* where to write the code */
class_t		*class;			/* the class */
{
	int		i;
	action_list_t	*alist;		/* list of actions */
	action_t	*a;

	if (!class)
		return;
	if (!class->cl_actions || !class->cl_actions->al_list
	    || class->cl_actions->al_count <= 0)
	{
		fprintf (fptr, "#define ACTIONS NULL\n");
		fprintf (fptr, "#define ACTIONNUM 0\n");
		return;
	}
	else
	{
		fprintf (fptr, "#define ACTIONS actions\n");
		fprintf (fptr, "#define ACTIONNUM XtNumber(actions)\n");
	}
	alist = class->cl_actions;
	a = alist->al_list;
	/*
	 * 1. Print the action routines with function prototypes
	 */
	for (i = 0; i <  alist->al_count; i++)
	{
		fprintf (fptr, "XoProto (static void, %s, (Widget gw, XEvent *event, String *params, Cardinal *num_params));\n",
			 a[i].a_funcname);
	}

	/*
	 * 2. Print the action table
	 */
	fprintf (fptr, "static XtActionsRec actions[] = {\n");
	for (i = 0; i < alist->al_count; i++)
	{
		fprintf (fptr, "\t{\"%s\",\t%s},\n",
			 a[i].a_name, a[i].a_funcname);
	}
	fprintf (fptr, "};\n");
}

static void
output_translation_code (fptr, class)
FILE		*fptr;			/* where to write the code */
class_t		*class;			/* the class */
{
	int	i;
	translation_t	*t;
	translation_list_t	*tlist;

	if (!class || !class->cl_translations ||
	    !class->cl_translations->tl_list || 
	    class->cl_translations->tl_count <= 0)
		return;
	tlist = class->cl_translations;
	t = tlist->tl_list;
	fprintf (fptr, "static char translations[] = \"\\\n");
	for (i = 0; i < tlist->tl_count; i++)
	{
		fprintf (fptr, "\t%s:\t%s\\n\\\n", t[i].t_events,
			 t[i].t_actions);
	}
	fprintf (fptr, "\";\n");
}

static void
output_start_include (fptr, prefix, name)
FILE		*fptr;			/* the output file */
char		*prefix;		/* toolkit prefix */
char		*name;			/* name of the file */
{
	char		define[BUFSIZ];	/* the constant used */
	char		fullname[BUFSIZ]; /* with prefix */

	if (!fptr || !name)
		return;
	if (prefix && *prefix)
	{
		sprintf (fullname, "x%s_%s", prefix, name);
	}
	else
	{
		strcpy (fullname, name);
	}
	output_macroize (fullname, define);
	fprintf (fptr, "#ifndef %s\n#define %s\n", define, define);
	/*
	 * Make sure RCS does not fill in these values in this source file!
	 */
	fprintf (fptr, "/*\n * $%s:$\n *\n * $%s:$\n */\n",
		 "Id", "Log");
}

static void
output_end_include (fptr, prefix, name)
FILE		*fptr;			/* the output file */
char		*prefix;		/* toolkit prefix */
char		*name;			/* name of the file */
{
	char		define[BUFSIZ];	/* the constant used */

	char		fullname[BUFSIZ]; /* with prefix */

	if (!fptr || !name)
		return;
	if (prefix && *prefix)
	{
		sprintf (fullname, "x%s_%s", prefix, name);
	}
	else
	{
		strcpy (fullname, name);
	}
	output_macroize (fullname, define);
	fprintf (fptr, "\n#endif /* %s */\n", define);
}

static void
output_macroize (word, define)
char		*word;			/* word to be converted */
char		*define;		/* where it is written to */
{
	int	ch;			/* the current character */
	int	first = 1;		/* if this is first character */

	if (!define)
		return;
	if (!word) 
	{
		*define = '\0';
		return;
	}
	while (*word)
	{
		if (islower (*word))
			ch = toupper (*word);
		else
			ch = *word;
		if (isspace (ch) || ch == '.')
			ch = '_';
		if (first)
		{
			*define++ = '_';
			first = 0;
		}
		*define++ = ch;
		++word;
	}
	*define++ = '_';
	*define = '\0';
}

void
output_cpp_include (fptr, class, file, suffix, wrap)
FILE		*fptr;			/* where to write to */
class_t		*class;			/* this class */
char		*file;			/* base name of file to include */
char		*suffix;		/* possible suffix */
int		wrap;			/* if we should wrap in ifdefs */
{
	char	tmp[2048];
	char	suf[2048];
	char	var[64];
	char		define[BUFSIZ];	/* the constant used */
	char		fullname[BUFSIZ]; /* with prefix */
	char		*defname;	/* uses some nonstandard ifdef */

	if (!file || !*file)
		return;

	sprintf (suf, "%s.h", suffix);
	sprintf (var, "guard%s", suffix);
	if ((defname = var_lookup (class->cl_vars, var)))
	{
		strcpy (define, defname);
	}
	else
	{
		if (class->cl_name_set && *class->cl_name_set)
		{
			sprintf (fullname, "x%s_%s%s",
				 class->cl_name_set, file, suf);
		}
		else
		{
			sprintf (fullname, "%s%s", file, suf);
		}
		output_macroize (fullname, define);
	}
	output_filename (file, suf, tmp);
	if (wrap)
		fprintf (fptr, "#ifndef %s\n", define);
	if (class->cl_name_set && *class->cl_name_set)
		fprintf (fptr, "#include <X11/X%s/%s>\n", class->cl_name_set, tmp);
	else
		fprintf (fptr, "#include <X11/%s>\n", tmp);
	if (wrap)
		fprintf (fptr, "#endif\n");
}

static void
output_define (fptr, name, value)
FILE		*fptr;			/* where to write the define */
char		*name;			/* name to define */
char		*value;			/* value to define as */
{
	fprintf (fptr, "#ifndef %s\n", name);
	fprintf (fptr, "#	define %s \"%s\"\n", name, value);
	fprintf (fptr, "#endif\n");
}

void
instance_var_free (field)
field_t		*field;
{
	free ((char *) field);
}

void
class_var_free (field)
field_t		*field;
{
	free ((char *) field);
}

static int
output_has_constraints (class)
class_t		*class;
{
	if (!class)
		return 0;
	if (class->cl_constraint_vars && *class->cl_constraint_vars)
		return 1;
	else
		return (output_has_constraints
			(class_lookup (class->cl_superclass)));
}	
