/*
 * input.c,v 2.1 1992/07/23 19:02:47 pete Exp
 *
 * input.c,v
 * Revision 2.1  1992/07/23  19:02:47  pete
 * Removing several error messages.
 *
 * Revision 2.0  1992/04/23  02:47:34  ware
 * First public release.
 *
 * Revision 1.13  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.12  1991/08/26  11:20:22  pete
 * Added handling for input of constraint records.  Cast values for
 * free() and realloc().
 *
 * Revision 1.11  1991/06/14  04:53:10  pete
 * Fixed bug with uninitialized field
 *
 * Revision 1.10  1991/05/09  17:08:25  pete
 * Added instance_rec_type variable.
 *
 * Revision 1.9  91/05/06  16:07:05  pete
 * A working version
 * 
 * Revision 1.8  1991/05/03  18:52:58  pete
 * Output is working again.
 *
 * Revision 1.7  91/05/03  06:35:42  pete
 * Reached stage of it compiling
 * 
 * Revision 1.6  1991/05/02  17:15:37  pete
 * Compete rewrite
 *
 * Revision 1.5  91/05/02  15:22:10  pete
 * Working on output.
 * 
 * Revision 1.4  1991/04/11  05:00:24  pete
 * Make sure there can be NULL class and instance fields.
 *
 * Revision 1.3  1991/03/11  15:58:45  pete
 * Added actions and translations to grammar.
 *
 * Revision 1.2  1991/03/10  20:14:52  pete
 * Initialize cl_def_count and cl_defines.
 *
 * Revision 1.1  1991/02/21  05:39:19  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <string.h>
#include "build.h"
#include "input.h"
#include "output.h"
#include "hash_fixed.h"
#include "str_util.h"

Table		*clist;		/* list of classes */
class_t		*CurrentClass;

void
input_class_done ()
{
	char		buf[BUFSIZ];
	class_t		*super;

	if (!CurrentClass)
		return;
	CurrentClass->cl_superclass = str_new (var_lookup (CurrentClass->cl_vars,
							   "superclass"));
	CurrentClass->cl_name_set = str_new (var_lookup (CurrentClass->cl_vars,
							   "class_prefix"));
	super = class_lookup (CurrentClass->cl_superclass);
	if (super)
	{
		output_var (super, "ClassRec", buf);
		CurrentClass->cl_vars = var_add (CurrentClass->cl_vars,
						 var_make ("superclass_rec",
							   str_new (buf)));
	}
	output_type (CurrentClass, "ClassRec", buf);
	CurrentClass->cl_vars = var_add (CurrentClass->cl_vars,
					 var_make ("class_rec_type",
						   str_new (buf)));
	output_type (CurrentClass, "Rec", buf);
	CurrentClass->cl_vars = var_add (CurrentClass->cl_vars,
					 var_make ("instance_rec_type",
						   str_new (buf)));
	/*
	 * Define a constraint rec type only if there are some constraint
	 * variables for this class.
	 */
	if (CurrentClass->cl_constraint_vars && *CurrentClass->cl_constraint_vars)
	{
		output_type (CurrentClass, "ConstraintRec", buf);
		CurrentClass->cl_vars =
			var_add (CurrentClass->cl_vars,
				 var_make ("constraint_rec_type",
					   str_new (buf)));
	}
}

void
input_class_start (name)
char		*name;
{
	lookup_initialize ();		/* safe to call multiple times */
	CurrentClass = class_make (name);
	if (!clist)
	{
#define NUMCHAINS 10
		clist = table_hash_fixed_create (NUMCHAINS, class_free,
						 class_compare, class_hash);
	}
	table_add (clist, (char *) CurrentClass);
}

/*----------------------------------------------------------------------*\
 * Functions used in class_info rhs productions.
\*----------------------------------------------------------------------*/

void
input_var_add (name, value)
char		*name;
char		*value;
{
	if (!CurrentClass)
		return;
	CurrentClass->cl_vars = var_add (CurrentClass->cl_vars,
					 var_make (name, value));
}

void
input_class_record_add (name, fields)
char		*name;			/* name of this record */
char		**fields;		/* list of fields */
{
	if (!CurrentClass)
		return;
	CurrentClass->cl_class_field = name;
	CurrentClass->cl_class_vars = fields;
}

void
input_class_function_add (type, name, function)
char		*type;			/* type of this function */
char		*name;			/* name of this method */
function_t	*function;		/* function template */
{

	function->f_type = type;
	function->f_name = name;
	lookup_method_add (CurrentClass, function);
}

void
input_class_instance_name (name)
char	*name;
{
	if (!CurrentClass)
		return;
	CurrentClass->cl_inst_field = name;
}

/*----------------------------------------------------------------------*\
 * Functions used in class_record rhs productions
\*----------------------------------------------------------------------*/

char **
input_class_add_field (list, field)
char	**list;			/* list of fields */
field_t	*field;			/* new field to add */
{
	/*
	 * FIX: What about class name?  What about adding it to
	 *	global list?
	 */
	list = str_list_append (list, field->vf_field);
	lookup_class_add (CurrentClass, field);
	return (list);
}


/*----------------------------------------------------------------------*\
 * Functions used in function rhs productions
\*----------------------------------------------------------------------*/

function_t *
input_class_make_function (args, code)
arg_list_t	*args;			/* list of arguments */
char		*code;			/* the code template */
{
	function_t	*f;		/* returned function */

	f = (function_t *) malloc (sizeof (function_t));
	f->f_name = NULL;
	f->f_type = NULL;
	f->f_args = args;
	f->f_code = code;
	return f;
}

arg_list_t *
input_add_arg (args, arg)
arg_list_t	*args;			/* current list of arguments */
arg_t		*arg;			/* current argument */
{
	if (!args)
	{
		args = (arg_list_t *) malloc (sizeof (arg_list_t));
		args->al_count = 0;
		args->al_list = (arg_t *) malloc (sizeof (arg_t));
	}
	++args->al_count;
	args->al_list = (arg_t *) realloc ((char *) args->al_list,
					       sizeof (arg_t) *
					       args->al_count);
	bcopy ((char *) arg, &args->al_list[args->al_count - 1],
	       sizeof (arg_t));
	free ((char *) arg);
	return args;
}


arg_t *
input_make_arg (type, field, comment)
char		*type;			/* C type of this argument */
char		*field;			/* the argument name */
char		*comment;		/* description of field */
{
	arg_t	*arg;

	arg = (arg_t *) malloc (sizeof (arg_t));
	arg->a_type = type;
	arg->a_field = field;
	arg->a_comment = comment;
	return arg;
}

/*----------------------------------------------------------------------*\
 * Functions used in instance_record rhs productions
\*----------------------------------------------------------------------*/

void
input_instance_record_add (field)
field_t		*field;			/* resource to add */
{
	if (!field)
		return;
	CurrentClass->cl_instance_vars =
		str_list_append (CurrentClass->cl_instance_vars,
			      field->vf_field);
	lookup_instance_add (CurrentClass, field);
}

field_t *
input_instance_record_make (type,res_field,comment,name,res_class,res_type,res_def,res_default,description)
char		*type;			/* type of the resource */
char		*res_field;		/* name of field in instance part */
char		*comment;		/* short, C, comment */
char		*name;			/* name of the resource */
char		*res_class;		/* class of the resource */
char		*res_type;		/* type of the resource */
char		*res_def;		/* type of the default */
char		*res_default;		/* the default */
char		*description;		/* longer documentation */
{
	field_t	*field;		/* the resource */

	field = (field_t *) malloc (sizeof (field_t));
	field->vf_type = type;
	field->vf_field = res_field;
	field->vf_comment = comment;
	field->vf_name = name;
	field->vf_class = res_class;
	field->vf_res_type = res_type;
	field->vf_res_def = res_def;
	field->vf_default = res_default;
	field->vf_description = description;
	field->vf_thetype = Resource;
	return field;
}

/*----------------------------------------------------------------------*\
 * Functions used in constraints_record rhs productions
\*----------------------------------------------------------------------*/

void
input_constraints_record_add (field)
field_t		*field;
{
	if (!field)
		return;
	CurrentClass->cl_constraint_vars =
		str_list_append (CurrentClass->cl_constraint_vars,
			      field->vf_field);
	lookup_constraints_add (CurrentClass, field);
}


void
input_class_constraints_name (name)
char	*name;
{
	if (!CurrentClass)
		return;
	CurrentClass->cl_cons_field = name;
}

/*----------------------------------------------------------------------*\
 * Functions used in actions_record rhs productions
\*----------------------------------------------------------------------*/

void
input_action_field_add (action)
action_t	*action;		/* action  to be added */
{
	action_list_t	*list;

	if (!action)
		return;
	if (!CurrentClass->cl_actions)
	{
		CurrentClass->cl_actions = list =
			(action_list_t *) malloc (sizeof (action_list_t));
		list->al_count = 0;
		list->al_list = (action_t *) malloc (sizeof (action_t));
	}
	else
	{
		list = CurrentClass->cl_actions;
	}
	
	++list->al_count;
	list->al_list = (action_t *) realloc ((char *) list->al_list,
					      sizeof (action_t) * list->al_count);
	bcopy ((char *) action,
	       (char *) &list->al_list[list->al_count - 1],
	       sizeof (action_t));
	free ((char *) action);
}

action_t *
input_action_field_make (name, funcname, desc)
char		*name;			/* name of the action */
char		*funcname;		/* name of function that implements */
char		*desc;			/* description of action */
{
	action_t	*a;

	a = (action_t *) malloc (sizeof (action_t));
	a->a_name = name;
	a->a_funcname = funcname;
	a->a_description = desc;
	return a;
}

/*----------------------------------------------------------------------*\
 * Functions used in translation rhs productions
\*----------------------------------------------------------------------*/

void
input_translation_field_add (translation)
translation_t	*translation;		/* translation  to be added */
{
	translation_list_t	*list;		/* list to add translations to */

	if (!translation)
		return;
	if (!CurrentClass->cl_translations)
	{
		CurrentClass->cl_translations = list = (translation_list_t *)
			malloc (sizeof (translation_list_t));
		list->tl_count = 0;
		list->tl_list = (translation_t *)
			malloc (sizeof (translation_t));
	}
	else
	{
		list = CurrentClass->cl_translations;
	}
	++list->tl_count;
	list->tl_list = (translation_t *) realloc ((char *) list->tl_list,
					      sizeof (translation_t) * list->tl_count);
	bcopy ((char *) translation,
	       (char *) &list->tl_list[list->tl_count - 1],
	       sizeof (translation_t));
	free ((char *) translation);
}

translation_t *
input_translation_field_make (events, actions, desc)
char		*events;			/* events to trigger translation */
char		*actions;		/* actions to execute */
char		*desc;			/* description of translation */
{
	translation_t	*t;

	t = (translation_t *) malloc (sizeof (translation_t));
	t->t_events = events;
	t->t_actions = actions;
	t->t_description = desc;
	return t;
}

/************************************************************************/

field_t *
make_field (storage, type, field_name, value, comment, def)
char		*storage;		/* the storage type */
char		*type;			/* the C type for this */
char		*field_name;		/* the name of the field */
char		*value;			/* the value */
char		*comment;		/* brief description */
char		*def;			/* default value */
{
	field_t		*field;

	field = (field_t *) malloc (sizeof (field_t));
	if (!field)
	{
		perror ("make_field: malloc:");
		return field;
	}
	field->vf_storage = storage;
	field->vf_type = type;
	field->vf_field = field_name;
	field->vf_value = value;
	field->vf_comment = comment;
	field->vf_name = NULL;
	field->vf_class = NULL;
	field->vf_res_type = NULL;
	field->vf_res_def = NULL;
	field->vf_default = def;
	field->vf_description = NULL;
	field->vf_thetype = Field;
	return field;
}

field_t *
make_method (type, field_name, comment, def, name)
char		*type;			/* the C type for this */
char		*field_name;		/* the name of the field */
char		*comment;		/* brief description */
char		*def;			/* default value */
char		*name;			/* name of the method */
{

	field_t		*field;

	field = (field_t *) malloc (sizeof (field_t));
	if (!field)
	{
		perror ("make_field: malloc:");
		return field;
	}
	field->vf_type = type;
	field->vf_field = field_name;
	field->vf_value = NULL;
	field->vf_comment = comment;
	field->vf_name = name;
	field->vf_class = NULL;
	field->vf_res_type = NULL;
	field->vf_default = def;
	field->vf_description = NULL;
	field->vf_thetype = Method;
	return field;
}
