
#include <stdio.h>
#include "build.h"
#include "hash_fixed.h"

XoProto (static int, field_free, (char *f));
XoProto (static int, field_compare, (char *d1, char *d2));
XoProto (static int, field_hash, (char *f));
XoProto (static int, func_free, (char *f));
XoProto (static int, func_compare, (char *d1, char *d2));
XoProto (static int, func_hash, (char *f));
XoProto (extern char *, index, (CONST char *word, int ch));
XoProto (extern int, hash_str, (CONST char *str));

Table		*clist;

void
class_first ()
{
	table_first (clist);
}

class_t *
class_next ()
{
	return ((class_t *) table_next (clist));
}


class_t *
class_lookup (name)
char		*name;			/* name to search for */
{
	class_t	class;

	if (!name || !*name)
		return ((class_t *) NULL);
	class.cl_name = name;
	return ((class_t *) table_find (clist, (char *) &class));
}

class_t *
class_make (name)
char	*name;
{
	class_t		*class;

	class = (class_t *) malloc (sizeof (class_t));
	if (!class)
	{
		perror ("class_start: malloc");
		return class;
	}
	class->cl_name = name;
	class->cl_name_set = NULL;
	class->cl_superclass = NULL;
	class->cl_class_field = NULL;
	class->cl_class_vars = NULL;
	class->cl_class_fields =
		table_hash_fixed_create (15, field_free,
					 field_compare,
					 field_hash);
	class->cl_methods =
		table_hash_fixed_create (15, func_free,
					 func_compare,
					 func_hash);
	class->cl_inst_field = NULL;
	class->cl_instance_vars = NULL;
	class->cl_instance_fields =
		table_hash_fixed_create (15, field_free,
					 field_compare,
					 field_hash);
	class->cl_cons_field = NULL;
	class->cl_constraint_vars = NULL;
	class->cl_constraint_fields =
		table_hash_fixed_create (15, field_free,
					 field_compare,
					 field_hash);
	class->cl_vars = NULL;
	class->cl_functions = NULL;
	class->cl_actions = NULL;
	class->cl_defines =
		table_hash_fixed_create (30, (int (*)())NULL,
					 (int (*)())NULL,
					 hash_str);
	class->cl_translations = NULL;
	return class;
}

/*
 * The following functions are used by the table() library.
 */

int
class_free (data)
char		*data;
{
	if (data)
		free (data);
	return 1;
}

int
class_compare (d1, d2)
char		*d1, *d2;
{
	class_t		*c1, *c2;

	if ((c1 = (class_t *) d1) == NULL)
	{
		if (d2)
			return -1;
		else
			return 0;
	}
	if ((c2 = (class_t *) d2) == NULL)
		return 1;

	return (strcmp (c1->cl_name, c2->cl_name));
}

int
class_hash (d)
char		*d;
{
	class_t		*c;

	if ((c = (class_t *) d) == NULL)
		return 0;
	else return (hash_str (c->cl_name));
}


static int
field_free (f)
char		*f;
{
	free (f);
	return 0;
}

static int
field_compare (d1, d2)
char		*d1, *d2;
{
	field_t		*f1, *f2;

	if ((f1 = (field_t *) d1) == NULL)
	{
		if (d2)
			return -1;
		else
			return 0;
	}
	if ((f2 = (field_t *) d2) == NULL)
	{
		return 1;
	}
	if (!f1->vf_field)
		return -1;
	if (!f2->vf_field)
		return 1;
	return strcmp (f1->vf_field, f2->vf_field);
}

static int
field_hash (f)
char		*f;
{
	field_t		*field;

	if ((field = (field_t *) f) == NULL)
		return 0;
	else
		return hash_str (field->vf_field);
}

static int
func_free (f)
char		*f;
{
	free (f);
	return 0;
}

static int
func_compare (d1, d2)
char		*d1, *d2;
{
	function_t		*f1, *f2;

	if ((f1 = (function_t *) d1) == NULL)
	{
		if (d2)
			return -1;
		else
			return 0;
	}
	if ((f2 = (function_t *) d2) == NULL)
	{
		return 1;
	}
	if (!f1->f_name)
		return -1;
	if (!f2->f_name)
		return 1;
	return strcmp (f1->f_name, f2->f_name);
}

static int
func_hash (f)
char		*f;
{
	function_t		*func;

	if ((func = (function_t *) f) == NULL)
		return 0;
	else
		return hash_str (func->f_name);
}

