
/*
 * build.h,v 2.1 1992/07/23 19:02:42 pete Exp
 *
 * build.h,v
 * Revision 2.1  1992/07/23  19:02:42  pete
 * Removing several error messages.
 *
 * Revision 2.0  1992/04/23  02:47:23  ware
 * First public release.
 *
 * Revision 1.14  1992/04/18  01:55:41  ware
 * Fixed so the constraint resources are written
 *
 * Revision 1.13  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.12  1991/11/30  16:56:58  pete
 * Added define's for FALSE and TRUE.  Fixed problem with size_t getting
 * multiply typedef'd on Suns.  Fixed problem with "const" getting
 * conflicting definitions with flex.
 *
 * Revision 1.11  1991/09/03  15:55:19  pete
 * Fixed up definition of CONST on the E&S so it isn't redefined.
 *
 * Revision 1.10  91/08/26  11:11:56  pete
 * Add XoProto() to allow function prototypes to be conditional.  Define
 * CONST properly for various machines.  Deal with strlen() returning
 * different types on different OS's.
 * 
 * Add constraint info for each widget class.
 * 
 * Revision 1.9  1991/05/22  17:51:50  pete
 * Fixed some include problems on the e&s.
 *
 * Revision 1.8  91/05/10  15:23:53  pete
 * Added some system prototypes.
 * 
 * Revision 1.7  1991/05/06  16:07:05  pete
 * A working version
 *
 * Revision 1.6  1991/05/03  18:52:52  pete
 * Output is working again.
 *
 * Revision 1.5  91/05/03  06:36:20  pete
 * Reached stage of it compiling
 * 
 * Revision 1.4  1991/05/02  17:15:31  pete
 * Compete rewrite
 *
 * Revision 1.3  91/04/11  04:59:42  pete
 * Added options structure.
 * 
 * Revision 1.2  1991/03/11  15:58:45  pete
 * Added actions and translations to grammar.
 *
 * Revision 1.1  1991/02/21  05:39:19  pete
 * Initial revision
 *
 */

#include <X11/Xo/XoUnistd.h>
#include "table.h"

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

/*
 * Used to describe the arguments to a function
 */
typedef struct
{
	char		*a_type;	/* the C type of field */
	char		*a_field;	/* the name of the arg */
	char		*a_comment;	/* brief description */
} arg_t;

/*
 * Used to hold a list of arg_t's.
 */
typedef struct
{
	int		al_count;	/* number of args */
	arg_t		*al_list;	/* list of args */
} arg_list_t;

typedef enum {Field, Method, Resource} member_type_t;

typedef struct
{
	char		*vf_storage;	/* storage type for methods */
	char		*vf_type;	/* the C type of this field */
	char		*vf_field;	/* the C name of this field */
	char		*vf_value;	/* the value of this field */
	char		*vf_comment;	/* description, may be NULL */
	char		*vf_name;	/* name of the resource (sans XtN) */
	char		*vf_class;	/* class of the resource (sans XtC) */
	char		*vf_res_type;	/* resource type (sans XtR)  */
	char		*vf_res_def;	/* default resource type (sans XtR) */
	char		*vf_default;	/* default value */
	char		*vf_description;	/* long winded description */
	member_type_t	vf_thetype;
} field_t;

typedef struct
{
	char		*f_name;	/* name of the function */
	char		*f_type;	/* type of the function */
	arg_list_t	*f_args;	/* list of arguments */
	char		*f_code;	/* code template */
} function_t;

typedef struct
{
	int		fl_count;	/* number of functions */
	function_t	*fl_list;	/* list of functions */
} func_list_t;

typedef struct
{
	char		*a_name;	/* name of the action */
	char		*a_funcname;	/* name of the action func */
	char		*a_description;	/* longish descriptions */
} action_t;

typedef struct
{
	int		al_count;	/* number of actions */
	action_t	*al_list;	/* list of actions */
} action_list_t;

typedef struct
{
	char		*t_events;	/* actions to trigger trans */
	char		*t_actions;	/* actions to execute */
	char		*t_description;	/* longish descriptions */
} translation_t;

typedef struct
{
	int		tl_count;	/* number of translations */
	translation_t	*tl_list;	/* list of translations */
} translation_list_t;

typedef struct var
{
	char		*v_name;	/* name of this variables */
	char		*v_value;	/* corresponding value */
	struct var	*v_next;	/* next on the list */
} var_t;

/*
 * This holds all the pertinent information about a widget class
 */
typedef struct class 
{
	char		*cl_name;	/* the name of this class */
	char		*cl_name_set;	/* name of this widget set (e.g. aw) */
	char		*cl_superclass;	/* name of superclass */
	/*
	 * The following describes the class record for this widget.
	 * The first describes the actual class part structure and the
	 * other is the name used for this class part in the class record.
	 * The name of the class field should be derivable from the
	 * widget class name (cl_name) and widget set (cl_name_set) but
	 * if it isn't, one can specify it here
	 */
	char		*cl_class_field; /* actual class record field name */
	char		**cl_class_vars; /* list of the class fields */
	Table		*cl_class_fields; /* list of fields */

	Table		*cl_methods;	/* list of methods */
	/*
	 * Here is the instance record info.  Similar comments about naming
	 * from the class record apply here, also.
	 */
	char		*cl_inst_field;	/* name of instance field */
	char		**cl_instance_vars; /* list of class instance variables */
	Table		*cl_instance_fields; /* list of instance fields */

	/*
	 * Here is the constraint record info.  Similar comments about naming
	 * from the class record apply here, also.
	 */
	char		*cl_cons_field;	/* name of instance field */
	char		**cl_constraint_vars; /* list of class instance variables */
	Table		*cl_constraint_fields; /* list of instance fields */

	var_t		*cl_vars;	/* list of variables */
	func_list_t	*cl_functions;	/* methods for this class */

	/*
	 * List of actions defined by this class
	 */
	action_list_t	*cl_actions;	/* list of actions */

	/*
	 * List of symbols #define'd for this class
	 */
	Table		*cl_defines;	/* list of defines */

	/*
	 * List of translations defined by this class
	 */
	translation_list_t	*cl_translations;
} class_t;

typedef struct
{
	char		*opt_defdir;	/* default directory */
	char		*opt_incdir;	/* for include files */
	char		*opt_docdir;	/* for documentation */
	char		opt_dodoc;	/* if generate documentation */
	char		opt_doinc;	/* if generate include files */
} options_t;

XoProto (extern void, class_first, (void));
XoProto (extern class_t *, class_next, (void));
XoProto (extern class_t*, class_lookup, (char *class_name));

XoProto (extern void, err, (char *message));
XoProto (extern void, yyerror, (char *message));
XoProto (extern int,  yyparse, (void));
XoProto (extern int,  yylex, (void));
XoProto (extern void, main, (int argc, char **argv));
XoProto (extern void, lookup_initialize, (void));
XoProto (extern void, lookup_instance_add, (class_t *, field_t *));
XoProto (extern void, lookup_constraints_add, (class_t *, field_t *));
XoProto (extern void, lookup_class_add, (class_t *, field_t *));
XoProto (extern void, lookup_method_add, (class_t *, function_t *));
XoProto (extern void, class_split, (char *word, char *class, char *field));

XoProto (extern field_t*, lookup_instance_var, (class_t *class, char *name, int *flag));
XoProto (extern field_t*, lookup_constraint_var, (class_t *, char *name, int *flag));
XoProto (extern field_t*, lookup_class_var, (class_t *class, char *name, int *flag));
XoProto (extern field_t*, lookup_instance_override, (class_t *, field_t *));
XoProto (extern field_t*, lookup_constraint_override, (class_t *, field_t *));
XoProto (extern function_t*, lookup_class_method, (class_t *, char *));
XoProto (extern field_t*, lookup_class_override, (class_t *, char *, int *, class_t *));
XoProto (extern int, is_override, (field_t *));

XoProto (extern var_t*, var_make, (char *name, char *value));
XoProto (extern var_t*, var_add, (var_t *list, var_t *var));
XoProto (extern char*, var_lookup, (var_t *list, char *name));
XoProto (extern char*, var_expand, (class_t *class, char *name, char *buf));

XoProto (extern class_t*, class_make, (char *name));
XoProto (extern int, class_free, (char *d));
XoProto (extern int, class_compare, (char *d1, char *d2));
XoProto (extern int, class_hash, (char *d));


