#ifndef _XO_XOP_H_
#define _XO_XOP_H_
/*
 * XoP.h,v 2.2 1992/07/11 19:47:11 pete Exp
 * XoP.h,v
 * Revision 2.2  1992/07/11  19:47:11  pete
 * Added include of IntrinsicP.h
 *
 * Revision 2.1  1992/06/23  00:46:53  pete
 * Usual of adding some prototypes.
 *
 * Revision 2.0  1992/04/23  02:47:02  ware
 * First public release.
 *
 * Revision 1.19  1992/04/23  02:23:22  ware
 * Fixed XoEdge() maros.  Added XoObjDraw() macros.
 *
 * Revision 1.18  1992/02/27  14:33:05  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.17  1992/02/21  10:12:42  ware
 * Added macros to calculate the edges of a widget.
 *
 * Revision 1.16  92/02/12  00:49:55  ware
 * Made _XoTraverseAfter,Before, and _XoChildFind globally available.
 * 
 * Revision 1.15  1991/12/01  01:57:52  pete
 * Wrap #include Xo.h in ifdefs.
 *
 * Revision 1.14  1991/11/30  15:35:46  pete
 * Added _XoChildRoom() prototype.
 *
 * Revision 1.13  1991/09/12  09:37:22  pete
 * Added defines for number of times to request a geometry change.  Macro
 * for retrieving the dimension flags from a geometry request.
 *
 * Revision 1.12  91/08/30  17:56:03  pete
 * Added definition of XtInheritCallbackMenu so each class that wanted
 * to add a menu didn't have to define it.
 * 
 * Revision 1.11  91/08/30  16:40:47  pete
 * Renamed XoPopup{New,Done} to XoMenu{New,Done}.
 * 
 * Revision 1.10  91/08/26  11:06:22  pete
 * Renamed functions to following nameing conventions.  Use XoProto() to
 * allow function prototypes to be conditional.  Added prototypes for
 * XoAcceptFocus().
 * 
 * Revision 1.9  1991/07/09  10:34:03  pete
 * Added method for accept_focus.
 *
 * Revision 1.8  91/07/02  04:43:42  pete
 * Added structures and enums for keyboard traversals.
 * 
 * Revision 1.7  1991/06/29  18:26:17  pete
 * Added structures and prototypes for doing hardcopy.
 *
 * Revision 1.6  91/06/14  11:15:36  pete
 * Added _XoClassInit() for default class initialization.
 * 
 * Revision 1.5  91/06/14  10:29:07  pete
 * Added _XoWarn().
 * 
 */

#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif

#ifndef _XtintrinsicP_h
#include <X11/IntrinsicP.h>
#endif

/*
 * When negotiating for geometry requests with a parent, this is
 * the number of times to try before giving up.
 */
#define XO_GEO_NUMREQUEST	5
/*
 * A macro that extracts the CWWidth and CWHeight flags from
 * a geometry request
 */
#define XoGeoDimFlags(r)	((r)->request_mode & (CWWidth|CWHeight))
/*
 * Macros to return the edges of a widget, including any border
 */
#define _XoEdgeLeft(gw)		(gw->core.x)
#define _XoEdgeRight(gw)	(gw->core.x + gw->core.width + 2*gw->core.border_width)
#define _XoEdgeTop(gw)		(gw->core.y)
#define _XoEdgeBottom(gw)	(gw->core.y + gw->core.height + 2*gw->core.border_width)

/*
 * Return the interior sides of an object.
 */
#define _XoObjDrawLeft(w)	(w->rectangle.x + w->rectangle.border_width)
#define _XoObjDrawRight(w)	(_XoObjDrawLeft(w) + w->rectangle.width)
#define _XoObjDrawTop(w)	(w->rectangle.y + w->rectangle.border_width)
#define _XoObjDrawBottom(w)	(_XoObjDrawTop(w) + w->rectangle.height)

typedef struct _xo_hardcopy_ext
{
	XtPointer	next_extension;	/* next extension record */
	XrmQuark	record_type;	/* type of extenstion structure */
	long		version;	/* what version of this extension */
	Cardinal	record_size;	/* size of this extension */
	XoHardCopyProc	func;		/* function to actualy print */
} XoHardCopyExt;

typedef struct _xo_menu_new_cb_rec 
{
	Widget		widget;
	Position	x;
	Position	y;
} XoMenuNewCBRec;

XoProto (extern Boolean, _XoInheritedSet, (Widget parent, Widget child, ArgList set_args, Cardinal *num_set_args));
XoProto (extern void, _XoInheritedGet, (Widget parent, Widget child));
XoProto (extern void, _XoRegisterConverters, (void));
XoProto (extern void, _XoObjRedraw, (Widget gw, XEvent *event, Region region));
XoProto (extern Boolean, _XoObjPointIn, (Widget gw, int x, int y));
XoProto (extern void, _XoRedisplaySelf, (Widget gw));
XoProto (extern Boolean, _XoIsPoppedUp, (Widget gw));
XoProto (extern void, _XoWarn, (Widget gw, char *class, char *detail, char *message));
XoProto (extern void, _XoClassInit, (void));
XoProto (extern void, _XoCallClassHooks, (void));
XoProto (extern void, _XoHardcopyComposite, (Widget tree, XoHardCopy *hardcopy, int depth));
/*
 * Traversal related functions
 */
XoProto (extern XoDirection, _XoDirectionFromString, (String where));
XoProto (extern String, _XoStringFromDirection, (XoDirection direction));
XoProto (extern void, _XoTraverseCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (extern Widget, _XoTraverseBefore, (Widget gw, int indx, Time when));
XoProto (extern Widget, _XoTraverseAfter, (Widget gw, int indx, Time when));

/*
 * A conveniant method that handles setting the focus to a widget.  Useful
 * as core_class.accept_focus.  The second one does the same for composite
 * children and merely returns the first child that accepts the focus.
 */
XoProto (extern Boolean, XoFocusAccept, (Widget gw, Time *t));
XoProto (extern Boolean, XoFocusAcceptComp, (Widget gw, Time *t));

/*
 * Call the popdown and new_popup callback lists to help speed up
 * menu popping up and down
 */
XoProto (extern void, _XoMenuNew, (Widget gw, Widget submenu, Widget start,
				   XoGravity where, XEvent *event,
				   XoPopupAction action));
XoProto (extern void, _XoMenuDone, (Widget gw, Widget submenu, Widget start,
				   XoGravity where, XEvent *event,
				    XoPopupAction action));

#define XtInheritCallbackMenu ((XtCallbackProc) _XtInherit)

/*
 * Specify the new menu to display and where it should go
 */
XoProto (extern void, _XoMenuSet, (Widget menu, Widget submenu, int x, int y));

/*
 * Some miscelaneous functions
 */
XoProto (extern void, _XoChildRoom, (Widget gw));
XoProto (extern int, _XoChildFind, (Widget parent, Widget child));
XoProto (extern XoGravity, _XoGravityAction, (String *params, Cardinal *num, XoGravity default_value));
	
#endif /* _XO_XOP_H_ */
