#ifndef _XO_XO_H_
#define _XO_XO_H_
/*
 * Xo.h,v 2.4 1992/08/11 00:19:29 pete Exp
 * Xo.h,v
 * Revision 2.4  1992/08/11  00:19:29  pete
 * Added GrayScale shading.
 *
 * Revision 2.3  1992/07/22  16:17:28  pete
 * Added XoWMAddDeleteHandler() prototype.
 *
 * Revision 2.2  1992/07/11  19:46:47  pete
 * Added include of Intrinsic.h.  Added misc. drawing functions.
 *
 * Revision 2.1  1992/06/23  00:46:51  pete
 * Usual of adding some prototypes.
 *
 * Revision 2.0  1992/04/23  02:46:59  ware
 * First public release.
 *
 * Revision 1.23  1992/04/23  02:22:30  ware
 * Rearranged some enums.  Added prototype for pointing resource
 *
 * Revision 1.22  1992/03/03  15:50:44  ware
 * Added new function XoNameString().
 *
 * Revision 1.21  1992/02/29  21:04:05  ware
 * Added XoOrientation and prototypes for converters.
 *
 * Revision 1.20  1992/02/27  14:33:05  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.19  1992/02/22  20:37:27  ware
 * Added prototype for XoWMAddFocusHandler().
 *
 * Revision 1.18  1992/02/14  12:41:28  ware
 * Added left and right traversals.
 *
 * Revision 1.17  92/02/12  16:41:43  ware
 * Added pi_start to XoPopupInfo structure.  This is used to determine
 * the "next" or "previous" menu for keyboard traversals.
 * 
 * Revision 1.16  92/02/07  16:22:37  ware
 * Added down and up traversals.
 * 
 * Revision 1.15  92/02/07  16:08:23  ware
 * Moved XoGravity enums from Label.h to here.  Added prototypes for placing
 * popup's relative to some widget.
 * 
 * Revision 1.14  92/02/04  21:27:41  pete
 * Added prototypes.  Release 44
 * 
 * Revision 1.13  91/12/31  16:32:02  pete
 * Moved XoProto() macro to XoUnistd.h.  Added prototype for XoEventLocation().
 * 
 * Revision 1.12  1991/09/12  09:37:06  pete
 * Added prototype for XoConfWidget().
 *
 * Revision 1.11  91/08/30  16:28:51  pete
 * Added XoPopupInfo for new menuing support.  Added prototypes for
 * XoMap() and XoEnablePopups().
 * 
 * Revision 1.10  91/08/26  17:43:27  pete
 * Add XoStackChild().
 * 
 * Revision 1.9  91/08/26  13:50:48  pete
 * Added XoGeometryResultString() prototype.
 * 
 * Revision 1.8  91/08/26  11:04:32  pete
 * Renamed functions to follow naming conventions.  Use XoProto() to
 * allow prototypes to be conditional.
 * 
 * Revision 1.7  91/07/23  03:17:53  pete
 * Added prototype for XoName().
 * 
 * Revision 1.6  1991/07/09  10:33:46  pete
 * Added traversals.
 *
 * Revision 1.5  91/07/02  04:43:42  pete
 * Added structures and enums for keyboard traversals.
 * 
 * Revision 1.4  1991/06/29  18:26:17  pete
 * Added structures and prototypes for doing hardcopy.
 *
 * Revision 1.3  1991/06/14  04:21:14  pete
 * Added prototype for XoPlacePopup()
 *
 * Revision 1.2  1991/05/29  09:35:24  pete
 * Added include of standard prototypes.
 *
 */

#ifndef _XtIntrinsic_h
#include <X11/Intrinsic.h>
#endif
#ifndef _XtStringDefs_h_
#include <X11/StringDefs.h>
#endif

#ifndef _XO_XO_UNISTD_H_
#include <X11/Xo/XoUnistd.h>
#endif

/*
 * Description of how things can be placed.  Used by the label widget (and
 * of course subclasses) to determine where the label should be placed
 * and to indicate how a popup should be placed relative to the
 * parent shell.
 */
typedef enum {XoNORTH, XoNORTHEAST, XoEAST, XoSOUTHEAST,
	      XoSOUTH, XoSOUTHWEST, XoWEST, XoNORTHWEST, XoCENTER} XoGravity;
/*
 * How text should be justified.
 */
typedef enum {XoJUST_LEFT, XoJUST_CENTER, XoJUST_RIGHT} XoJustify;
/*
 * Whether the major axis should be vertical or horizontal.  Used
 * by scrollbars.
 */
typedef enum {XoVERTICAL, XoHORIZONTAL} XoOrientation;
/*
 * Which way an arrow should point.
 */
typedef enum {XoLEFT, XoRIGHT, XoUP, XoDOWN} XoPointing;

/*
 * Type of shading (from Athena Plotter widgets)
 */

typedef enum
{
	XoGRAY0, XoGRAY1, XoGRAY2, XoGRAY3, XoGRAY4, XoGRAY5, XoGRAY6,
	XoGRAY7, XoGRAY8, XoGRAY9, XoGRAY10
} XoShading;

#define XtNshading "shading"
#define XtRShading "Shading"
#define XtCShading "Shading"

typedef struct _xo_hardcopy
{
	int		h_dpi_x;	/* dots per inch in x */
	int		h_dpi_y;	/* dots per inch in y */
	XrmQuark	h_type;		/* type of printer desired */
	long		h_version;	/* version of the printer driver */
	XtPointer	h_private;	/* for each printer type */
} XoHardCopy;

/*
 * The following strings are used to obtain quarks for ``record_type''.
 * One is free to implement others, this just established several expected
 * types.
 *
 * Inclusion in this list does not imply implementation
 */

#define XoPostscript "xopostscript"	/* for postscript hardcopy */
#define XoHPGL "xohpgl"			/* for HP gl */
#define XoX11 "xox11"			/* for dummy x11 */
#define XoTest "xotest"			/* for testing purposes */

typedef void (*XoHardCopyProc)(
#if NeedFunctionPrototypes
Widget		gw,
XoHardCopy	*hardcopy
#endif /* NeedFunctionPrototypes */
);

XoProto (extern void, XoPlacePopup, (Widget popup, int x, int y));
XoProto (extern void, XoPlaceRelative, (Widget gw, Widget relative_to, XoGravity where, XoGravity part, int keep_on_screen));
XoProto (extern void, XoWidgetLoc, (Widget gw, Position *x, Position *y,
				    Dimension *width, Dimension *height));
XoProto (extern void, XoWidgetGravityPoint, (Widget gw, XoGravity where, Position *x_ret, Position *y_ret));
	
XoProto (extern void, XoHardcopy, (Widget tree, XoHardCopy *hardcopy, int depth));
XoProto (extern void, XoHardcopyAddExtension, (WidgetClass class, String name,
		    long version, XoHardCopyProc func, XtPointer private));
/*
 * Traversal related structures
 */
typedef enum 
{
	XoTRAVERSE_PREVIOUS, XoTRAVERSE_NEXT,
	XoTRAVERSE_HOME, XoTRAVERSE_END,
	XoTRAVERSE_DOWN, XoTRAVERSE_UP,
	XoTRAVERSE_LEFT, XoTRAVERSE_RIGHT,
} XoDirection;

/*
 * This information is passed to the traverse callback.
 */
typedef struct _xo_traverse_info 
{
	Widget		t_start;	/* widget moving relative too */
	XoDirection	t_direction;	/* which way to move */
	Time		t_time;		/* when it started */
	Boolean		t_found;	/* if someone was found to accept */
} XoTraverseInfo;

XoProto (extern Boolean, XoTraversalString, (Widget gw, String where, Time when));
XoProto (extern Boolean, XoTraverse, (Widget gw, XoDirection direction, Time when));
XoProto (extern Boolean, XoTraverseWidget, (Widget gw, Widget start, XoDirection direction, Time when));

/*
 * Defined Hooks
 */
typedef void    (*XoClassHook) (
#if NeedFunctionPrototypes
	XtPointer data
#endif
);

typedef struct _xo_func_hooks
{
	XoClassHook     func;
	XtPointer       data;
	struct _xo_func_hooks *next;
} XoFuncHooks;

XoProto (extern void, XoAddClassHook, (XoClassHook func, XtPointer data));
XoProto (extern void, XoRemoveClassHook, (XoClassHook func, XtPointer data));
XoProto (extern void, XoRemoveAllClassHooks, (void));

XoProto (extern void, XoSync, (Widget gw, long mask));
/*
 * Miscellaneous utilities
 */
XoProto (extern char *, XoNameString, (Widget gw, char *buffer, int len));
XoProto (extern char *, XoName, (Widget gw));
XoProto (extern char *, XoGeometryResultString, (XtGeometryResult geo));
XoProto (extern void, XoStackChild, (Widget gw, int stack_mode));
XoProto (extern void, XoMap, (Widget gw, int flag));
XoProto (extern void, XoEnablePopups, (Widget parent, int enable));
XoProto (extern void, XoConfWidget, (Widget gw, int x, int y, unsigned int width, unsigned int height, unsigned int border_width));
XoProto (extern void, XoEventLocation, (XEvent *e, Position *ret_x, Position *ret_y));
XoProto (extern Time, XoEventTime, (XEvent *e));
XoProto (extern Widget, XoShellGet, (Widget gw));
XoProto (extern Widget, XoShellFirstPopped, (Widget gw));
XoProto (extern Widget, XoShellTop, (Widget gw));
XoProto (extern Widget, XoShellTopRealized, (Widget gw));
XoProto (extern Widget, XoFocusWidgetGet, (Widget shell));
XoProto (extern Widget, XoFocusWidgetSet, (Widget shell, Widget gw));
XoProto (extern Boolean, XoFocusCheck, (Widget gw, XEvent *event));
XoProto (extern Visual *, XoVisualGet, (Widget gw));
XoProto (extern Boolean, XoWidgetIsColor, (Widget gw));
XoProto (extern Boolean, XoVisualColor, (Display *dpy, Visual *visual));
XoProto (extern void, XoWMAddFocusHandler, (Widget shell));
XoProto (extern void, XoWMAddDeleteHandler, (Widget shell));
XoProto (extern String, XoGetStringFromGravity, (XoGravity gravity));
XoProto (extern XoGravity, XoGetGravityFromString, (String str));
XoProto (extern String, XoGetStringFromJustify, (XoJustify justify));
XoProto (extern XoJustify, XoGetJustifyFromString, (String str));
XoProto (extern String, XoGetStringFromOrientation, (XoOrientation justify));
XoProto (extern XoOrientation, XoGetOrientationFromString, (String str));
XoProto (extern String, XoGetStringFromPointing, (XoPointing direction));
XoProto (extern XoPointing, XoGetPointingFromString, (String str));
XoProto (extern String, XoGetStringFromBackingStore, (int backing_store));
XoProto (extern int, XoGetBackingStoreFromString, (String str));
XoProto (extern void, _XoRegisterConverters, (void));
XoProto (extern Window, XoVirtualRootWindowOfScreen, (Screen *screen));

/*
 * Support for drawing various figures.  This is based on code from
 * Markus Stumpf <stumpf@informatik.tu-muenchen.de> posted to the FWF
 * mailing list on 7 July 1992.
 */

/*
 * The suggested height/width ratio for the checkmark
 */

#define CHECKMARK_AR	1.25
#define CHECKMARK_AR2	1.2

XoProto (extern int, XoMaybeScale,  (double value, int ref));
XoProto (extern void, XoScaleTranslate, (float (*from)[2], int npoints, XPoint *to, int x, int y, int width, int height));
XoProto (extern void, XoDrawToggleBox, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double boxwidth, double boxheight, int boxthick));
XoProto (extern void, XoOutlineShape, (Display *disp, Window win, GC gc, float (*shape)[2], int npoints, int x, int y, int width, int height));
XoProto (extern void, XoFillShape, (Display *disp, Window win, GC gc, float (*shape)[2], int npoints, int x, int y, int width, int height));
XoProto (extern void, XoDrawShape, (Display *disp, Window win, GC gc, float (*shape)[2], int npoints, int x, int y, int width, int height));
XoProto (extern void, XoOutlineCheckmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));;
XoProto (extern void, XoFillCheckmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));
XoProto (extern void, XoDrawCheckmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));
XoProto (extern void, XoDrawBoxedCheckmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double cmsize, double cmar));
XoProto (extern void, XoDrawBoxWithCheckmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double boxwidth, double boxheight, int boxthick, double cmsize, double cmar));
XoProto (extern void, XoDrawBoxedXlogo, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double xlsize, double xlar));
XoProto (extern void, XoDrawBoxWithXlogo, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double boxwidth, double boxheight, int boxthick, double xlsize, double xlar));
XoProto (extern void, XoOutlineXmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));
XoProto (extern void, XoFillXmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));
XoProto (extern void, XoDrawXmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height));
XoProto (extern void, XoDrawBoxedXmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double xmsize, double xmar));
XoProto (extern void, XoDrawBoxWithXmark, (Display *disp, Window win, GC gc, int x, int y, int width, int height, double boxwidth, double boxheight, int boxthick, double xmsize, double xmar));
XoProto (extern void, XoDrawShadowRect, (Display *disp, Window win, GC brightgc, GC darkgc, int x, int y, int width, int height, int thick, int sunshine, int outnotin));
XoProto (extern void, XoDrawShadowDiamond, (Display *disp, Window win, GC brightgc, GC darkgc, int x, int y, int width, int height, int thick, int sunshine, int outnotin));
XoProto (extern void, XoDrawShadowEllipse, (Display *disp, Window win, GC brightgc, GC darkgc, int x, int y, int width, int height, int thick, int sunshine, int outnotin));

/*
 * Some routines to access the gray information
 *
 * The first two implement a cache of pixmaps, one pixmap per screen
 * per gray level.  The pixmaps are ref counted so they can be
 * released, saving server resources.  Passing in True as the
 * value of isbitmap returns a bitmap.  In this case, fg and bg should
 * be set to 0 since refcnt does not matter.
 *
 * The PostScript routine writes to the specified file a string that
 * sets the postscript graphics state so that a fill operation will
 * have the required apearance.
 *
 * The last is a routine to register a string to Shading converter.
 */

XoProto (extern Pixmap,	XoShadingGetPixmap,	(Screen *, XoShading, Pixel fg, Pixel bg, int isbitmap));
XoProto (extern void,	XoShadingReleasePixmap,	(Pixmap));
XoProto (extern char *,	XoShadingPS,		(XoShading));
XoProto (extern void,	XoRegisterShadingConverter, (void));

/*
 * Support for menus.
 */

typedef enum
{
	XoPOPUP_NEW,			/* this is a new or first menu */
	XoPOPUP_NONE,			/* no more menus */

} XoPopupAction;

typedef struct _xo_popup_info
{
	Widget		pi_submenu;	/* new submenu */
	Widget		pi_start;	/* widget that "holds" the menu */
	Position	pi_root_x;	/* where to place the menu */
	Position	pi_root_y;	/* where to place the menu */
	XEvent		*pi_event;	/* the cause (may be NULL) */
	XoPopupAction	pi_action;	/* what to do */
	XoGravity	pi_where;	/* where to place menu */
} XoPopupInfo;

#endif /* _XO_XO_H_ */
