/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

#define INITSTRSIZE 500

int
read_collabels(data_in, xg)
  char *data_in;
  xgobidata *xg;
{
  char lab_file[110], suffix[4][8];
  char initstr[INITSTRSIZE];
  int i, j, nvar = 0, found = 0;
  FILE *fopen(), *fp;
  int unlink();

  /*
   * Use ncols here; allocate space for the brushing
   * groups variable label.
  */
  xg->collab = (char **) XtMalloc(
		(Cardinal) xg->ncols * sizeof (char *));
  for (j=0; j<xg->ncols; j++)
    xg->collab[j] = (char *) XtMalloc(
			(Cardinal) COLLABLEN * sizeof(char));

  xg->collab_tform = (char **) XtMalloc(
		(Cardinal) xg->ncols * sizeof (char *));
  for (j=0; j<xg->ncols; j++)
    xg->collab_tform[j] = (char *) XtMalloc(
			(Cardinal) (COLLABLEN+8) * sizeof(char));

/*
 * Check if variable label file exists, and open if so.
*/
  (void) strcpy(suffix[0],".col");
  (void) strcpy(suffix[1],".column");
  (void) strcpy(suffix[2],".collab");
  (void) strcpy(suffix[3],".var");

  if (data_in != NULL && strcmp(data_in,"stdin") != 0)
  {
    i = 0;
    while (found == 0 && i<4 )
    {
      (void) strcpy(lab_file, data_in);
      (void) strcat(lab_file, suffix[i++]);
      if ( (fp = fopen(lab_file,"r")) != NULL)
        found = 1;
    }
  }

/*
 * Read in variable labels or initiate them to generic if no label
 * file exists
*/
  if (found)
  {
    int len;
    nvar = 0;

    while (fgets(initstr, INITSTRSIZE-1, fp) != NULL)
    {
      len = MIN(strlen(initstr), COLLABLEN-1) ;
      while (initstr[len-1] == '\n' || initstr[len-1] == ' ')
        len-- ;
      strncpy(xg->collab[nvar], initstr, len) ;
      xg->collab[nvar][len] = '\0' ;

      nvar++;
      if (nvar >= xg->ncols_used)
        break;
    }

    if (nvar != xg->ncols_used)
    {
      (void) fprintf(stderr,
        "number of labels = %d, number of cols = %d\n",
        nvar, xg->ncols_used);
      for (i=nvar; i<xg->ncols_used; i++)
        (void) sprintf(xg->collab[i], "Var %d", i+1);
    }
    else
    {
    /*
     * If this is being run within S, remove the labels file that was
     * created by the S function.
    */
      if (Sprocess)
        if (unlink(lab_file) != 0)
          fprintf(stderr, "read_collabels: error in unlink");
    }
  }
  else
  {
    for (i=0; i<xg->ncols_used; i++)
      (void) sprintf(xg->collab[i], "Var %d", i+1);
  }

  /*
   * Put "group" in the extra (unmapped) column label.
  */
  strcpy(xg->collab[xg->ncols-1], "group");
  for (j=0; j<xg->ncols; j++)
    (void) strcpy(xg->collab_tform[j], xg->collab[j]);

  return(1);
}

int
read_rowlabels(data_in, xg)
  char *data_in;
  xgobidata *xg;
{
  char lab_file[110], suffix[3][8];
  char initstr[INITSTRSIZE];
  int i, ncase, found = 0;
  FILE *fopen(), *fp;
  int unlink();

  xg->rowlab = (char **) XtMalloc((Cardinal) xg->nrows * sizeof (char *));
  for (i=0; i<xg->nrows; i++)
    xg->rowlab[i] = (char *) XtMalloc((Cardinal) ROWLABLEN * sizeof(char));

/* Check if case label file exists, and open if so. */

  (void) strcpy(suffix[0],".row");
  (void) strcpy(suffix[1],".rowlab");
  (void) strcpy(suffix[2],".case");

  if (data_in != NULL && strcmp(data_in,"stdin") != 0)
  {
    i = 0;
    while (found == 0 && i<3 )
    {
      (void) strcpy(lab_file, data_in);
      (void) strcat(lab_file, suffix[i++]);
      if ( (fp = fopen(lab_file,"r")) != NULL)
        found = 1;
    }
  }
/*
 * Read in case labels or initiate them to generic if no label
 * file exists
*/
  if (found)
  {
    int len;
    ncase = 0;

    while (fgets(initstr, INITSTRSIZE-1, fp) != NULL)
    {
      len = MIN(strlen(initstr), ROWLABLEN-1) ;
      while (initstr[len-1] == '\n' || initstr[len-1] == ' ')
        len-- ;
      /*if (initstr[len-1] == '\n')*/
        /*len-- ;*/
      strncpy(xg->rowlab[ncase], initstr, len);
      xg->rowlab[ncase][len] = '\0' ;

      ncase++;
      if (ncase >= xg->nrows)
        break;
    }
    if (ncase != xg->nrows)
    {
      (void) fprintf(stderr, "number of labels = %d, number of rows = %d\n",
               ncase, xg->nrows);
      for (i=ncase; i<xg->nrows; i++)
        (void) sprintf(xg->rowlab[ncase], "%d", i+1);
    }
/*
 * If this is being run within S, remove the labels file that was
 * created by the S function.
*/
    else
    {
      if (Sprocess)
        if (unlink(lab_file) != 0)
          fprintf(stderr, "trouble in read_rowlabels");
    }
  }
  else
  {
    for (i=0; i<xg->nrows; i++)
      (void) sprintf(xg->rowlab[i], "%d", i+1);
  }
  return(1);
}
