/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
int under_brush(), xed_by_brush();
int glyph_color_pointtype();
/* */

static void
build_glyph_vectors(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k;
  static icoords obin0 = {NHBINS/2, NVBINS/2};
  static icoords obin1 = {NHBINS/2, NVBINS/2};
  icoords imin, imax;

  if (xg->is_transient)
  {
    imin.x = MIN(xg->bin0.x, obin0.x);
    imin.y = MIN(xg->bin0.y, obin0.y);
    imax.x = MAX(xg->bin1.x, obin1.x);
    imax.y = MAX(xg->bin1.y, obin1.y);
  }
  else
  {
    imin.x = xg->bin0.x;
    imin.y = xg->bin0.y;
    imax.x = xg->bin1.x;
    imax.y = xg->bin1.y;
  }

  for (ih=imin.x; ih<=imax.x; ih++)
  {
    for (iv=imin.y; iv<=imax.y; iv++)
    {
      for (m=0; m<xg->bincounts[ih][iv]; m++)
      {
      /*
       * j is the row number; k is the index of rows_in_plot[]
      */
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;
        if (xg->under_new_brush[j])
        {
          if (xg->is_undo)
          {
            xg->glyph_now[j].type = xg->glyph_prev[j].type;
            xg->glyph_now[j].size = xg->glyph_prev[j].size;
          }
          else
          {
            xg->glyph_now[j].type = xg->glyph_id.type;
            xg->glyph_now[j].size = xg->glyph_id.size;
          }

          if (!xg->is_transient)
          {
            xg->glyph_ids[j].type = xg->glyph_now[j].type;
            xg->glyph_ids[j].size = xg->glyph_now[j].size;
          }
        }
        else
        {
          xg->glyph_now[j].type = xg->glyph_ids[j].type;
          xg->glyph_now[j].size = xg->glyph_ids[j].size;
        }
        /*
         * Keep senddata up to date
        */
        xg->senddata[3 + xg->nrows_in_plot + k] = (unsigned long)
          glyph_color_pointtype(xg, j);
      }
    }
  }

  obin0.x = xg->bin0.x;
  obin0.y = xg->bin0.y;
  obin1.x = xg->bin1.x;
  obin1.y = xg->bin1.y;
}

static void
build_color_vectors(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k;
  static icoords obin0 = {NHBINS/2, NVBINS/2};
  static icoords obin1 = {NHBINS/2, NVBINS/2};
  icoords imin, imax;

  if (xg->is_transient)
  {
    imin.x = MIN(xg->bin0.x, obin0.x);
    imin.y = MIN(xg->bin0.y, obin0.y);
    imax.x = MAX(xg->bin1.x, obin1.x);
    imax.y = MAX(xg->bin1.y, obin1.y);
  }
  else
  {
    imin.x = xg->bin0.x;
    imin.y = xg->bin0.y;
    imax.x = xg->bin1.x;
    imax.y = xg->bin1.y;
  }

  for (ih=imin.x; ih<=imax.x; ih++)
  {
    for (iv=imin.y; iv<=imax.y; iv++)
    {
      for (m=0; m<xg->bincounts[ih][iv]; m++)
      {
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;
        if (xg->under_new_brush[j])
        {
          if (xg->is_undo)
            xg->color_now[j] = xg->color_prev[j];
          else
            xg->color_now[j] = xg->color_id;

          if (!xg->is_transient)
            xg->color_ids[j] = xg->color_now[j];
        }
        else
          xg->color_now[j] = xg->color_ids[j];
        /*
         * Keep senddata up to date
        */
        xg->senddata[3 + xg->nrows_in_plot + k] = (unsigned long)
          glyph_color_pointtype(xg, j);
      }
    }
  }
  obin0.x = xg->bin0.x;
  obin0.y = xg->bin0.y;
  obin1.x = xg->bin1.x;
  obin1.y = xg->bin1.y;
}

static void
build_erase_vector(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k;

  for (ih=xg->bin0.x; ih<=xg->bin1.x; ih++)
  {
    for (iv=xg->bin0.y; iv<=xg->bin1.y; iv++)
    {
      for (m=0; m<xg->bincounts[ih][iv]; m++)
      {
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;
        if (xg->under_new_brush[j])
        {
          xg->erased[j] = 1;
          /*
           * Keep senddata up to date
          */
          xg->senddata[3 + xg->nrows_in_plot + k] = (unsigned long)
            glyph_color_pointtype(xg, j);
        }
      }
    }
  }
}

void
init_glyph_ids(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nrows; j++)
  {
    xg->glyph_ids[j].type = xg->glyph_now[j].type =
      xg->glyph_prev[j].type = xg->glyph_0.type;
    xg->glyph_ids[j].size = xg->glyph_now[j].size =
      xg->glyph_prev[j].size = xg->glyph_0.size;
  }
}

void
init_color_ids(xg)
  xgobidata *xg;
{
  int j;

  xg->color_id = plotcolors.fg;
  for (j=0; j<xg->nrows; j++)
  {
    xg->color_ids[j] = xg->color_now[j] =
      xg->color_prev[j] = plotcolors.fg;
  }
}

void
init_erase(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nrows; j++)
    xg->erased[j] = 0;
}

void
active_paint_points(xg)
  xgobidata *xg;
{
  int ih, iv, j, pt;
/*
 * Set under_new_brush[j] to 1 if point j is inside the rectangular brush.
*/
  /* Zero out under_new_brush[] before looping */
  for (j=0; j<xg->nrows_in_plot; j++)
    xg->under_new_brush[xg->rows_in_plot[j]] = 0;

  /*
   * bincounts[][] and binarray[][][] only represent the the
   * rows in rows_in_plot[] so there's no need to test for that.
  */
  for (ih=xg->bin0.x; ih<=xg->bin1.x; ih++)
  {
    for (iv=xg->bin0.y; iv<=xg->bin1.y; iv++)
    {
      for (j=0; j<xg->bincounts[ih][iv]; j++)
      {
        pt = xg->rows_in_plot[xg->binarray[ih][iv][j]];
        if (!xg->erased[pt] && under_brush(xg, pt))
        {
          xg->under_new_brush[pt] = 1;
        }
      }
    }
  }

  /*
   * If we're erasing, build the erase vector (So far, this is strictly
   * a persistent operation, with no undo facility.)
  */
  if (xg->is_erase)
    build_erase_vector(xg);
  else
  {
    /*
     * Now, using the under_new_brush[] vector that only contains un-erased
     * points, build the color and glyph vectors.
    */
    if (xg->is_color_painting)
      build_color_vectors(xg);

    if (xg->is_glyph_painting)
      build_glyph_vectors(xg);
  }

}

void
init_line_colors(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nlinks; j++)
  {
    xg->line_color_ids[j] = xg->line_color_now[j] =
      xg->line_color_prev[j] = plotcolors.fg;
  }
}

static void
build_line_color_vectors(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nlinks; j++)
  {
    if (xg->xed_by_new_brush[j])
    {
      if (xg->is_undo)
        xg->line_color_now[j] = xg->line_color_prev[j];
      else
        xg->line_color_now[j] = xg->color_id;

      if (!xg->is_transient)
        xg->line_color_ids[j] = xg->line_color_now[j];
    }
    else
      xg->line_color_now[j] = xg->line_color_ids[j];
  }
}

void
active_paint_lines(xg)
  xgobidata *xg;
{
  int j, from, to;
/*
 * Set xed_by_new_brush[j] to 1 if line j intersects the crosshair brush.
 * If we're also point painting and the rectangular brush is shown,
 * then also set xed_by_new_brush[j] to 1 if both a and b are contained
 * within the brush.
*/
  for (j=0; j<xg->nlinks; j++)
  {
    from = xg->connecting_lines[j].a - 1;
    to = xg->connecting_lines[j].b - 1;
    xg->xed_by_new_brush[j] = 0;
    if (!xg->erased[from] && !xg->erased[to])
    {
      if (xed_by_brush(xg, from, to))
        xg->xed_by_new_brush[j] = 1;
      else
      {
        if (xg->is_point_painting)
        {
          if (under_brush(xg, from) && under_brush(xg, to))
            xg->xed_by_new_brush[j] = 1;
        }
      }
    }
  }

  if (xg->is_color_painting)
    build_line_color_vectors(xg);
}
