/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* functions used in this file */
float mean_fn2();
/* */

#define EXPMINUS1 0.3678794411714423
#define ONEMINUSEXPMINUS1 0.63212056

static float *h0, *h1;
static float acoefs;

void
alloc_central_mass(n)
  int n;
{
  h0 = (float *) XtMalloc((unsigned int) n*sizeof(float *));
  h1 = (float *) XtMalloc((unsigned int) n*sizeof(float *));
}

void
free_central_mass()
{
  XtFree((XtPointer) h0);
  XtFree((XtPointer) h1);
}

float
central_mass_index(proj_data, n, rows_in_plot)
  float **proj_data;
  int n, *rows_in_plot;
{
  int i, m;
  float indx_val;
  double sqrt(), exp();

/* Calculate coefficients */
  for (i=0; i<n; i++)
  {
    m = rows_in_plot[i];
    h0[m] = exp(-proj_data[0][m]*proj_data[0][m]/2.) ;
    h1[m] = exp(-proj_data[1][m]*proj_data[1][m]/2.) ;
  }

/* Calculate index */
  acoefs = mean_fn2(h0,h1,n,rows_in_plot);
  indx_val = (acoefs - (float)EXPMINUS1)/(float)ONEMINUSEXPMINUS1 ;
  return(indx_val);
}

void
central_mass_deriv(data, proj_data, alpha, beta, derivs, n, rows_in_plot, p, nactive, active_vars)
  float **data;
  float **proj_data;
  float *alpha, *beta;
  float **derivs;
  int *active_vars, *rows_in_plot;
  int n, p, nactive;
{
  int i, k, m;
  float tmpf;

  for (i=0; i<2; i++)
    for (k=0; k<p; k++)
      derivs[i][k] = 0.;

/* alpha */
  for (k=0; k<nactive; k++)
  {
    tmpf = 0.;
    for (i=0; i<n; i++)
    {
      m = rows_in_plot[i];
      tmpf -= (proj_data[0][m]*h0[m]*h1[m]*
        (data[m][active_vars[k]] -
        alpha[active_vars[k]]*proj_data[0][m] -
        beta[active_vars[k]]*proj_data[1][m]));
    }
    tmpf /= ((float)n);
    derivs[0][active_vars[k]] = tmpf;
  }

/* beta */
  for (k=0; k<nactive; k++)
  {
    tmpf = 0.;
    for (i=0; i<n; i++)
    {
      m = rows_in_plot[i];
      tmpf -= (proj_data[1][m]*h0[m]*h1[m]*
        (data[m][active_vars[k]] -
        alpha[active_vars[k]]*proj_data[0][m] -
        beta[active_vars[k]]*proj_data[1][m]));
    }
    tmpf /= ((float)n);
    derivs[1][active_vars[k]] = tmpf;
  }

}

#undef EXPMINUS1
#undef ONEMINUSEXPMINUS1
