.TH ICOL  1 "1992" "AHPCRC"
.SH NAME
icol \- Interpolated Color Map Editor
.SH SYNOPSIS
\fBicol\fR [ \-toolkit_option ] [ \-option ] [ colormap_file ]
.SH DESCRIPTION
Icol is an interactive tool for sketching and modifying
color maps that are interpolated between key points.  
Color maps are often used to create images from arrays of scalar data,
such as temperature, density or stress.  Icol can assign colors
to key values and interpolate in several color spaces.
Icol can also edit maps of different lengths.
.PP
The icol
display contains a menu bar and three work areas.  The
.B control
menu is used for opening a file, saving the current color bar to
a file, picking a color index in another window, filing bug reports, 
and quitting.  The
.B edit
menu controls the "snapping" of color channels between knot points,
and undo.  To automatically place knot points, try the 
\fBPlace Knots\fR command.
.PP
The
.B mode
menu allows editing in either the RGB (red green blue),
HSV (hue saturation value), or YUV (video) color space.
The 
.B mode
menu also contains toggles for automatically saving the color table
and color map usage.
The 
.B brush
menu controls sketching in the graph area.
.PP
The top area displays the
color bar and a graph of each color channel, in either RGB, HSV or YUV
color space.  
The graphs can be changed by sketching 
with the pointer, using a brush from the 
.B brush
menu.
.PP
The middle area displays all the colors in the above color bar, but
with each color in its own box.  Clicking on a box selects that color
and places a knot at that point.  Clicking on the selected color
removes the knot.  Click and drag a knot to move it to a new cell.
.PP
The bottom area contains three scales for changing the color channels
of the selected knot.  When a channel is changed, all the colors
between the selected knot and the neighboring knots will be proportionally
changed.
.PP
By selecting knots and changing channels, it is possible to create
color ramps between cells.  
.PP
The 
.B snap
menu item in the edit menu linearly interpolates colors between
the selected knot and neighboring knots.  The effect is to pull
the lines tight at the selected knot.
.B "Snap All"
snaps all of the knots, and the remaining menu selections snap
individual channels at the selected knot point.
.sp
.SH COLOR SPACES
Our retina is equipped with three kinds of receptors, 
each with a different response to light wavelength.  
Thus we perceive the range of light to be a color space with three dimensions.
The three response curves peak at "blue", "green" and "red" wavelengths
respectively.  The green and red response is much higher than blue,
with green being perceived as brightest.
.PP
The most straightforward system is to specify a color using red, green
and blue coordinates, or RGB.  Computer monitors are driven with RGB
voltages, and most color bar formats store colors as a triplet of
red, green and blue values.  Each value has a range from zero to 255,
so that it can be stored in a single byte.  Using this method over 16 million
colors can be created, more colors than there are pixels on the screen,
and probably more than the eye can distinguish.
.PP
The hue, saturation and value, or HSV, color space is convenient 
for creating color bars
of known saturation or value, while varying the hue.  Hue corresponds to
the angle in a color wheel, and ranges from zero to 360 degrees.  Saturation
is the purity of the color, with zero saturation corresponding to levels of 
grey.  Value is the brightness of a color.  For example, zero hue, full saturation
and full value is red.   Zero hue, half saturation and full value is pink.
.PP
Because green is much brighter to the eye than blue or red, a simple color
bar that ranges at constant saturation and value through all the hues
will have a bright "spike" in the greens.  For better control of brightness,
try the YUV color space, which is a color encoding used for video.
YUV is a linear rearrangement of RGB.
The Y channel is called luminance, and is the channel shown on a black and
white television.  The equation for Y is about six tenths green, three tenths
red and one tenth blue.  A color bar with constant Y should look constantly
bright, independent of hue.  U and V encode the color information.
U is blue minus luminance and V is red minus luminance.
.PP
Experiment with the different color spaces by flipping back and forth, using the
.B mode
menu.
.SH MOUSE ACTIONS
In the top area, clicking and dragging the mouse sketches the color value.
Clicking above the initial value makes the brush push values down.
Clicking below the initial value makes the brush push values up.
.IP "Left Button"
Edit the red line, which is either the red channel, hue, or luminance (Y),
depending on the color space mode.
.IP "Middle Button"
Edit the green line, which is either green, saturation, or U.
.IP "Left Button"
Edit the blue line, which is either blue, value, or V.
.IP "Shift + Button"
Place a knot, as if the color was selected in the middle area.
.PP
In the middle area, clicking places and removes knots:
.IP "Button"
Select or create a knot.  If the knot is already selected, remove the
knot.  Click and drag to move the knot point.
.IP "Shift + Button"
Snap the knot point, in addition to selecting and moving.
.SH OPTIONS
Each option has a corresponding X resource.  The resource class
name is the same as the resource name with
the first letter capitalized.
.IP "-output | -o file  (resource: output)"
Use \fBfile\fR as the output file name.  The default is a dash, -,
which specifies standard output.
.IP "-autosave | -a  (resource: autoSave)"
Automatically save to the output file after each change.
.IP "-colormode | -m mode (resource: colorMode)"
Use the \fBmode\fR color space.  The mode can be
\fBrgb\fR, \fBhsv\fR or \fByuv\fR.  The default is \fBrgb\fR.
.IP "-colorguide | -g  (resource: colorGuide)"
Force the use of colored backgrounds for the color scale controls.
With color guide enabled the scale background indicates the color 
for that scale location.  It is a view down the axes,
from the current color, of the color space.  
.IP
The color guide option consumes 96 color indecies, which will cut
down the resolution for the color bar itself on 8 bit visual.
If there are enough color entries to accommodate both the color bar and
color scales, color guide is automatically enabled.  This is usually true
only for deep (12 plane) PsuedoColor visuals.
.IP "-stomp | -s  (resource: stomp)"
Stomp on (i.e. use for the color map) the first \fBnumcolor\fR index entries.
This option is useful in conjunction with other raster tools that
use these entries, such as xraster and xvcr.  
.IP
If there are
enough color entries, the lower entries are always stomped on, 
and \fBicol\fR uses higher entries for the interface.  If there are
a limited number of entries (e.g. a 256 color table on a 
256 (8 bit) color system), the lower colors are stomped on only when
the mouse is pressed on the chart region or a scroll bar.  This way
the interface can be seen when not manipulating colors.
.IP "-format | -f name  (resource: fileFormat)"
Set the default file format to \fBname\fR.
Four file formats are currently supported.  Indexed text 
(\fBasciiIndex\fR) has color map entries stored in quadruples
(index red green blue), with each r/g/b value scaled from
zero to 255.  Plain text (\fBasciiPlain\fR) lists 
triplets (red green blue) in index order, one per line, scaled 
from zero to 255.  Interleaved binary (\fBbinLeave\fR) contains three
bytes per index value, in index order (i.e. rgbrgbrgb...).
Non-interleaved binary (\fBbinRow\fR) has one byte per value,
with all of the red values first, then green, then blue (i.e. 
rrr...ggg...bbb...).  The NCSA tool paltohdf can convert between \fBbinRow\fR
format and HDF color palettes.
.IP "-numcolor | -n number  (resource: numColor)"
Use a color table with \fBnumber\fR entries, minimum four.  The default
is 256 entries.
.IP "-maxundo | -u number  (resource: maxUndo)"
Remember a maximum of \fBnumber\fR colorbars on the undo stack.
Each colorbar takes about 4k of memory.  Default is 40.
.IP "-rootvis | -r  (resource: rootVisual)"
Use the same visual as the root window.  See caveats.  
.IP "-help | -h  (resource: help)"
Print on standard error a quick command summary.
.SH ADDITIONAL RESOURCES
.IP "bugAddress: mail_address"
A string resource specifying the mail address to send bug reports.
.IP "quickSegment: number"
When updating the chart graph while sketching or dragging a scrollbar,
icol uses fewer line segments to increase drawing speed.  If your
X server is too slow, try setting quickSegment to a lower number,
like 24.  The default is 48 line segments.
.SH CAVEATS
Icol attempts to use the deepest PseudoColor visual available.
This may cause problems with respect to the Motif toolkit.
If your display supports deeper visuals than the root visual
(e.g. 12 plane PseudoColor) and icol dies on startup with a
"Bad Match" X error, run icol as 'icol -rootvis'.
.PP
The version of Motif shipped with IRIX 4.0 works correctly.
.PP
I realize that the indexed ascii file format (the default in the 
supplied application defaults file) is peculiar.  
It is popular at the AHPCRC.  Edit the application defaults file
(Icol) or your own resource file to change the default format.
.SH RESTRICTIONS
A workstation with mapped color (psuedocolor) graphics is required.
.PP
The smallest supported color table size is 4.
.SH FILE
/usr/lib/X11/app-defaults/Icol  -  application defaults
.SH AUTHOR
Ken Chin-Purcell, AHPCRC
.br
Mail to gvlware@ahpcrc.umn.edu, or use the \fBBug Report\fR command in icol.
