/* pointlist.h: lineaire lijsten van POINTs */

#ifndef _POINTLIST_H_
#define _POINTLIST_H_

#include "point.h"
#include "List.h"

typedef struct POINTLIST {
	struct POINT *point;
	struct POINTLIST *next;
} POINTLIST;

#define PointListCreate	(POINTLIST *)ListCreate

#define PointListAdd(pointlist, point)	\
        (POINTLIST *)ListAdd((LIST *)pointlist, (void *)point)

#define PointListCount(pointlist) \
        ListCount((LIST *)pointlist)

#define PointListGet(pointlist, index) \
        (POINT *)ListGet((LIST *)pointlist, index)

#define PointListNext(ppointlist) \
        (POINT *)ListNext((LIST **)ppointlist)

#define PointListRemove(pointlist, point) \
        (POINTLIST *)ListRemove((LIST *)pointlist, (void *)point)

#define PointListIterate(pointlist, proc) \
        ListIterate((LIST *)pointlist, (void (*)(void *))proc)

#define PointListDestroy(pointlist) \
        ListDestroy((LIST *)pointlist)

extern struct POINT *PointListFind(struct POINTLIST *pl, struct POINT *point);

#endif /* _POINTLIST_H_ */
