/* monitor.c: keep an eye on what happens with some patches */

#include "monitor.h"
#include "patchlist.h"
#include "error.h"

int monitored=0;	/* set to one to activate monitoring */

static PATCHLIST *patches_to_be_monitored = (PATCHLIST *)NULL;

int MonitorSelected(PATCH *patch)
{
	PATCHLIST *pl;
	PATCH *p;

	pl = patches_to_be_monitored;
	while ((p = PatchListNext(&pl))) 
		if (p == patch)
			return TRUE;

	return FALSE;
}

void MonitorSelectPatch(PATCH *patch)
{
	if (MonitorSelected(patch))
		Error(NULL, "Patch %d is already being monitored.", patch->id);
	else {
		patches_to_be_monitored = PatchListAdd(patches_to_be_monitored, patch);
		Warning(NULL, "Patch %d is now being monitored.", patch->id);
	}
}

void MonitorUnselectPatch(PATCH *patch)
{
	if (!MonitorSelected(patch))
		Error(NULL, "Patch %d is not yet being monitored.", patch->id);
	else {
		patches_to_be_monitored = PatchListRemove(patches_to_be_monitored, patch);
		Warning(NULL, "Patch %d is now not being monitored anymore.", patch->id);
	}
}

