/* interaction.h */

#ifndef _INTERACTION_H_
#define _INTERACTION_H_

#include "patch.h"
#include "Float.h"

typedef struct INTERACTION {
	struct 	PATCH	*P, *Q;		/* two interacting patches */	
	Float	*K;			/* coupling coefficient(s) = generalized formfactors
					 * when using a basis with a basis functions, this
					 * is a a x a matrix. We store it row by row, top
					 * to bottom and not as a Float ** to
					 * save the place that would be needed to store 
					 * the pointers to the beginning of each row. */
	Float	deltaK;			/* used for approximation error estimation over the link */
} INTERACTION;

extern struct INTERACTION *InteractionCreate(struct PATCH *P, struct PATCH *Q, 
					     Float K[][], Float deltaK);
extern void InteractionDestroy(struct INTERACTION *interaction);

#include <stdio.h>
extern void InteractionPrint(FILE *out, INTERACTION *interaction);

extern int GetNumberOfInteractions(void);
#endif /*_INTERACTION_H_*/
