/*
   File: main.cc

   By: Alex Theo de Jong
   Created: February 1996

   Description:
   Test Synchronization object for multiple streams
*/

#pragma implementation

#include "athread.hh" // Test OS independent threads/sema/lock classes

#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <iostream.h>
#include <fstream.h>
#include <unistd.h>

#include "error.hh"
#include "debug.hh"
#include "util.hh"

#include "sync.hh"


extern "C" {
unsigned int sleep(unsigned int);
}

int c1(0), c2(0);

void* producer_thread(Synchronization* s){
  int counter1=5, counter2=10, counter3=5;
  ifstream file("mpeg2buff.o");
  char data[3];

  msg("producer_thread"); message(itoa(getpid()));

  while (1){
    file.read(data, 2);
    s->put(double(counter1));
      s->put(1, double(counter2), 8);
//      s->put(2, double(counter2), 100);
    if ((counter2 % 2)==0){
//      s->put(1, double(counter2), 100);
//      s->put(2, double(counter2), 100);   
    }
//    if ((counter3 % 3)==0) s->put(2, double(counter3), 100);
    if ((counter1 % 10)==0){
      msg("\n");
    }

    if (counter1++>40) break;
    counter2++;
    counter3++;
    sleep(1);
  }

  athr_exit(0);
  return 0;
}

void* consumer2_thread(Synchronization* s);
Synchronization* snc=0;

void* consumer1_thread(Synchronization* s){
  msg("consumer1_thread"); message(itoa(getpid()));

  athr_t id3;
//  athr_create((void*(*)(void*))consumer2_thread, snc, &id3);

  while (1){
    printf("byte %d\n",s->usedbytes(1, 100));
    printf("byte %d\n",s->usedbytes(1, 100));
printf("consumer 1 vor wait 1\n");
    s->wait(1);
printf("consumer 1 nach wait 1\n");
    msg(">");
    c1++;
  }

  athr_exit(0);
  return 0;
}

void* consumer2_thread(Synchronization* s){
  msg("consumer2_thread"); message(itoa(getpid()));

  while (1){
    s->usedbytes(2, 100);
    s->wait(2);
//    sleep(1);
    msg("<");
    c2++;
  }

  athr_exit(0);
  return 0;
}


main(){
  Synchronization* sync=0;
  athr_t id, id2; // id3;

/*
  if (schedctl(NDPRI, 0, 40)<0) // default priority
    cerr << "could not set NDPNORMMAX for main\n";
*/
  
  snc=sync=new Synchronization(0, 100, 200);   // Default = type 0, 2x Data, 1x Timer
  athr_create((void*(*)(void*))producer_thread, sync, &id);
  athr_create((void*(*)(void*))consumer1_thread, sync, &id2);

  sched_param param;
  int policy=0;
  if (athr_getschedparam(athr_self(), &policy, &param)<0){
    error("could not get scheduling params");
    athr_exit(0);
  }
  else {
#ifdef LINUX
    msg("MAIN PRIORITY="); message(itoa(param.sched_priority));
#else
    msg("MAIN PRIORITY="); message(itoa(param.prio));
#endif
  }

  char* c=new char[10];
/*
  cout << "test\n";   // small test to see if cin blocks! and cout really 
  cout << "test2";    // put stuff on the screeen
  cout.flush();
  printf("did I stop?\n");
  cin.gets(&c);
  printf("I guess not!");
*/

  do {
    msg("Type 'q' to quit: ");
    c[0]=getchar();
    switch(c[0]){
      case '0' : msg("ok"); break;
      default  : break;
    }
  }
  while (c[0]!='q' && c[0]!='Q');
  delete c;

  athr_join(id);

  String text="Consumer 1 : ";
  text+=itoa(c1);
  text+=", Consumer 2 : ";
  text+=itoa(c2);
  message(text.chars());
printf("vor delete\n");
  delete sync;
printf("nach delete\n");
  exit(0);
}
