#include "mpeg.h"		/* for typedef's and PROTO macro*/


/* util.c */
void correct_underflow PROTO((void ));
int next_bits PROTO((int num , unsigned int mask ));
char *get_ext_data PROTO((void ));
int next_start_code PROTO((void ));
char *get_extra_bit_info PROTO((void ));

/* video.c */
void init_stats PROTO((void ));
void PrintAllStats PROTO((void ));
double ReadSysClock PROTO((void ));
VidStream *NewVidStream PROTO((int bufLength ));
void DestroyVidStream PROTO((VidStream *astream ));
PictImage *NewPictImage PROTO((unsigned int width , unsigned int height ));
void DestroyPictImage PROTO((PictImage *apictimage ));
VidStream *mpegVidRsrc PROTO((TimeStamp time_stamp , VidStream *vid_stream ));
void ToggleBFlag PROTO((void ));
void TogglePFlag PROTO((void ));

/* parseblock.c */
void ParseReconBlock PROTO((int n ));
void ParseAwayBlock PROTO((int n ));

/* motionvector.c */
void ComputeForwVector PROTO((int *recon_right_for_ptr , int *recon_down_for_ptr ));
void ComputeBackVector PROTO((int *recon_right_back_ptr , int *recon_down_back_ptr ));

/* decoders.c */
void init_tables PROTO((void ));
void decodeDCTDCSizeLum PROTO((unsigned int *value ));
void decodeDCTDCSizeChrom PROTO((unsigned int *value ));
void decodeDCTCoeffFirst PROTO((unsigned int *run , int *level ));
void decodeDCTCoeffNext PROTO((unsigned int *run , int *level ));

/* gdith.c */
void InitColor PROTO((void ));

/* fs2.c */
void InitFS2Dither PROTO((void ));
void FS2DitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *disp , int rows , int cols ));

/* fs2fast.c */
void InitFS2FastDither PROTO((void ));
void FS2FastDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* fs4.c */
void InitFS4Dither PROTO((void ));
void FS4DitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *disp , int rows , int cols ));

/* hybrid.c */
void InitHybridDither PROTO((void ));
void HybridDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* hybriderr.c */
void InitHybridErrorDither PROTO((void ));
void HybridErrorDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* 2x2.c */
void Init2x2Dither PROTO((void ));
void RandInit PROTO((int h , int w ));
void PostInit2x2Dither PROTO((void ));
void Twox2DitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* gray.c */
void GrayDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* mono.c */

/* jrevdct.c */
void init_pre_idct PROTO((void ));
void j_rev_dct_sparse PROTO((DCTBLOCK data , int pos ));
void j_rev_dct PROTO((DCTBLOCK data ));
void j_rev_dct_sparse PROTO((DCTBLOCK data , int pos ));
void j_rev_dct PROTO((DCTBLOCK data ));

/* 24bit.c */
void InitColorDither PROTO((void ));
void ColorDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int rows , int cols ));

/* ordered.c */
void InitOrderedDither PROTO((void ));
void OrderedDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* ordered2.c */
void InitOrdered2Dither PROTO((void ));
void Ordered2DitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* mb_ordered.c */
void InitMBOrderedDither PROTO((void ));
void MBOrderedDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));
void MBOrderedDitherDisplayCopy PROTO((VidStream *vid_stream , int mb_addr , int motion_forw , int r_right_forw , int r_down_forw , int motion_back , int r_right_back , int r_down_back , unsigned char *past , unsigned char *future ));

/* globals.c */
int dprintf (char *format, ...);
int get_more_data PROTO((unsigned int *buf_start , int max_length , int *length_ptr , unsigned int **buf_ptr ));
void DoDitherImage PROTO((unsigned char *l , unsigned char *Cr , unsigned char *Cb , unsigned char *disp , int h , int w ));
void ExecuteDisplay PROTO((VidStream *vid_stream ));
