 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: spectrum.c
 >>>>
 >>>>      Program Name: spectrum
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	An interactive signal/image classification system.
 >>>>	
 >>>>	

 >>>>            Author: Danielle Argiro
 >>>>
 >>>> Date Last Updated: Wed Oct  2 17:10:50 1991
 >>>>
 >>>>          Routines: main- the main program for spectrum
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "spectrum.h"


/****************************************************************
 *
 * Routine Name:  main program for spectrum
 *
 *       Input:  
 *
 *
 *          [-i] input image filename
 *          [-l] input legend filename
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        char *legendfile = NULL, *imagefile = NULL;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (spectrum->i != NULL)
           imagefile = xvf_strcpy(spectrum->i);

        if (spectrum->l != NULL)
           legendfile = xvf_strcpy(spectrum->l);

/* -main_before_lib_call_end */

/* -main_library_call */
        if (!(run_master(argc, argv, program, imagefile, legendfile)))
        {
            fprintf(stderr, "lspectrum failed.\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for spectrum 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "spectrum :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tAn interactive signal/image classification system.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-l]  input legend filename (infile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for spectrum\n");
	fprintf(stderr, "\t[-V] Gives the version for spectrum\n");
	fprintf(stderr, "\t[-U] Gives the usage for spectrum\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called spectrum.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses spectrum.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for spectrum
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*l_pstr = 
	"\nEnter: (l) input legend filename \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "spectrum", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "spectrum.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "spectrum: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "spectrum.ans");
		}

	     }

	}

	/*
	 * allocate the spectrum structure
	 */
	spectrum = (spectrum_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (spectrum_struct));

	/*
	 * get optional arguments for spectrum
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	spectrum->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(spectrum->i))
;

	spectrum->l_flag = vget_infile(fid, prompt_flag,
	"-l", l_pstr, &(spectrum->l))
;


}



