 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "spectrum.h"

/********************************************************
*
*  Routine Name:  run_disp_subform
*
*       Purpose:  drives the subform 'disp_subform'
*
*         Input:  form - pointer to the form tree 
*		  disp_subform_info  - information structure for subform 
*				       'disp_subform'
*        Output:  action of the application program
*     Called By:  run_master()
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_disp_subform(form, disp_subform_info)

xvf_form *form;
master_disp_subform *disp_subform_info;
{

	_xvf_get_disp_subform(form, disp_subform_info);

	/*
	 * action came from the 'disp' pane
	 */
	if (disp_subform_info->disp_selected)
	    run_disp(form, disp_subform_info->disp);


}   /* end run_disp_subform */





/********************************************************
*
*  Routine Name:  run_disp
*
*       Purpose:  drives the pane 'disp'
*
*         Input:  form - pointer to the form tree 
*		  disp_info  - information structure for pane 'disp'
*        Output:  action of the application program
*
*     Called By:  run_disp_subform()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_disp(form, disp_info)

xvf_form *form;
disp_subform_disp *disp_info;
{

	_xvf_get_disp(form, disp_info);

	/*
	 * user clicked on 'live' cycle selection 'norm_type'
	 */
	if (disp_info->norm_type_selected)
	{
	     spc_norm_type = disp_info->norm_type;
	     if (spc_norm_type == SpcNormOFF)
	     {
		xvf_change_input(form, disp_info->norm_time_index,
				  xvf_logicalval_chng, "0", 0);
		xvf_change_input(form, disp_info->norm_time_index,
				  xvf_activation_chng, "0", 0);
	     }
	     else if (spc_norm_type == SpcNormLocal)
		xvf_change_input(form, disp_info->norm_time_index,
				  xvf_activation_chng, "1", 0);
	
	     if (spc_image != NULL) update_normalization();
	}

	/*
	 * user clicked on 'live' logical selection 'norm_time'
	 */
	else if (disp_info->norm_time_selected)
	{
	     spc_norm_time = disp_info->norm_time;
	     if (spc_image != NULL) update_normalization();
	}

	/*
	 * user clicked on 'live' logical selection 'norm_method'
	 */
	else if (disp_info->norm_method_selected)
	{
	     spc_norm_method = disp_info->norm_method;
	     if (spc_image != NULL) update_normalization();
	}


	/*
	 * user clicked on 'live' string selection 'norm_method'
	 */
	else if (disp_info->file_view_selected)
	{
	    xvf_create_view(disp_info->file_view, "File Viewer", "Viewer");
	}

	else if (spc_image == NULL)
	{
	     xvf_error_wait("Please input a VIFF image before attempting other operations", "Spectrum", NULL);

	     /* if they changed one of the functions, put it back */
	     if (disp_info->red_func_selected)
	         xvf_change_input(form, disp_info->red_func_index, 
				  xvf_stringval_chng, current_red_func, 30);
	     else if (disp_info->green_func_selected)
	         xvf_change_input(form, disp_info->green_func_index, 
				  xvf_stringval_chng, current_green_func, 30);
	     else if (disp_info->blue_func_selected)
	         xvf_change_input(form, disp_info->blue_func_index, 
				  xvf_stringval_chng, current_blue_func, 30);
	}

	/*
	 * user clicked on pane action button 'red'
         * change map column used as red band as desired
	 */
	else if (disp_info->red)
	{
             change_band_map(form, disp_info->red_index + 1, 
			     disp_info->red_func_index, SpcRed);
             update_xcolors_from_legend();
	}

	/*
	 * user clicked on pane action button 'green'
         * change map column used as green band as desired
	 */
	else if (disp_info->green)
	{
             change_band_map(form, disp_info->green_index + 1, 
			     disp_info->green_func_index, SpcGreen);
             update_xcolors_from_legend();
	}

	/*
	 * user clicked on pane action button 'blue'
         * change map column used as blue band as desired
	 */
	else if (disp_info->blue)
	{
             change_band_map(form, disp_info->blue_index + 1, 
			     disp_info->blue_func_index, SpcBlue);
             update_xcolors_from_legend();
	}

        /*
         * user clicked on live string selection 'red_func'
         * change map column used as red band as defined by function
         */
        else if (disp_info->red_func_selected)
	{
	     change_band_function(disp_info->red_func, SpcRed);
             update_xcolors_from_legend();
	     xvf_change_input(form, disp_info->red_index + 1, xvf_title_chng,
			      disp_info->red_func, 30);
	     xvd_update_xcolors(xvdisplay);
	}

        /*
         * user clicked on live string selection 'green_func'
         * change map column used as green band as defined by function
         */
        else if (disp_info->green_func_selected)
	{
	     change_band_function(disp_info->green_func, SpcGreen);
             update_xcolors_from_legend();
	     xvf_change_input(form, disp_info->green_index + 1, xvf_title_chng,
			      disp_info->green_func, 30);
	     xvd_update_xcolors(xvdisplay);
	}

        /*
         * user clicked on live string selection 'blue_func'
         * change map column used as blue band as defined by function
         */
        else if (disp_info->blue_func_selected)
	{
	     change_band_function(disp_info->blue_func, SpcBlue);
             update_xcolors_from_legend();
	     xvf_change_input(form, disp_info->blue_index + 1, xvf_title_chng,
			      disp_info->blue_func, 30);
	     xvd_update_xcolors(xvdisplay);
	}

}



/********************************************************
*
*  Routine Name:  update_normalization
*
*       Purpose:  updates the display according to current
*		  normalization type, normalization time, and/or
*		  normalization method.
*
*         Input:  none
*        Output:  none
*     Called By:  run_disp()
*    Written By:  Danielle Argiro
*
********************************************************/

update_normalization()
{
	update_band_col(SpcRed);
	update_band_col(SpcGreen);
	update_band_col(SpcBlue);
	update_xcolors_from_legend();
	xvd_update_xcolors(xvdisplay);
}
