/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Sraw2viff.c
 >>>>
 >>>>      Program Name: Sraw2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts GE Signa Magnet raw (time domain)  images  to  VIFF
 >>>>	format files (complex, real and/or imaginary).
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:25:13 1991
 >>>>
 >>>>          Routines: main- the main program for Sraw2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "Sraw2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for Sraw2viff
 *
 *       Input:  
 *           -i  input signa raw image file 
 *
 *
 *           [-o1] complex output file (VIFF)
 *           [-o2] real part output filename
 *           [-o3] imaginary part output filename
 *           [-r] number of rows  (value >= 0)
 *           [-c] number of columns  (value >= 0)
 *           [-h] byte offset from the start of the input data file  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1, *img2, *img3;
int     single_voxel, header_offset, numbands, nrows, ncols, row_offset;
int     col_offset, type;
char    *malloc();
int     file;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

single_voxel = 0;
header_offset = Sraw2viff->h_int;
numbands = 1;
nrows = Sraw2viff->r_int;
ncols = Sraw2viff->c_int;
row_offset = 0;
col_offset = 0;
type = VFF_TYP_2_BYTE;

/* Make sure that at least one output file type has been selected */
if ((!Sraw2viff->o1_flag) && (!Sraw2viff->o3_flag) && (!Sraw2viff->o3_flag))
{
  (void) fprintf(stderr,"Sraw2viff:  specify at least one output file\n");
  exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */

if ( (file = open_input(Sraw2viff->i_file)) < 0)
{
  (void) fprintf(stderr,"Sraw2viff: Unable to access input file %s \n",Sraw2viff->i_file);
  exit(1);
}

/* Call the conversion utility to create and organize the complex VIFF file. */
if(! sig2viff(file, &img1, nrows, ncols, header_offset, type, 
                 single_voxel, row_offset, col_offset, numbands))
{
  (void) fprintf(stderr, "sig2viff Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */

/* If real output file is specified, create that image by copying the
   complex image and then calling lctor */
if (Sraw2viff->o2_flag)
{
  if ((img2=(struct xvimage *)malloc(sizeof(struct xvimage)))==NULL)
  {
    (void) fprintf(stderr,"Sraw2viff: malloc failed\n");
    exit(1);
  }
  if (!(copyheader(img1, img2)))           
  {
    (void) fprintf(stderr, "copyheader for %s Failed\n", Sraw2viff->o2_file);
    exit(1);
  }
  if (!(copyimagedata(img1, &img2, 1)))   
  {
    (void)fprintf(stderr, "copyimagedata for %s Failed\n", Sraw2viff->o2_file);
    exit(1);
  }
  if (!(lvctor(img2, 1)))
  {
    (void) fprintf(stderr, "lvctor for %s Failed\n", Sraw2viff->o2_file);
    exit(1);
  }
}

/* If imaginary output file is specified, create that image by copying the
   complex image and then calling lctor */
if (Sraw2viff->o3_flag)
{
  if ((img3=(struct xvimage *)malloc(sizeof(struct xvimage)))==NULL)
  {
    (void) fprintf(stderr,"Sraw2viff: malloc failed\n");
    exit(1);
  }
  if (!(copyheader(img1, img3)))
  {
    (void) fprintf(stderr, "copyheader for %s Failed\n", Sraw2viff->o3_file);
    exit(1);
  }
  if (!(copyimagedata(img1, &img3, 1)))  
  {
    (void)fprintf(stderr, "copyimagedata for %s Failed\n", Sraw2viff->o3_file);
    exit(1);
  }
  if (!(lvctor(img3, 2)))
  {
    (void) fprintf(stderr, "lvctor for %s Failed\n", Sraw2viff->o3_file);
    exit(1);
  }
}

/* write out complex file if it was specified */
if (Sraw2viff->o1_flag)
{
  writeimage(Sraw2viff->o1_file,img1);
}

/* write out real file if it was specified */
if (Sraw2viff->o2_flag)
{
  writeimage(Sraw2viff->o2_file,img2);
}

/* write out imaginary file if it was specified */
if (Sraw2viff->o3_flag)
{
  writeimage(Sraw2viff->o3_file,img3);
}

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for Sraw2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "Sraw2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts GE Signa Magnet raw (time domain)  images  to  VIFF\n");
	fprintf(stderr, "\tformat files (complex, real and/or imaginary).\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"-o1\" creates complex output data file\n");
(void) fprintf(stderr,"      \"-o2\" creates real output data file\n");
(void) fprintf(stderr,"      \"-o3\" creates imaginary output data file\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input signa raw image file  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  complex output file (VIFF) (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  real part output filename (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  imaginary part output filename (outfile) [null]\n");
	fprintf(stderr,"\t[-r]  number of rows (integer, >= 0) [128]\n");
	fprintf(stderr,"\t[-c]  number of columns (integer, >= 0) [256]\n");
	fprintf(stderr,"\t[-h]  byte offset from the start of the input data file (integer, >= 0) [14336]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for Sraw2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for Sraw2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called Sraw2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses Sraw2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for Sraw2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input signa raw image file \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) complex output file (VIFF) \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) real part output filename \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) imaginary part output filename \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, >= 0 [128] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, >= 0 [256] }: "; 
char	*h_pstr = 
	"\nEnter: (h) byte offset from the start of the input data file \n        {integer, >= 0 [14336] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "Sraw2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "Sraw2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "Sraw2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "Sraw2viff.ans");
		}

	     }

	}

	/*
	 * allocate the Sraw2viff structure
	 */
	Sraw2viff = (Sraw2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (Sraw2viff_struct));

	/*
	 * get required arguments for Sraw2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(Sraw2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(Sraw2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(Sraw2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    Sraw2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(Sraw2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for Sraw2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	Sraw2viff->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(Sraw2viff->o1_file))
;

	Sraw2viff->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(Sraw2viff->o2_file))
;

	Sraw2viff->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(Sraw2viff->o3_file))
;

	Sraw2viff->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(Sraw2viff->r_int),
	128, 1, 1);

	Sraw2viff->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(Sraw2viff->c_int),
	256, 1, 1);

	Sraw2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(Sraw2viff->h_int),
	14336, 1, 1);


}



