/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vuclass.h
 >>>>            Author: Shirley Lee
 >>>> Date Last Updated: Mon Apr 15 22:17:49 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vuclass_h_
#define _vuclass_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vuclass Argument Structure
*
****************************************************************/

typedef struct _vuclass  {

/*
 *  first input image (Required infile)
 */
char	*i1_file;	/* first input image FILENAME */
int	 i1_flag;	/* first input image FLAG */

/*
 *  second input image (Required infile)
 */
char	*i2_file;	/* second input image FILENAME */
int	 i2_flag;	/* second input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

}  vuclass_struct;

vuclass_struct *vuclass;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE);   \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        if (!propertype(program,img1,VFF_TYP_1_BYTE,TRUE)) \
        { \
            (void) fprintf(stderr, "Image 1 data type can only be \
VFF_TYP_1_BYTE\n"); \
            exit(1); \
        } \
        \
/* -include_macros_end */

#endif
