/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: veplane.c
 >>>>
 >>>>      Program Name: veplane
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Project interferomter data taken normal to tilted flat  back
 >>>>	to entrance plane
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:19:31 1991
 >>>>
 >>>>          Routines: main- the main program for veplane
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "veplane.h"


/****************************************************************
 *
 * Routine Name:  main program for veplane
 *
 *       Input:  
 *         -i  input image 
 *         -o  output image 
 *         -xa  Angle of plane with respect to X axis  
 *         -ya  Angle of plane with respect to Y axis  
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img, *out;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img = readimage(veplane->i_file);
        if (img == NULL) exit(1);                    

        proper_num_images(program,img,1,1);
        proper_loc_type(program,img,VFF_LOC_IMPLICIT,1);
        proper_num_bands(program,img,1,1);
        if (img->data_storage_type != VFF_TYP_FLOAT)
          {
            lvconvert(img,VFF_TYP_FLOAT,0,1,0.0,1.0,0);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lveplane(img,veplane->xa_float,veplane->ya_float,&out) )
        {
            (void) fprintf(stderr, "lveplane Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(veplane->o_file,out);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for veplane 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "veplane :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tProject interferomter data taken normal to tilted flat  back\n");
	fprintf(stderr, "\tto entrance plane\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-xa  Angle of plane with respect to X axis  (float)\n");
	fprintf(stderr,"\t-ya  Angle of plane with respect to Y axis  (float)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for veplane\n");
	fprintf(stderr, "\t[-U] Gives the usage for veplane\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called veplane.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses veplane.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for veplane
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*xa_pstr = 
	"\nEnter: (xa) Angle of plane with respect to X axis \n        {float}: "; 
char	*ya_pstr = 
	"\nEnter: (ya) Angle of plane with respect to Y axis \n        {float}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "veplane", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "veplane.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "veplane: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "veplane.ans");
		}

	     }

	}

	/*
	 * allocate the veplane structure
	 */
	veplane = (veplane_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (veplane_struct));

	/*
	 * get required arguments for veplane
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(veplane->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(veplane->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(veplane->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    veplane->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(veplane->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(veplane->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(veplane->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(veplane->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    veplane->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(veplane->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(veplane->xa_flag = vget_float(fid, prompt_flag,
			"-xa", xa_pstr, &(veplane->xa_float),
			0.000000, 0.000000, 0.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(veplane->xa_flag))
		{
		    fprintf(stderr, "\t\txa is required, please re-enter: \n");
		    veplane->xa_flag = vget_float(fid, prompt_flag,
		    "-xa", xa_pstr, &(veplane->xa_float),
		    0.000000, 0.000000, 0.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-xa' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(veplane->ya_flag = vget_float(fid, prompt_flag,
			"-ya", ya_pstr, &(veplane->ya_float),
			0.000000, 0.000000, 0.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(veplane->ya_flag))
		{
		    fprintf(stderr, "\t\tya is required, please re-enter: \n");
		    veplane->ya_flag = vget_float(fid, prompt_flag,
		    "-ya", ya_pstr, &(veplane->ya_float),
		    0.000000, 0.000000, 0.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-ya' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



