/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvredim.c
 >>>>
 >>>>      Program Name: vredim
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:18:22 1991 
 >>>>
 >>>>          Routines: lvredim - the library call for vredim
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvredim - library call for vredim
*
* Purpose:
*    
*    Re-dimension the data part of an image
*    
*    
* Input:
*    
*    image          Pointer to image to be modified.
*    
*    r              Number of rows for the new image.
*    
*    c              Number of columns for the new image.
*    
*    b              Number of bands for the new image.
*    
*    
* Output:
*    
*    image          Points to the modified image
*    
*    
*
* Written By: Scott Wilson
****************************************************************/


/* -library_def */
int
lvredim(image,r,c,b)
struct xvimage *image;
int r,c,b;
/* -library_def_end */

/* -library_code */
  {
    int rows,cols,bands;

    cols = image->row_size;
    rows = image->col_size;
    bands = image->num_data_bands;

    if (r*c*b != rows*cols*bands)
      {
        fprintf(stderr,"lvredim: Image pixel count does not match supplied parameters!\n");
        fprintf(stderr,"lvredim: Image not modified.\n");
        return(0);
      }

    image->row_size = c;
    image->col_size = r;
    image->num_data_bands = b;
    return(1);
  }
/* -library_code_end */
