/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvfill.c
 >>>>
 >>>>      Program Name: vfill
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:13:50 1991 
 >>>>
 >>>>          Routines: lvfill - the library call for vfill
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvfill - library call for vfill
*
* Purpose:
*    
*    Extract information from an ultrasonic image.
*    
*    
* Input:
*    
*         img -- xvimage structure
*    
*    
* Output:
*    
*         img -- holds the result of the boundary filled
*                image
*    
*         lvfill returns 1 on success and 0 on failure.
*    
*    
*
* Written By: Shirley Lee
*    
*    
****************************************************************/


/* -library_def */
int
lvfill(img)
struct xvimage *img;
/* -library_def_end */

/* -library_code */
{

    int row,                            /* points image row */ 
        col,                            /* points image col */ 
        nc,                             /* column size of image */
        nr,                             /* row size of image */
        num, i, j,                      /* general purpose counters */
        mark1, prev_mark1[3],           /* mark the ending pt. of the flood */
        mark2, prev_mark2[3],           /* mark the ending pt. of the flood */
        copy1, copy2,                   /* boolean var */
        chance1,chance2;                /* second chance of flooding */

    unsigned int tmp;                   /* tmp variable storing grey level */

    unsigned char *ptr,                 /* pointer to the image data char */
                  *result;              /* pointer to resulting image char */

    char  *program;                     /* contains the library name */

    program = "lvfill";

    /* check for propertype of image */
    propertype(program,img,VFF_TYP_1_BYTE,1);      /* check img. type */        

    nr = img->col_size;
    nc = img->row_size;

   /* Allocate space for resulting image */ 
    result = (unsigned char *)malloc((unsigned int)nc*nr*sizeof(unsigned char));
    if(result == NULL) {
        (void) fprintf(stderr,"lvfill: insufficient memory available\n");
        return(0);
    }

   /* Assign image data address to ptr */
    ptr = (unsigned char *)img->imagedata;

   /* initialize resulting image to black */
   for (row=0; row<nr; row++){
     for (col=50; col<nc; col++){
        result[nc*row+col]=0;
     }
   }

   mark1 = 0;
   mark2 = 0;
   prev_mark1[0] = prev_mark1[1] = prev_mark1[2] = 0;
   prev_mark2[0] = prev_mark2[1] = prev_mark2[2] = 0;
   for (row=0; row<nr; row++){
     copy1=0;
     copy2=0;
     /*
     chance1=0;
     */
     chance2=0;

     /* flood white band on the left */
     for (col=0; col<50; col++) result[nc*row+col]=255;

     for (col=50; col<(nc/2+1); col++){
        if (copy1){
                result[nc*row+col]=ptr[nc*row+col];
                continue;
        }
        tmp=ptr[nc*row+col];
        if ((tmp<20) || (tmp>250)){
                result[nc*row+col]=255;
                mark1 = col;
        }
        /*
        else if (chance1<3){
                for(num=0;num<5;num++)
                        result[nc*row+(col+num)]=255;
                chance1++;
                col+=4;
        }
        */
        else if (result[nc*row+col]!=255){
                result[nc*row+col]=tmp;
                copy1=1;
        }

     }

     if ((mark1<100)&&(prev_mark1[0]<nc/2+1)&&(row>180)){
        mark1 = (int)((prev_mark1[0]+prev_mark1[1])/2) + 1;
        for (i=(row-1); i<nr; i++)
                for (j=50; j<mark1; j++)
                        result[nc*i+j]=255;
     }
     prev_mark1[0] = prev_mark1[1]; 
     prev_mark1[1] = prev_mark1[2];
     prev_mark1[2] = mark1;

     /* flood white band on the right */
     for (col=nc; col>590; col--) result[nc*row+col]=255;

     for (col=590; col>nc/2; col--){
        if (copy2){
                result[nc*row+col]=ptr[nc*row+col];
                continue;
        }
        tmp=ptr[nc*row+col];
        if ((tmp<20) || (tmp>250)){
                result[nc*row+col]=255;
                mark2 = col;
        }
        else if (chance2<3){
                for(num=0;num<5;num++)
                        result[nc*row+(col-num)]=255;
                chance2++;
                col-=4;
                mark2 = col;
        }
        else if (result[nc*row+col]!=255){
                result[nc*row+col]=tmp;
                copy2=1;
        }
     }

     if ((mark2>540)&&(prev_mark2[0]>nc/2)&&(row>240)){
        mark2 = (int)((prev_mark2[0]+prev_mark2[1])/2) + 1;
        for (i=(row-1); i<nr; i++)
                for (j=590; j>mark2; j--)
                        result[nc*i+j]=255;
     }
     prev_mark2[0] = prev_mark2[1]; 
     prev_mark2[1] = prev_mark2[2];
     prev_mark2[2] = mark2;

   }

/*
   for (row=nr; row>(nr-50); row--)
     for (col=50; col<nc; col++)
        result[nc*row+col]=255;
*/

   free (img->imagedata);
   img->imagedata = (char *) result;

   return(1);
}
/* -library_code_end */
