/* $Id: mf.h,v 1.7 89/09/20 17:49:21 mbp Exp $
 *
 * mf.h: header file for metafile procedures
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* MetaFile Address type: */
typedef		short unsigned int	mfa;
#define		MAX_MFA_VAL	((mfe)65535)

/* MetaFile Entry type: */ 
typedef		short unsigned int	mfe;
#define		MAX_MFE_VAL	((mfe)65535)

/* Address for "no" segment: */
#define		NULL_SEG_ADDRESS ((mfa)0)

/* Global variables: */
extern char	*mf_error;
extern mfe	mf_metafile[];
extern mfe	MF_max_val;
extern mfe	MF_begin_segment;
extern mfe	MF_end_segment;
extern mfe	MF_pen_up;
extern mfe	MF_pen_down;
extern mfe	MF_point;
extern mfe	MF_line_style;
extern mfe	MF_color;
extern mfe	MF_max_command;

/* Functions: */
extern mfa	mf_first_addr();
extern mfa	mf_last_addr();
extern mfa	mf_length();

/* The following functions are implemented as macros for speed: */

/*-----------------------------------------------------------------------
 * Macro:       mf_peek
 * Description: Get an entry in MF
 * Args IN:	address: address of entry to return
 * Returns:     The entry stored at address
 * Notes:	This is implemented as a macro for speed
 */
#define mf_peek(n) mf_metafile[n]

/*-----------------------------------------------------------------------
 * Macro:        mf_is_command
 * Description:  Tell whether an MF entry is a command or not
 * Arguments IN: entry: the entry (value) to test
 * Returns:      YES if entry is a command, NO if not
 */
#define mf_is_command(e) ((e>MF_max_val)&&(e<=MF_max_command))
