/* $Id: internal.h,v 1.7 89/09/20 17:49:10 mbp Exp $
 *
 * internal.h: public things which are internal to LGD
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* Maximum dimension allowed (right now only dim allowed is 3): */
#define		MAXDIM		3

/* Offsets of information in segment headers: */
#define		NAME_OS		1	/* name offset		*/
#define		VIS_OS		2	/* visibilty offset	*/
#define		LEN_OS		3	/* length offset	*/

/* External variables; see lgd.c for descriptions */
extern int	lgd_dim;
extern int	lgd_header_length;
extern int	lgd_trailer_length;
extern int	lgd_world_file_fmt;
extern double	lgd_wbox[2][MAXDIM];
extern double	lgd_wscale[MAXDIM];
extern double	lgd_pick_tolerance;

/* Error strings: */
#define E_out_of_world	"Attempt to move/draw out of world box"
#define E_pu_noseg	"Attempt to lift pen outside of segment"
#define E_pd_noseg 	"Attempt to lower pen outside of segment"
#define E_md_noseg	"Attempt to move/draw outside of segment"
#define E_pt_noseg	"Attempt to draw a point outside of segment"
#define E_cs_noseg	\
	"Attempt to close segment when no segment is open"
#define E_del_non_seg	"Attempt to delete nonexistent segment"
#define E_del_open_seg	"Attempt to delete a currently open segment"
#define E_mf_overflow	"Metafile overflow"
#define E_bad_trunc	"Unsuccessful attempt to truncate metafile"
#define E_bad_compress	"Unsuccessful attempt to compress metafile"
#define E_bad_mf_entry	"Bad entry in metafile"
#define E_bad_dim	"Bad dimension passed to lgd_define_world"
#define E_seg_too_long	"Segment too long: length won't fit in header"
#define E_sw_bad_fname	"Bad file name when attempting to save world"
#define E_sm_bad_write	"Write error while saving metafile"
#define E_lw_bad_fname	"Bad file name when attempting to load world"
#define E_sw_bad_write	"Write error when saving world"
#define E_swd_bad_write	"Write error when saving world definition data"
#define E_swd_bad_read	"Read error when loading world definition data"
#define E_lw_bad_read	"Read error when loading world"
#define E_lw_fmt_clash	"World file format clash"
#define E_svd_bad_write	"Write error when saving world viewing data"
#define E_svd_bad_read	"Read error when loading world viewing data"
#define E_bad_wld_bdy	\
	"Bad world boundary values passed to lgd_define_world"
#define E_visi_noseg    \
	"Attempt to change visibility of nonexistent segment"
#define E_seg_open	\
	"Attempt to open a segment while a segment is open"
#define E_max_segs	"Maximum number of allowed segments exceeded"
#define E_inq_noseg_visi \
	 "Attempt to inquire about visibility of nonexistent segment"
