/* $Id: images.h,v 2.3 89/09/20 17:01:42 mbp Exp $
 *
 * images.h: header file to include all the image files
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include "image_info.h"

/* Images used in both 2D and 3D versions: */

static short lmouse_array[] = {
#include "images/lmouse.image"
};
mpr_static(lmouse_pr, LMOUSE_W, LMOUSE_H, 1, lmouse_array);

static short rmouse_array[] = {
#include "images/rmouse.image"
};
mpr_static(rmouse_pr, RMOUSE_W, RMOUSE_H, 1, rmouse_array);

static short mmouse_array[] = {
#include "images/mmouse.image"
};
mpr_static(mmouse_pr, MMOUSE_W, MMOUSE_H, 1, mmouse_array);

static short rsmouse_array[] = {
#include "images/rsmouse.image"
};
mpr_static(rsmouse_pr, RSMOUSE_W, RSMOUSE_H, 1, rsmouse_array);

static short lsmouse_array[] = {
#include "images/lsmouse.image"
};
mpr_static(lsmouse_pr, LSMOUSE_W, LSMOUSE_H, 1, lsmouse_array);

static short msmouse_array[] = {
#include "images/msmouse.image"
};
mpr_static(msmouse_pr, MSMOUSE_W, MSMOUSE_H, 1, msmouse_array);

static short esc_array[] = {
#include "images/esc.image"
};
mpr_static(esc_pr, ESC_W, ESC_H, 1, esc_array);

static short print_array[] = {
#include "images/print.image"
};
mpr_static(print_pr, VCB_W, VCB_H, 1, print_array);

static short help_array[] = {
#include "images/help.image"
};
mpr_static(help_pr, VCB_W, VCB_H, 1, help_array);

static short quit_array[] = {
#include "images/quit.image"
};
mpr_static(quit_pr, VCB_W, VCB_H, 1, quit_array);

/* End of images needed by both 2D and 3D versions */


/* Images needed by just 3D version: */

#ifdef THREE_D

static short vertical_sweep_array[] = {
#include "images/vertical_sweep.image"
};
mpr_static(vertical_sweep_pr, VCB_W, VCB_H, 1,
 	   vertical_sweep_array);

static short horizontal_sweep_array[] = {
#include "images/horizontal_sweep.image"
};
mpr_static(horizontal_sweep_pr, VCB_W, VCB_H, 1,
	   horizontal_sweep_array);

static short tilt_array[] = {
#include "images/tilt.image"
};
mpr_static(tilt_pr, VCB_W, VCB_H, 1, tilt_array);

static short vertical_pan_array[] = {
#include "images/vertical_pan.image"
};
mpr_static(vertical_pan_pr, VCB_W, VCB_H, 1,
	   vertical_pan_array);

static short horizontal_pan_array[] = {
#include "images/horizontal_pan.image"
};
mpr_static(horizontal_pan_pr, VCB_W, VCB_H, 1,
	   horizontal_pan_array);

static short zoom_array[] = {
#include "images/zoom.image"
};
mpr_static(zoom_pr, VCB_W, VCB_H, 1, zoom_array);

static short perspective_array[] = {
#include "images/perspective.image"
};
mpr_static(perspective_pr, VCB_W, VCB_H, 1, perspective_array);

static short reset_array[] = {
#include "images/reset.image"
};
mpr_static(reset_pr, VCB_W, VCB_H, 1, reset_array);

static short anim_array[] = {
#include "images/anim.image"
};
mpr_static(anim_pr, VCB_W, VCB_H, 1, anim_array);

static short redraw_array[] = {
#include "images/redraw.image"
};
mpr_static(redraw_pr, VCB_W, VCB_H, 1, redraw_array);

static short view_data_array[] = {
#include "images/view_data.image"
};
mpr_static(view_data_pr, VCB_W, VCB_H, 1, view_data_array);

#endif /* End of 3D version images */
