/*
 * $Id: grdemo.tpl,v 2.3 89/09/20 17:39:01 mbp Exp $
 *
 * grdemo.c: sample GR program
 *
 * BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
 *
 * This is a "template" for the demo program grdemo.c.  Before
 * installing and/or compiling this program, this file should be
 * edited to change the following strings to whatever is appropriate:
 *
 * INCLDIR_VALUE:
 *     pathname of directory containing installed copy of gr.h
 *
 * LIBDIR_VALUE:
 *     pathname of directory containing installed library files
 *       (libgr.a, libgr3d.a)
 *
 * LIBFLAG_VALUE:
 *     this should be -LLIBDIR_VALUE if LIBDIR_VALUE is
 *       not on the path of directories normally searched by ld(1).
 *       If LIBDIR_VALUE *is* on the search path for ld(1), then
 *       LIBFLAG_VALUE should be the empty string.
 *
 * FOPTION_VALUE
 *     The floating point option for the cc command to compile this
 *       program.  This should be the same as the one used in building
 *       the GR library.
 *
 * This can be done with a sed command, which is normally done by the
 * gr makefile during installation, or by the explicit command
 * 'make grdemo.c'.
 *
 * EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
 * To compile:
 *   cc FOPTION_VALUE -o grdemo grdemo.c LIBFLAG_VALUE \
 *      -lgr -lm -lsuntool -lsunwindow -lpixrect
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* All GR programs should include gr.h:	*/
#include "INCLDIR_VALUE/gr.h"

#include <math.h>
#include <stdio.h>

#define YES 1
#define NO 0

/* Declaration of menu option procedures: */
int draw_line_proc(), erase_proc(), draw_arc_proc(), draw_point_proc(),
    coord_sys_proc(), menu2_proc(), opt1_proc(), opt2_proc(),
    menu1_proc();

/* The main menu: */
gr_Opt_pair my_menu1_list[] = {
  "Line",		draw_line_proc,
  "Arc",		draw_arc_proc,
  "Point",		draw_point_proc,
  "Coord Sys",		coord_sys_proc,
  "Erase",		erase_proc,
  "2nd menu",		menu2_proc
  };	
gr_Menu my_menu1 = {
  "MAIN MENU",
  sizeof(my_menu1_list)/sizeof(gr_Opt_pair),
  my_menu1_list
  };

/* A second menu ( for demonstrating how to change menus ) */
gr_Opt_pair my_menu2_list[] = {
  "First option", 	opt1_proc,
  "Second option",	opt2_proc,
  "return to main menu",	menu1_proc
  };	
gr_Menu my_menu2 = {
  "SECOND MENU",
  sizeof(my_menu2_list)/sizeof(gr_Opt_pair),
  my_menu2_list
  };

main(argc, argv)
     int argc;
     char **argv;
{
  gr_initialize(argc, argv);
  gr_set_menu(&my_menu1);
  gr_message("This is GRDEMO. Use the right mouse button with the cursor \
over the canvas below to access the menu.",1);

  gr_main_loop();
}

draw_line_proc()
{
  double x1,y1,x2,y2;
  char message[GR_MESSAGE_LENGTH+1];
  int quit;
  
  gr_message_clear();
  gr_message("Enter first point", 1);
  get_point(&x1,&y1,&quit);
  if (quit) goto abort;
  gr_move(x1,y1);
  gr_message("Enter second point", 1);
  get_point(&x2,&y2,&quit);
  if (quit) goto abort;
  gr_draw(x2,y2);
  sprintf(message,"Line: (%7.3f,%7.3f) to (%7.3f,%7.3f)\n",
	  x1,y1, x2,y2 );
  gr_message(message,1);
  return;
 abort:
  gr_message("ABORTED",1);
}

draw_point_proc()
{
  double x,y;
  int quit;
  char message[GR_MESSAGE_LENGTH+1];
  
  gr_message("Enter point to plot.",1);
  get_point(&x,&y,&quit);
  if (quit) goto abort;
  gr_move(x,y);
  gr_point();
  sprintf(message,"Point (%f,%f) plotted", x,y);
  gr_message(message,1);
  return;
 abort:
  gr_message("ABORTED",1);
}

coord_sys_proc()
{
  double x1,y1,x2,y2;
  double atof();
  char message[GR_MESSAGE_LENGTH];
  
  gr_message_clear();
  gr_message("Enter coord sys x1", 1);
  gr_get_string(message); x1 = atof(message);
  gr_message("Enter coord sys y1", 1);
  gr_get_string(message); y1 = atof(message);
  gr_message("Enter coord sys x2", 1);
  gr_get_string(message); x2 = atof(message);
  gr_message("Enter coord sys y2", 1);
  gr_get_string(message); y2 = atof(message);
  gr_coordinate_system( x1,y1, x2,y2 );
  sprintf(message,"New coord system has lower left corner = (%f,%f)", x1,y1);
  gr_message(message,1);
  sprintf(message,"                    upper right corner = (%f,%f)", x2,y2);
  gr_message(message,2);
}

erase_proc()
{
  gr_message_clear();
  gr_erase();
  gr_message("Canvas erased",1);
}

draw_arc_proc()
{
  double xc,yc, x1,y1, x2,y2;
  int quit;
  char message[GR_MESSAGE_LENGTH+1];
  
  gr_message_clear();
  gr_message("Enter center of arc", 1);
  get_point(&xc,&yc,&quit);
  if (quit) goto abort;
  gr_message("Enter first point on arc.",1);
  get_point(&x1,&y1,&quit);
  if (quit) goto abort;
  gr_message("Enter second point (determines end of arc)",1);
  get_point(&x2,&y2,&quit);
  if (quit) goto abort;
  gr_arc( xc,yc, x1,y1, x2,y2 );
  sprintf(message,"arc: (%7.3f,%7.3f),  (%7.3f,%7.3f),  (%7.3f,%7.3f)",
	  xc,yc, x1,y1, x2,y2 );
  return;
 abort:
  gr_message("ABORTED",1);
  gr_message(message,1);
}

menu2_proc()
{
  gr_message_clear();
  gr_message("You have changed to the second menu.",1);
  gr_message("This menu does nothing other than illustrate how to \
change menus", 1);
  gr_set_menu(&my_menu2);
}

opt1_proc()
{
  gr_message_clear();
  gr_message("You picked option 1",1);
}

opt2_proc()
{
  gr_message_clear();
  gr_message("You picked option 2",1);
}

menu1_proc()
{
  gr_message_clear();
  gr_message("You have returned to the main menu",1);
  gr_set_menu(&my_menu1);
}

get_point(x,y,quit)
     double *x,*y;
     int *quit;
     /*
      * Get an (x,y) point from the user via gr_get_xy(). If the user
      * hit the ESC key, set *quit=YES; otherwise set *quit=NO.
      */
{
  gr_Button button;
  
  /* We allow any of the 3 buttons to be pressed, but not
   * the "shifted" versions */
  gr_button_message("pick point", "pick point", "pick point", "","","",
	     "abort" );
  gr_get_xy(x,y,&button, GR_LEFT|GR_MIDDLE|GR_RIGHT|GR_ESC);
  gr_button_message_clear();
  *quit = (button==GR_ESC);
}
