/*ScianObjWindows.c
  Object window stuff
  Eric Pepke
  March 28, 1990
*/
#include "Scian.h"
#include "ScianTypes.h"
#include "ScianLists.h"
#include "ScianWindows.h"
#include "ScianColors.h"
#include "ScianIDs.h"
#include "ScianObjWindows.h"
#include "ScianErrors.h"
#include "ScianDraw.h"
#include "ScianControls.h"
#include "ScianSpaces.h"
#include "ScianArrays.h"
#include "ScianScripts.h"
#include "ScianVisWindows.h"
#include "ScianIcons.h"
#include "ScianEvents.h"
#include "ScianStyle.h"
#include "ScianHelp.h"
#include "ScianObjFunctions.h"
#include "ScianLights.h"

#ifdef PROTO
void ReshapeList(ThingListPtr, int, int, int, int, int, int, int, int);
#else
void ReshapeList();
#endif

int pauseDrawing = 0;
char tempStr[TEMPSTRSIZE + 1];
ObjPtr objWindowClass;			/*Object window class*/
ObjPtr dragBuffer = NULLOBJ;		/*Objects held*/
Bool showWindows = true;		/*Show new opened windows*/

ObjPtr NewControlWindow(object)
ObjPtr object;
/*Opens a new control window for object*/
{
    FuncTyp newCtlWindow;
    ObjPtr retVal;
    ObjPtr repObj, name, repName = NULLOBJ;
    char windowName[255];

    if (IsIcon(object))
    {
	/*It's an icon, use its REPOBJ.  Do nothing if it has none.*/
	object = GetVar(object, REPOBJ);
	if (!object)
	{
	    return ObjFalse;
	}
    }

    strcpy(windowName, "");

    /*See if the object has a repObj*/
    MakeVar(object, REPOBJ);
    repObj = GetVar(object, REPOBJ);
    if (repObj)
    {
	MakeVar(repObj, NAME);
	if (repName = GetVar(repObj, NAME));
	{
	    strncpy(windowName, GetString(repName), 255);
	    windowName[255] = 0;
	}
    }
    else
    {
	/*See if the object has a main dataset*/
	MakeVar(object, MAINDATASET);
	repObj = GetVar(object, MAINDATASET);
	if (repObj)
	{
	    MakeVar(repObj, NAME);
	    if (repName = GetVar(repObj, NAME))
	    {
		strncpy(windowName, GetString(repName), 255);
		windowName[255] = 0;
	    }
	}
    }

    MakeVar(object, NAME);
    name = GetVar(object, NAME);
    if (name)
    {
	if (repName)
	{
	    strcat(windowName, " ");
	}
	strcat(windowName, GetString(name));
    }

    if (GetPredicate(object, TEMPLATEP))
    {
	strcat(windowName, " Template");
    }

    newCtlWindow = GetMethod(object, NEWCTLWINDOW);
    if (newCtlWindow)
    {
	PauseDrawing(true);
	showWindows = showControlPanels;
	retVal = (*newCtlWindow)(object, windowName);
	showWindows = true;
	PauseDrawing(false);
    }
    else
    {
	retVal = NULLOBJ;
    }
    return retVal;
}

void SetEndpoints(object, x1, y1, x2, y2)
ObjPtr object;
int x1, y1, x2, y2;
/*Sets the endpoints of an object*/
{
    int l, r, b, t;
    ObjPtr var;
    real loc[2];

    l = MIN(x1, x2) - HANDLESIZE / 2;
    r = MAX(x1, x2) + HANDLESIZE / 2;
    b = MIN(y1, y2) - HANDLESIZE / 2;
    t = MAX(y1, y2) + HANDLESIZE / 2;
    Set2DIntBounds(object, l, r, b, t);

    var = NewRealArray(1, 2L);
    loc[0] = x1;
    loc[1] = y1;
    CArray2Array(var, loc);
    SetVar(object, STARTPOINT, var);

    var = NewRealArray(1, 2L);
    loc[0] = x2;
    loc[1] = y2;
    CArray2Array(var, loc);
    SetVar(object, ENDPOINT, var);
}

Bool Get2DIntBounds(object, l, r, b, t)
ObjPtr object;
int *l, *r, *b, *t;
/*Gets the 2D integer bounds of a screen object*/
{
    ObjPtr boundsArray;
    boundsArray = GetFixedArrayVar("Get2DIntBounds", object, BOUNDS, 1, 4L);
    if (boundsArray)
    {
	real temp[4];
	Array2CArray(temp, boundsArray);
	*l = temp[0];
	*r = temp[1];
	*b = temp[2];
	*t = temp[3];
	return true;
    }
    else
    {
	return false;
    }
}

Bool Set2DIntBounds(object, l, r, b, t)
ObjPtr object;
int l, r, b, t;
/*Sets the 2D integer bounds of a screen object to l, r, b, t*/
{
    ObjPtr boundsArray;
    boundsArray = NewRealArray(1, 4L);
    if (boundsArray)
    {
	real temp[4];
	temp[0] = l;
	temp[1] = r;
	temp[2] = b;
	temp[3] = t;
	CArray2Array(boundsArray, temp);
	SetVar(object, BOUNDS, boundsArray);
	return true;
    }
    else
    {
	return false;
    }
}

void ForAllObjects(obj, routine)
ObjPtr obj;
FuncTyp routine;
/*Performs routine on all selected objects in win*/
{
    ObjPtr contents;
    FuncTyp method;

    method = GetMethod(obj, FORALLOBJECTS);
    if (method)
    {
	(*method)(obj, routine);
    }
}

static ObjPtr CloseObjWindow(theInfo)
WinInfoPtr theInfo;
/*Closes obj window theInfo*/
{  
    if (theInfo -> mainMenu)
    {
	DeleteMenus(theInfo);
    }
    theInfo -> mainMenu = 0;
    return ObjTrue;
}

static ObjPtr DrawObjWindow(theInfo)
WinInfoPtr theInfo;
/*Draws the obj window theInfo*/
{
#ifdef GRAPHICS
    ObjPtr contents;

    InitClipRect();

    /*Draw the objects within the window*/
    contents = GetVar((ObjPtr) theInfo, CONTENTS);
    if (contents)
    {
	if (IsList(contents))
	{
	    DrawList(contents);
	}
    }

    ResetClipRect();
#endif
    return ObjTrue;
}

Bool NeedsSBDrawing(object)
ObjPtr object;
/*Returns true iff an object needs to be drawn in single buffer mode*/
{
    ObjPtr picVar;

    /*See if this object itself needs to be drawn*/
    picVar = GetVar(object, PICSTATE);
    if (picVar)
    {
	int picState;
	picState = GetInt(picVar);

	/*See if this object needs to be drawn*/
	return picState & FG ? false : true;
    }
    return false;
}


Bool NeedsDBDrawing(object)
ObjPtr object;
/*Returns true iff an object needs to be drawn in double buffer mode*/
{
    ObjPtr picVar;
    
    /*See if this object itself needs to be drawn*/
    picVar = GetVar(object, PICSTATE);
    if (picVar)
    {
	int picState;
	picState = GetInt(picVar);

	/*See if this object needs to be drawn*/
	return picState & BG ? false : true;
    }
    return false;
}

ObjPtr MakeObjWindowDrawn(curWindow)
WinInfoPtr curWindow;
/*Method to make an obj window drawn.  Returns true iff drawing done*/
{
    ObjPtr retVal = ObjFalse;
    int picState;
    ObjPtr picVar;

    picVar = GetVar((ObjPtr) curWindow, PICSTATE);
    if (picVar)
    {
	picState = GetInt(picVar);
    }
    else
    {
	picState = FBBB;
    }    

    if (hasDouble && (curWindow -> flags & WINDBUF))
    {
	/*Double buffer*/
	if (!(picState & BG))
	{
	    /*Back buffer is bad, have to redraw it*/
	    SetVar((ObjPtr) curWindow, PICSTATE, 
		   NewInt(picState & FG ? FGBG : FGBB));
	    SelWindow(curWindow);	/*MUST DO!*/
	    DrawWindowInfo(curWindow);
	    retVal = ObjTrue;
	}
	else
	{
	    /*There's still a chance that a subobject needs drawing*/
	    Bool drawAnything;
	    ObjPtr contents;

	    drawAnything = false;
	    
	    contents = GetVar((ObjPtr) curWindow, CONTENTS);
	    if (contents && IsList(contents))
	    {
		ThingListPtr runner;
		runner = LISTOF(contents);

		/*Check all contents for need to draw*/
		while (runner)
		{
		    ObjPtr drawCover;
		    if (NeedsDBDrawing(runner -> thing))
		    {
			drawAnything = true;
			SetVar(runner -> thing, DRAWME, NewInt(1));
			drawCover = runner -> thing;
			/*Draw its covers*/
			while(drawCover = GetVar(drawCover, DRAWCOVER))
			{
			    SetVar(drawCover, DRAWME, NewInt(1));
			}
		    }
		    drawCover = GetVar(runner -> thing, DRAWCOVER);
		    if (drawCover)
		    {
			if (NeedsDBDrawing(drawCover))
			{
			    drawAnything = true;
			    SetVar(runner -> thing, DRAWME, NewInt(1));
			}
		    }
		    runner = runner -> next;
		}
		if (drawAnything)
		{
		    /*Set everything that's not DRAWME to INHIBITDRAWING*/
		    runner = LISTOF(contents);
		    while (runner)
		    {
			if (GetPredicate(runner -> thing, DRAWME))
			{
			    SetVar(runner -> thing, DRAWME, NULLOBJ);
			}
			else
			{
			    SetVar(runner -> thing, INHIBITDRAWING, NewInt(1));
			}
			runner = runner -> next;
		    }

		    /*Draw what's not inhibited*/
		    SelWindow(curWindow);
		    DrawWindowInfo(curWindow);

		    /*Uninhibit drawing*/
		    runner = LISTOF(contents);
		    while (runner)
		    {
			SetVar(runner -> thing, INHIBITDRAWING, NULLOBJ);
			runner = runner -> next;
		    }
		    retVal = ObjTrue;
		}
	    }
	}
    }
    else
    {
	/*Single buffer*/
	if (!(picState & FG))
	{
	    SetVar((ObjPtr) curWindow, PICSTATE, NewInt(FGBG));
	    SelWindow(curWindow);
	    DrawWindowInfo(curWindow);
	    retVal = ObjTrue;
	}
	else
	{
	    /*There's still a chance that a subobject needs drawing*/
	    Bool drawAnything;
	    ObjPtr contents;

	    drawAnything = false;
	    
	    contents = GetVar((ObjPtr) curWindow, CONTENTS);
	    if (contents && IsList(contents))
	    {
		ThingListPtr runner;
		runner = LISTOF(contents);

		/*Check all contents for need to draw*/
		while (runner)
		{
		    ObjPtr drawCover;
		    if (NeedsDBDrawing(runner -> thing))
		    {
			drawAnything = true;
			SetVar(runner -> thing, DRAWME, NewInt(1));
			drawCover = runner -> thing;
			/*Draw its covers*/
			while(drawCover = GetVar(drawCover, DRAWCOVER))
			{
			    SetVar(drawCover, DRAWME, NewInt(1));
			}
		    }
		    drawCover = GetVar(runner -> thing, DRAWCOVER);
		    if (drawCover)
		    {
			if (NeedsDBDrawing(drawCover))
			{
			    drawAnything = true;
			    SetVar(runner -> thing, DRAWME, NewInt(1));
			}
		    }
		    runner = runner -> next;
		}
		if (drawAnything)
		{
		    /*Set everything that's not DRAWME to INHIBITDRAWING*/
		    runner = LISTOF(contents);
		    while (runner)
		    {
			if (GetPredicate(runner -> thing, DRAWME))
			{
			    SetVar(runner -> thing, DRAWME, NULLOBJ);
			}
			else
			{
			    SetVar(runner -> thing, INHIBITDRAWING, NewInt(1));
			}
			runner = runner -> next;
		    }

		    /*Draw what's not inhibited*/
		    SelWindow(curWindow);
		    DrawWindowInfo(curWindow);

		    /*Uninhibit drawing*/
		    runner = LISTOF(contents);
		    while (runner)
		    {
			SetVar(runner -> thing, INHIBITDRAWING, NULLOBJ);
			runner = runner -> next;
		    }
		    retVal = ObjTrue;
		}
	    }
	}
    }
    return retVal;
}

ObjPtr PressObjWindow(theInfo, x, y, flags)
WinInfoPtr theInfo;
int x, y;
long flags;
/*Does a press in object window theInfo*/
{
#ifdef INTERACTIVE
    ObjPtr contents;

    /*Press in the objects within the window*/
    contents = GetVar((ObjPtr) theInfo, CONTENTS);
    if (contents)
    {
	if (IsList(contents))
	{
	    return PressObject(contents, x, y, flags);
	}
    }
#endif
    return ObjTrue;
}

static ObjPtr DropObjWindow(window, object, x, y)
ObjPtr window, object;
int x, y;
/*Does a drop in object window theInfo*/
{
    ObjPtr contents;

    /*Press in the objects within the window*/
    contents = GetVar(window, CONTENTS);
    if (contents)
    {
	if (IsList(contents))
	{
	    return DropList(contents, object, x, y);
	}
    }
    return ObjTrue;
}

static ObjPtr KeyDownObjWindow(theInfo, theKey, flags)
WinInfoPtr theInfo;
int theKey;
long flags;
/*Does a key down in object window theInfo*/
{
    ObjPtr contents;

    /*Press in the objects within the window*/
    contents = GetVar((ObjPtr) theInfo, CONTENTS);
    if (contents)
    {
	if (IsList(contents))
	{
	    KeyDownList(contents, theKey, flags);
	}
    }
    return ObjTrue;
}

void ReshapeObject(object, ol, or, ob, ot, left, right, bottom, top)
ObjPtr object;
int ol, or, ob, ot;
int left, right, bottom, top;
/*Reshapes object, which used to exist within owner with edges ol, or, ob, ot
  to one which exists within owner with edges left, right, bottom, top.*/
{
    FuncTyp method;
    method = GetMethod(object, RESHAPE);
    if (method)
    {
	(*method)(object, ol, or, ob, ot, left, right, bottom, top);
    }
    else
    {
	ObjPtr boundsArray, locArray;
	ObjPtr stickyInt;
	real bounds[4];
	real oldWidth, oldHeight;	/*Old width and height*/
	Bool sideLocked[4];		/*True iff side is locked*/
	Bool xStretch, yStretch;	/*Stretchiness in x and y*/
	int stickiness;			/*Side stickiness of the object*/
	real oldBounds[4];		/*Old bounds of the object*/
	ObjPtr contents;		/*Contents of the object, if any*/
	real wr, hr;			/*Width and height ratios*/
	Bool isIcon = false;		/*Is an icon?*/

	wr = ((real) (right - left)) / ((real) (or - ol));
	hr = ((real) (top - bottom)) / ((real) (ot - ob));

	boundsArray = GetVar(object, BOUNDS);
	if (!boundsArray || !IsRealArray(boundsArray) || RANK(boundsArray) != 1 ||
	    DIMS(boundsArray)[0] != 4)
	{
	    /*It might be an icon*/
	    locArray = GetVar(object, ICONLOC);
	    if (!locArray && !IsRealArray(locArray) || RANK(locArray) != 1 ||
		DIMS(locArray)[0] != 2)
	    {
		return;
	    }
	    isIcon = true;
	    Array2CArray(bounds, locArray);
	    bounds[3] = bounds[2] = bounds[1];
	    bounds[1] = bounds[0];
	}
	else
	{
	    Array2CArray(bounds, boundsArray);
	}
	oldBounds[0] = bounds[0];
	oldBounds[1] = bounds[1];
	oldBounds[2] = bounds[2];
	oldBounds[3] = bounds[3];

	oldWidth = bounds[1] - bounds[0];
	oldHeight = bounds[3] - bounds[2];

	/*Get the object's stickiness*/
	stickyInt = GetVar(object, STICKINESS);
	if (stickyInt && IsInt(stickyInt))
	{
	    stickiness = GetInt(stickyInt);
	}
	else
	{
	    stickiness = 0;
	}

	if ((stickiness & STICKYLEFT) || (stickiness & FLOATINGLEFT))
	{
	    if (stickiness & FLOATINGLEFT)
	    {
		bounds[0] = (bounds[0] - ol) * wr + left;
	    }
	    else
	    {
		bounds[0] += left - ol;
	    }
	    if (!((stickiness & STICKYRIGHT) || (stickiness & FLOATINGRIGHT)))
	    {
		bounds[1] = bounds[0] + oldWidth;
	    }
	}
	if ((stickiness & STICKYRIGHT) || (stickiness & FLOATINGRIGHT))
	{
	    if (stickiness & FLOATINGRIGHT)
	    {
		bounds[1] = (bounds[1] - ol) * wr + left;
	    }
	    else
	    {
		bounds[1] += right - or;
	    }
	    if (!((stickiness & STICKYLEFT) || (stickiness & FLOATINGLEFT)))
	    {
		bounds[0] = bounds[1] - oldWidth;
	    }
	}

	if ((stickiness & STICKYBOTTOM) || (stickiness & FLOATINGBOTTOM))
	{
	    if (stickiness & FLOATINGBOTTOM)
	    {
		bounds[2] = (bounds[2] - ob) * hr + bottom;
	    }
	    else
	    {
		bounds[2] += bottom - ob;
	    }
	    if (!((stickiness & STICKYTOP) || (stickiness & FLOATINGTOP)))
	    {
		bounds[3] = bounds[2] + oldHeight;
	    }
	}
	if ((stickiness & STICKYTOP) || (stickiness & FLOATINGTOP))
	{
	    if (stickiness & FLOATINGTOP)
	    {
		bounds[3] = (bounds[3] - ob) * hr + bottom;
	    }
	    else
	    {
		bounds[3] += top - ot;
	    }
	    if (!((stickiness & STICKYBOTTOM) || (stickiness & FLOATINGBOTTOM)))
	    {
		bounds[2] = bounds[3] - oldHeight;
	    }
	}

	/*We've got a new bounds, put it back*/
	if (isIcon)
	{
	    locArray = NewRealArray(1, 2L);
	    ((real *) ELEMENTS(locArray))[0] = bounds[0];
	    ((real *) ELEMENTS(locArray))[1] = bounds[2];
	    SetVar(object, ICONLOC, locArray);
	}
	else
	{
	    boundsArray = NewRealArray(1, 4L);
	    CArray2Array(boundsArray, bounds);
	    SetVar(object, BOUNDS, boundsArray);
	}

	/*If there are some contents to this, do the reshape recursively*/
	contents = GetVar(object, CONTENTS);
	if (contents && IsList(contents))
	{
	    ReshapeList(LISTOF(contents),
		    0, (int) (oldBounds[1] - oldBounds[0]),
		    0, (int) (oldBounds[3] - oldBounds[2]),		0, (int) (bounds[1] - bounds[0]),
		    0, (int) (bounds[3] - bounds[2]));
	}
    }
}

void ReshapeList(contents, ol, or, ob, ot, left, right, bottom, top)
ThingListPtr contents;
int ol, or, ob, ot;
int left, right, bottom, top;
/*Reshapes a list of objects using ReshapeObject*/
{
    while (contents)
    {
	ObjPtr object;

	object = contents -> thing;
	ReshapeObject(object, ol, or, ob, ot, left, right, bottom, top);
	    
	contents = contents -> next;
    }
}

ObjPtr ReshapeObjWindow(window, ol, or, ob, ot, nl, nr, nb, nt)
ObjPtr window;
int ol, or, ob, ot;
int nl, nr, nb, nt;
/*Reshapes object window given that ol, or, ob, and ot was the old
  viewport.  Does not redraw anything.*/
{
    ObjPtr contents;

    contents = GetVar(window, CONTENTS);
    if (contents && IsList(contents))
    {
	ReshapeList(LISTOF(contents),
		0, or - ol, 0, ot - ob,
		0, nr - nl, 0, nt - nb);
    }   
    return ObjTrue;
}

void ImInvalid(object)
ObjPtr object;
/*Alerts the window system that an object is no longer valid*/
{
    ObjPtr testObj;
    if (IsWindow(object))
    {
	/*It's already a window, just set its pic state*/
	SetVar(object, PICSTATE, NewInt(FBBB));
	return;
    }
    testObj = object;
    /*Go through parents until you hit an object at top level*/
    while (testObj)
    {
	ObjPtr list;
	object = testObj;
	list = GetVar(testObj, PARENTS);
	if (list)
	{
	    ThingListPtr runner;
	    runner = LISTOF(list);
	    while (runner)
	    {
		if (IsLight(testObj)) printf("Light parent %lx\n", runner -> thing);
		ImInvalid(runner -> thing);
		runner = runner -> next;
	    }
	    return;
	}
	testObj = GetVar(testObj, PARENT);
	if (testObj && IsWindow(testObj))
	{
	    /*Space or panel, change it.*/
	    SetVar(object, PICSTATE, NewInt(FBBB));
	    return;
	}
    }
/*
    Error("ImInvalid", NOPARENT, object);
*/
}

#ifdef PROTO
void PauseDrawing(Bool whether)
#else
void PauseDrawing(whether)
Bool whether;
#endif
/*Pauses drawing for a while*/
{
    if (whether)
    {
	++pauseDrawing;
    }
    else
    {
	--pauseDrawing;
    }
}

void DrawMe(object)
ObjPtr object;
/*Redraws object in the current window undergoing interaction*/
{
#ifdef GRAPHICS
	ImInvalid(object);
	if (overDraw)
	{
	    color(0);
	    clear();
	    DrawObject(object);
	}
	else
	{
	    if (!pauseDrawing)
	    {
		drawMouse = true;
	    }
	}
#endif
}

void InitPickUp()
/*Initializes picking up objects*/
{
    if (dragBuffer)
    {
	DeleteThing(dragBuffer);
	dragBuffer = NULLOBJ;
    }
}

ObjPtr PickUpObject(object)
ObjPtr object;
/*Picks up an object*/
{
    object = ObjectWhichRepresents(selWinInfo, object);
    if (object && IsIcon(object))
    {
	char s[256];
	if (!dragBuffer)
	{
	    iconXOff = iconYOff = 0;
	    dragBuffer = NewList();
	    AddToReferenceList(dragBuffer);
	    MySetCursor(ICONCURSOR);
	}
	s[0] = ' ';
	MakeObjectName(s + 1, object);
	Log(s);
	PostfixList(dragBuffer, object);
	return ObjTrue;
    }
    else
    {
	return ObjFalse;
    }
}

void DoPickUpObjects()
/*Picks up the objects in the icon in the selected window*/
{
    DoObjFunction(OF_PICK_UP);
}

#if 0
void DoDropObjects()
/*Drops the objects in the drag buffer*/
{
    FuncType method;
    if (!selWinInfo)
    {
	return;
    }
    if (!dragBuffer)
    {
	return;
    }
    method = GetMethod((ObjPtr) selWinInfo, DROPOBJECTS);
    if (method)
    {
	iconXOff = 0;
	iconYOff = 0;
	if (logging)
	{
	    char cmd[256];
	    sprintf(cmd, "drop %d %d\n", dropX, dropY);
	    Log(cmd);
	    InhibitLogging(true);
	}
	(*method)(selWinInfo, dragBuffer, dropX, dropY);
	DeleteThing(dragBuffer);
	dragBuffer = NULLOBJ;
	if (logging)
	{
	    InhibitLogging(false);
	}
    }
}
#endif

WinInfoPtr NewObjWindow(superClass, title, flags, minWidth, minHeight, maxWidth, maxHeight)
ObjPtr superClass;
char *title;
long flags;
int minWidth, minHeight, maxWidth, maxHeight;
/*Creates a new object window with title title and flags flags.  superClass is
  the class of the window, if NULLOBJ objWindowClass will be used*/
{
    WinInfoPtr retVal;
    WindowID theWindow;

    if (showWindows)
    {
	theWindow = NewOpenedWindow(title, minWidth, minHeight, maxWidth, maxHeight,flags);
    }
    else
    {
	theWindow = 0;
    }

    retVal = NewWinInfo(superClass ? superClass : objWindowClass, theWindow, 
		flags, title,  minWidth, minHeight, maxWidth, maxHeight);
    SetVar((ObjPtr) retVal, CONTENTS, NewList());	/*Contents*/

    return retVal;
}

static ObjPtr FindObjectObjClass(object, name)
ObjPtr object;
char *name;
/*Searches an object and its contents for an object with name*/
{
    ObjPtr retVal = NULLOBJ;
    ObjPtr objName, contents;

    /*First check to see if I am the object*/
    objName = GetVar(object, NAME);
    if (objName && IsString(objName) && 0 == strcmp2(GetString(objName), name))
    {
	if (!retVal)
	{
	    retVal = NewList();
	}
	PostfixList(retVal, object);
    }

    /*Now check my CONTENTS*/
    contents = GetVar(object, CONTENTS);
    if (contents)
    {
	ObjPtr foundObjects;
	foundObjects = FindNamedObject(contents, name);
	if (foundObjects)
	{
	    if (!retVal)
	    {
		retVal = NewList();
	    }
	    AppendList(retVal, foundObjects);
	}
    }

    return retVal;
}

static ObjPtr ForAllObjectsObjClass(object, routine)
ObjPtr object;
FuncTyp routine;
/*Does routine on all objects within object*/
{
    ObjPtr contents;

    (*routine)(object);

    /*Now check my CONTENTS*/
    contents = GetVar(object, CONTENTS);
    if (contents)
    {
	ForAllObjects(contents, routine);
    }

    return ObjTrue;
}

extern ObjPtr objClass;

void InitObjWindows()
/*Initializes the obj window system*/
{
    objWindowClass = NewObject(windowClass, 0);
    AddToReferenceList(objWindowClass);
    SetMethod(objWindowClass, CLOSE, CloseObjWindow);
    SetMethod(objWindowClass, DRAW, DrawObjWindow);
    SetMethod(objWindowClass, PRESS, PressObjWindow);
    SetMethod(objWindowClass, DROPOBJECTS, DropObjWindow);
    SetMethod(objWindowClass, KEYDOWN, KeyDownObjWindow);
    SetMethod(objWindowClass, RESHAPE, ReshapeObjWindow);
    SetMethod(objWindowClass, MAKEDRAWN, MakeObjWindowDrawn);

    /*KLUDGE*/
    SetMethod(objClass, FINDOBJECT, FindObjectObjClass);
    SetMethod(objClass, FORALLOBJECTS, ForAllObjectsObjClass);
}

static Bool repped;
static ObjPtr testObject;
static ObjPtr objectWhichRepresents;

static ObjPtr CheckRepObj(object)
ObjPtr object;
/*Checks if an object matches testObject*/
{
    if (IsIcon(object) && (GetVar(object, REPOBJ) == testObject))
    {
	objectWhichRepresents = object;
	repped = true;
	return ObjTrue;
    }
    else if ((object == testObject) && !repped)
    {
	objectWhichRepresents = object;
	return ObjTrue;
    }
    else
    {
	return ObjFalse;
    }
}

ObjPtr ObjectWhichRepresents(window, object)
WinInfoPtr window;
ObjPtr object;
/*Returns the object in window that represents object, or NULLOBJ*/
{
    if (object == (ObjPtr) window) return (ObjPtr) window;

    repped = false;
    objectWhichRepresents = NULLOBJ;
    testObject = object;

    if (object)
    {
	ForAllObjects((ObjPtr) window, CheckRepObj);
    }
    else
    {
	return NULLOBJ;
    }
    if (!objectWhichRepresents)
    {
	ObjPtr var;
	var = GetVar(object, NAME);
	if (var)
	{
	    ObjPtr list;
	    list = FindNamedObject((ObjPtr) window, GetString(var));
	    if (list && LISTOF(list))
	    {
		objectWhichRepresents = LISTOF(list) -> thing;
	    }
	}
    }
    return objectWhichRepresents;
}

ObjPtr DeleteObject(object)
ObjPtr object;
/*Deletes an object from the current window.*/
{
    ObjPtr deleteObject;

    if (!selWinInfo || !object) return ObjFalse;
    deleteObject = ObjectWhichRepresents(selWinInfo, object);
    Select(object, false);
    if (deleteObject)
    {
	FuncTyp method;
	object = deleteObject;
	method = GetMethod(object, DELETEICON);

	if (method)
	{
	    if (IsTrue((*method)(object)))
	    {
		ObjPtr contentsList;
		contentsList = GetVar(object, PARENT);
	 	if (!contentsList || !IsList(contentsList))
		{
		    contentsList = GetVar(contentsList, CONTENTS);
		}
		if (contentsList && IsList(contentsList))
		{
		    ImInvalid(object);
		    DeleteFromList(contentsList, object);
		    return ObjTrue;
		}
		else
		{
		    ReportError("DeleteObject","Internal error: cannot find contents list");
		}
	    }
	}
    }
    return ObjFalse;
}

void DoDelete()
/*Deletes objects*/
{
    ObjPtr corral;
    Bool didit = false;

    if (logging)
    {
	InhibitLogging(true);
    }
    if (selWinInfo)
    {
	ForAllSelectedObjects(DeleteObject);
    }
    if (logging)
    {
	InhibitLogging(false);
	if (didit)
	{
	    Log("delete\n");
	}
    }
}

void KillObjWindows()
/*Kills the obj window system*/
{
    DeleteThing(objWindowClass);
}

ObjPtr FindNamedObject(object, name)
ObjPtr object;
char *name;
/*Finds object with name within object.  Returns a list of matching objects*/
{
    FuncTyp method;
    method = GetMethod(object, FINDOBJECT);
    if (method)
    {
	return (*method)(object, name);
    }
    else
    {
	return NULLOBJ;
    }
}

static ObjPtr invalWindow;
static ObjPtr curInvalObject = NULLOBJ;

static ObjPtr InvalObject(object)
ObjPtr object;
/*Invals an object based on its appearance*/
{
    if (GetVar(object, PARENT) == invalWindow)
    {
	curInvalObject = object;
    }
    MakeVar(object, APPEARANCE);
    if (GetVarChangeCount(object, APPEARANCE) >
	GetVarChangeCount(invalWindow, APPEARANCE))
    {
	ImInvalid(curInvalObject ? curInvalObject : object);
    }
    return ObjTrue;
}

static void InvalObjects(window)
ObjPtr window;
/*Invals all appearance changed objects in window*/
{
    invalWindow = window;
    ForAllObjects(window, InvalObject);
    SetVar(window, APPEARANCE, ObjTrue);
}

void InvalChangedAppearance()
/*Invals ALL windows for ALL objects with changed appearance
  DIK make this occur for all windows all the time*/
{
    ForAllWindows(InvalObjects);
}

void MakeMeCurrent(object)
ObjPtr object;
/*Makes object the current object in the local window*/
{
    if (runningScript && !scriptSelectP)
    {
	return;
    }

    if (selWinInfo)
    {
	ObjPtr oldCurrent;

	FlushKeystrokes();
	oldCurrent = GetVar((ObjPtr) selWinInfo, CURRENT);
        if (oldCurrent == object) return;
	SetVar((ObjPtr) selWinInfo, CURRENT, object);
	if (oldCurrent)
	{
	    DeferMessage(oldCurrent, YOURENOTCURRENT);
	}
	if (object) ImInvalid(object);
    }
}

Bool AmICurrent(object)
ObjPtr object;
/*Returns true iff object is the current object in the current window*/
{
    if (selWinInfo)
    {
	return GetVar((ObjPtr) selWinInfo, CURRENT) == object ? true : false;
    }
    else
    {
	return false;
    }
}
