/*machine.h
  Eric Pepke
  May 29, 1991

  Defines some machine-specific stuff
*/

#ifndef _H_L_MACHINE
#define _H_L_MACHINE

/*Names of libraries*/
#define LIBMALLOC	"malloc"	/*Faster MALLOC library*/
#define LIBHDF		"df"		/*NCSA HDF library*/

/*Supported machine types*/
#define IRIS4D          1               /*Silicon Graphics IRIS 4D*/
#define RS6000          2               /*IBM RS-6000*/

/*Attempt to guess the machine type based on built-in processor directives*/
#ifdef sgi
#define MACHINE         IRIS4D          /*4D cpp defines sgi*/
#else
#define MACHINE         RS6000          /*Must be a 6000*/
#endif

/*If this machine cannot be guessed, put in a #define MACHINE here*/

/*Depending on the machine, define (or don't) the following flags:
        GL4D            GL library as defined on the IRIS4D is present
        FMATH           math routines have float as well as double versions
        MALLOCH         there is a malloc.h available and we're using the lib
        FONTS4D         fonts as defined on the IRIS4D are present
        CURSORS4D       cursors as defined on the IRIS4D are present
        IRISNTSC        NTSC functions as defined on the IRIS4D are present
        IRIS            the machine is some kind of IRIS, 4D or not
        PROTO           use ANSI C prototypes (never been tested without)
        DIRENT          Directory is struct dirent else it is struct direct
	FORTRAN_	FORTRAN routines need an underscore after the name
	SOCKETS		sockets are available and are to be used
	STDLIB		stdlib.h is present
	HDFDEF		HDF library is defined
	INTERWINDRAG	can drag between windows
	WINNOCLOSE	never actually close windows	
*/

#if MACHINE == IRIS4D

#define GL4D
#define FMATH
#define MALLOCH
#define FONTS4D
#define CURSORS4D
#define IRISNTSC
#define IRIS
#define PROTO
#define SOCKETS
#define FORTRAN_
#define STDLIB
#define INTERWINDRAG

#else
#if MACHINE == RS6000

#define GL4D
#define PROTO
#undef _ANSI_C_SOURCE			/*Gotta do this; I don't know why.*/
#define DIRENT
#define WINNOCLOSE			/*Currently, IBM can't close windows*/

#else
Hey!  No machine is defined!
#endif
#endif

#endif

/*Yes, include the HDF library*/
#define HDFDEF

/*Yes, has graphics*/
#if 1
#define GRAPHICS 1
#define INTERACTIVE 1
#endif
