/*ScianThingLists.h
  External stuff for lists of things.
*/

typedef struct objlist			/*List of objects*/
    {
	struct objlist *next;		/*Next thing in list*/
	ThingPtr thing;		/*This thing*/
    } ThingListElement, *ThingListPtr;

typedef struct
    {
	Thing thing;			/*The thing part, containing flags*/
	ThingListPtr list;		/*The list, initially 0*/
	ThingListPtr lastNode;		/*The last node in the list*/
    } List, *LPtr;

#define LISTOF(l) (((LPtr) l) -> list)

/*Method declarations*/
ObjPtr PressList();

#ifdef PROTO
ObjPtr NewList(void);
int WhichListIndex(ObjPtr, ObjPtr);
ObjPtr KeyDownList(ObjPtr list, int key, long flags);
Bool PrefixList(ObjPtr, ThingPtr);
Bool PostfixList(ObjPtr, ThingPtr);
int DeleteFromList(ObjPtr, ThingPtr);
void DisposeList(ObjPtr);
int ListCount(ObjPtr);
ObjPtr GetListElem(ObjPtr, int);
void DrawList(ObjPtr);
ObjPtr DropList(ObjPtr, ObjPtr, int, int);
void InitLists(void);
void KillLists(void);
Bool AppendList(ObjPtr, ObjPtr);
void EmptyList(ObjPtr);
ObjPtr CopyList(ObjPtr);
ObjPtr SortListByStringVar(ObjPtr list, NameTyp id, Bool ascending);
#else
ObjPtr NewList();
int WhichListIndex();
ObjPtr KeyDownList();
Bool PrefixList();
Bool PostfixList();
int DeleteFromList();
void DisposeList();
int ListCount();
ObjPtr GetListElem();
void DrawList();
ObjPtr DropList();
void InitLists();
void KillLists();
Bool AppendList();
void EmptyList();
ObjPtr CopyList();
ObjPtr SortListByStringVar();
#endif

