/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: pal.c,v 1.6 1993/06/24 20:53:40 gbourhis Exp $";
#endif

/* $Log: pal.c,v $
 * Revision 1.6  1993/06/24  20:53:40  gbourhis
 * include "collageP.h"
 *
 * Revision 1.5  1993/06/21  19:38:52  gbourhis
 * When the user change of palette in a raster window, this palette is sent
 * with the associated parameter set to the name's data displayed.
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ScrollBar.h>

#include "collageP.h"
#include "list.h"
#include "view.h"
#include "viewer.h"
/* #include "huePal.h" */
#include "doodle.h"


#define DEF_ROOT	DefaultRootWindow(myDpy)


/* copy a color cell */
#define cpccell(a,b)    {\
                        a.red = b.red; \
                        a.green = b.green; \
                        a.blue = b.blue; \
                        a.flags = b.flags; \
                        }



XColor systemCCells[256];
static	Boolean Reserve[256];

extern	Widget rootWidget;
extern	Display *myDpy;
extern	Cdata *currentObject;
extern	View *baseView;
static List	palList;


void SetColors();


/*
 * Search the palette list for a palette with a matching name.
 * return the palette pointer if found, or 0 if no match found.
 */
Palette *PaletteSearchByName(s)
char *s;
{
Palette *p;

	if (!s)
		return(0);

        p = (Palette *) ListHead(palList);
        while(p) {
                if (!strcmp(p->name,s))
                        return(p);
                p = (Palette *) ListNext(palList);
                }
        return(0);
}

/*
 * Make a new palette entry of the given name, and add it to the palette
 * list.  If one cannot be allocated, return 0.
 */
Palette *PaletteNew(name)
char *name;
{
Palette *p;
int i;

	if (!(p = (Palette *) MALLOC(sizeof(Palette)))) {
		ErrMesg("Can't allocate memory for palette\n");
		return(0);
		}
	if (name) {
		if (!(p->name = (char *) MALLOC(strlen(name) + 1))) {
			ErrMesg("Can't allocate memory for palette name\n");
			return(0);
			}
		strcpy(p->name,name);
		}
	else {
		p->name = (char *) 0;
		}

	for(i=0; i<256; i++) {
		p->ccells[i].pixel = i;
		p->ccells[i].red = 0;
		p->ccells[i].green = 0;
		p->ccells[i].blue = 0;
		p->ccells[i].flags = 0;
		}

	ListAddEntry(palList,p);
	return(p);
}

void PaletteDestroy(p)
Palette *p;
{
	if (!p)
		return;
	ListDeleteEntry(palList,p);
	if (p->name)
		FREE(p->name);
	FREE(p);
}

Palette *PaletteLast()
{
	return((Palette *) ListTail(palList));
}


Palette *PaletteFirst()
{
	return((Palette *) ListHead(palList));
}


Palette *PaletteNext()
{
	return((Palette *) ListNext(palList));
}


void
InitPal()
{
	palList = ListCreate();


/*
	ConvertSEQtoRGB(huePal,defaultPal.rgb);
	ConvertSEQToXColors(huePal,defaultPal.ccells);
        defaultPal.cmap = XCreateColormap(myDpy,DefaultRootWindow(myDpy),
                        GetVisual(myDpy),AllocAll);
	XStoreColors(myDpy,defaultPal.cmap,defaultPal.ccells,256);
	defaultPal.Rcmap = defaultPal.cmap;
	defaultPal.name = "default";

	ListAddEntry(palList,&defaultPal);
*/
}


InitDefaultColors()
{
	int i;

	for(i=0; i<256; i++)
	{
		systemCCells[i].pixel = i;
	}
	XQueryColors(myDpy, DefaultColormap(myDpy, XDefaultScreen(myDpy)),
		systemCCells, 256);
}


void
InitPalette(p)
	Palette *p;
{
	Visual *visual;
	int i;
	Widget sb;
	Cardinal argcnt;
	Arg argList[10];
	Pixel tc, bs, ts, hl, fg, bg, bc, bl, wh;

        visual = XDefaultVisual(myDpy, XDefaultScreen(myDpy));
        p->cmap = XCreateColormap(myDpy, DEF_ROOT, visual, AllocAll);
        p->Rcmap = XCreateColormap(myDpy, DEF_ROOT, visual, AllocAll);
	for(i=0; i<256; i++)
	{
		systemCCells[i].pixel = i;
		Reserve[i] = (Boolean)(i < res_gotten.base_pixel);
	}
	XQueryColors(myDpy, DefaultColormap(myDpy, XDefaultScreen(myDpy)),
		systemCCells, 256);

	sb = XmCreateScrollBar(rootWidget, "temp", NULL, 0);

	argcnt = 0;
	XtSetArg(argList[argcnt], XmNtroughColor, &tc); argcnt++;
	XtSetArg(argList[argcnt], XmNbottomShadowColor, &bs); argcnt++;
	XtSetArg(argList[argcnt], XmNtopShadowColor, &ts); argcnt++;
	XtSetArg(argList[argcnt], XmNhighlightColor, &hl); argcnt++;
	XtSetArg(argList[argcnt], XmNforeground, &fg); argcnt++;
	XtSetArg(argList[argcnt], XmNbackground, &bg); argcnt++;
	XtSetArg(argList[argcnt], XmNborderColor, &bc); argcnt++;
	XtGetValues(sb, argList, argcnt);
	bl = BlackPixel(myDpy, DefaultScreen(myDpy));
	wh = WhitePixel(myDpy, DefaultScreen(myDpy));
	Reserve[(int)tc] = (char)1;
	Reserve[(int)bs] = (char)1;
	Reserve[(int)ts] = (char)1;
	Reserve[(int)hl] = (char)1;
	Reserve[(int)fg] = (char)1;
	Reserve[(int)bg] = (char)1;
	Reserve[(int)bc] = (char)1;
	Reserve[(int)bl] = (char)1;
	Reserve[(int)wh] = (char)1;
	XtDestroyWidget(sb);

	sb = XmCreatePushButton(rootWidget, "temp", NULL, 0);

	argcnt = 0;
	XtSetArg(argList[argcnt], XmNbottomShadowColor, &bs); argcnt++;
	XtSetArg(argList[argcnt], XmNtopShadowColor, &ts); argcnt++;
	XtGetValues(sb, argList, argcnt);
	Reserve[(int)bs] = (char)1;
	Reserve[(int)ts] = (char)1;

	XtDestroyWidget(sb);

	SetColors(p);
}


void
SetColors(pal)
	Palette *pal;
{
	int i;
	XColor	storeCells[256];

	XStoreColors(myDpy, pal->cmap, pal->ccells, 256);
	for (i=0; i<256; i++)
	{
		if ((int)Reserve[i])
		{
			cpccell(storeCells[i], systemCCells[i]);
		}
		else
		{
			cpccell(storeCells[i], pal->ccells[i]);
		}
		storeCells[i].pixel = i;
	}
	XStoreColors(myDpy, pal->Rcmap, storeCells, 256);
}


static void
IntSetPalette(V, pal)
	View *V;
	Palette *pal;
{
	int i;

	if (V->viewEntirePal)
	{
		V->cmap = pal->cmap;
	}
	else
	{
		V->cmap = pal->Rcmap;
	}
	XSetWindowColormap(myDpy, XtWindow(V->shell), V->cmap);
	XSetWindowColormap(myDpy, XtWindow(V->drawArea), V->cmap);
	if (V->type != V_TEXT)
	{
		XSetWindowColormap(myDpy, XtWindow(V->colorpal), V->cmap);
		for (i=0; i<9; i++)
		{
			XSetWindowColormap(myDpy,
				XtWindow(V->buttonPal[i]->widget), V->cmap);
		}
	}

	/*
	 * Also set the colormap for link spreadsheets
	 */
	if ((V->next != NULL)&&(V->next->type == V_SHEET))
	{
		V->next->cmap = V->cmap;
		XSetWindowColormap(myDpy, XtWindow(V->next->shell),
			V->next->cmap);
		XSetWindowColormap(myDpy, XtWindow(V->next->drawArea),
			V->next->cmap);
		XSetWindowColormap(myDpy, XtWindow(V->next->colorpal),
			V->next->cmap);
		for (i=0; i<9; i++)
		{
			XSetWindowColormap(myDpy,
				XtWindow(V->buttonPal[i]->widget), V->cmap);
		}
	}

	if ((V->type == V_WHITEBOARD)||(V->type == V_RASTER))
	{
		for (i=0; i<9; i++)
		{
			XClearArea(myDpy, XtWindow(V->buttonPal[i]->widget),
				0, 0, 1, 1, True);
		}
	}
}


void
SetPalette(V, pal)
	View *V;
	Palette *pal;
{
	if (V->type == V_RASTER || V->type == V_WHITEBOARD)
	  {
	    WidgetList listOfChildren;
	    Cardinal numChildren;
	    Arg args[2];
	    int i;
	    Palette *p = (Palette *)NULL;

	    XtSetArg(args[0], XtNchildren, &listOfChildren);
	    XtSetArg(args[1], XtNnumChildren, &numChildren);
	    XtGetValues(V->palPulldown, args, XtNumber(args));

	    XtSetArg(args[0], XmNuserData, &p);
	    for (i=0; i < numChildren && pal != p; i++)
	      {
		XtGetValues(listOfChildren[i], args, (Cardinal)1);
		if (pal == p)	/* we got it ! */
		  XmToggleButtonGadgetSetState(listOfChildren[i], True, True);
	      }
	    if (pal != p)	/* something wrong */
	      IntSetPalette(V, pal);
	  }
	else			/* SHEET or TEXT */
	  IntSetPalette(V, pal);

	return ;
}


void
CBViewEntirePal(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	XmToggleButtonCallbackStruct *call_data;
{
	View *V = (View *)client_data;

	V->viewEntirePal = call_data->set;

	if (V->cData->hasPalette == True)
	{
		IntSetPalette(V, V->cData->pal);
	}
}

void
CBMakeCurrentPalette(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	XmToggleButtonCallbackStruct *call_data;
{
	struct pal_view *pv = (struct pal_view *)client_data;

	if (call_data->set) {
		IntSetPalette(pv->V, pv->p);
		if (!pv->V->cData->hasPalette || pv->V->cData->pal !=  pv->p) {
			pv->V->cData->hasPalette =  True;
			pv->V->cData->pal = pv->p;
			NetSendPalette8(0,pv->p->name,pv->p->rgb,
					pv->V->cData->name,FALSE, 0);
		}
	}
}


unsigned long
BestColor(d, c)
	Cdata *d;
	DColor *c;
{
static Palette *last_p = (Palette *)-1;
static short last_red = -1;
static short last_green = -1;
static short last_blue = -1;
static unsigned long last_color;

	XColor *xcolor;
	unsigned long mask1, mask2;
	unsigned long color;
	int red, green, blue;
	int rd, gd, bd;
	int dist;
	int mindist;
	int i, indx;
	Boolean useEntirePal = d->V->viewEntirePal;

	if ((d->V->type == V_RASTER)||(d->V->type == V_WHITEBOARD))
	{
		mask1 = AllPlanes;
		mask2 = 0;
	}
	else
	{
		mask1 = AllPlanes;
		mask2 = 0;
	}

	if (d->hasPalette)
	{
		if ((d->pal == last_p)&&(c->red == last_red)&&
			(c->green == last_green)&&(c->blue == last_blue))
		{
			return(last_color);
		}
		xcolor = d->pal->ccells;
		last_p = d->pal;
	}
	else
	{
		if ((last_p == NULL)&&(c->red == last_red)&&
			(c->green == last_green)&&(c->blue == last_blue))
		{
			return(last_color);
		}
		xcolor = systemCCells;
		last_p = NULL;
	}
	last_red = c->red;
	last_green = c->green;
	last_blue = c->blue;
#ifdef DEBUG
	fprintf(stderr, "BestColor: looking up %d, %d, %d\n", last_red, last_green, last_blue);
#endif

	mindist = 65536 * 3;
	color = 0;

	for (i=0; i<256 && mindist; i++)
	{
		indx = ((i & mask1) | mask2);
		if (useEntirePal || ! Reserve[indx])
		  {
		    red = xcolor[indx].red >> 8;
		    green = xcolor[indx].green >> 8;
		    blue = xcolor[indx].blue >> 8;
		  }
		else
		  {
		    red = systemCCells[indx].red >> 8;
		    green = systemCCells[indx].green >> 8;
		    blue = systemCCells[indx].blue >> 8;
		  }
		rd = last_red - red;
		gd = last_green - green;
		bd = last_blue - blue;
		dist = (rd * rd) + (gd * gd) + (bd * bd);
		if (dist < mindist)
		{
			mindist = dist;
			color = i;
		}
	}
	last_color = color;
#ifdef DEBUG
	fprintf(stderr,"BestColor returning pixel %d, mindist = %d, i = %d\n",
		color, mindist, i-1);
#endif
	return(color);
}

XColor *XColorCellOfView(V, i)
     View *V;
     int i;
{
	if ((V->viewEntirePal || !Reserve[i]) && V->cData->hasPalette)
	  return V->cData->pal->ccells + i;
	else
	  return systemCCells + i;
}
