/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>

#include <X11/Intrinsic.h>

#include "doodle.h"
#include "view.h"
#include "viewer.h"
#include "net.h"


extern void DrawPoints();
extern void RubberBox();
extern int MySendDoodle();


extern NetPort *outP;
extern POINT drawDoodle[];
extern long doodleLength;
extern GC invGC;
extern Display *myDpy;
extern Cdata *currentObject;


extern int start_x, end_x, start_y, end_y;


void
SetPoints(x, y, mid_x, mid_y)
	int x, y, mid_x, mid_y;
{
	drawDoodle[doodleLength].x = mid_x + x;
	drawDoodle[doodleLength].y = mid_y + y;
	doodleLength++;
	drawDoodle[doodleLength].x = mid_x + x;
	drawDoodle[doodleLength].y = mid_y - y;
	doodleLength++;
	drawDoodle[doodleLength].x = mid_x - x;
	drawDoodle[doodleLength].y = mid_y + y;
	doodleLength++;
	drawDoodle[doodleLength].x = mid_x - x;
	drawDoodle[doodleLength].y = mid_y - y;
	doodleLength++;
}


void
DoEllipse(a, b, mid_x, mid_y)
	int a, b, mid_x, mid_y;
{
	int x, y;
	double d1, d2;

	x = 0;
	y = b;
	d1 = (b * b) - (a * a * b) + ((double)a * a / 4.0);
	SetPoints(x, y, mid_x, mid_y);

	while ((a * a * ((double)y - 0.5)) > (b * b * ((double)x + 1)))
	{
		if (d1 < 0.0)
		{
			d1 = d1 + (b * b * ((2 * x) + 3));
			x++;
		}
		else
		{
			d1 = d1 + (b * b * ((2 * x) + 3)) +
				(a * a * ((-2 * y) + 2));
			x++;
			y--;
		}
		SetPoints(x, y, mid_x, mid_y);
	}

	d2 = (b * b * ((double)x + 0.5) * ((double)x + 0.5)) +
		((double)a * a * (y - 1) * (y - 1)) - ((double)a * a * b * b);
	while (y > 0)
	{
		if (d2 < 0.0)
		{
			d2 = d2 + (b * b * ((2 * x) + 2)) +
				(a * a * ((-2 * y) + 3));
			x++;
			y--;
		}
		else
		{
			d2 = d2 + (a * a * ((-2 * y) + 3));
			y--;
		}
		SetPoints(x, y, mid_x, mid_y);
	}
}


void
DoneDrawOval(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int     mid_x, mid_y;
	int     tmp, i;
	int     status;

	mid_x = (start_x + end_x) / 2;
	mid_y = (start_y + end_y) / 2;

	if (start_x > end_x)
	{
		tmp = start_x;
		start_x = end_x;
		end_x = tmp;
	}
	if (start_y > end_y)
	{
		tmp = start_y;
		start_y = end_y;
		end_y = tmp;
	}
	DoEllipse((mid_x - start_x), (mid_y - start_y), mid_x, mid_y);

	RubberBox(w);
	DrawPoints(V, V->cData, drawDoodle, 0, (doodleLength - 1),
		V->doodleColor, V->doodleWidth);

	/*
	 * Send Doodle
	 */
	status = MySendDoodle(V, V->doodleWidth, doodleLength, drawDoodle,
		True, True);
}

