/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: grab.c,v 1.2 1993/05/14 19:18:47 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include "view.h"


extern XtAppContext app;
extern Display *myDpy;
extern GC invGC;
extern XImage *GrabImage();
extern void RootBox();

XColor grabCCells[256];

extern int grab_xstart, grab_xend;
extern int grab_ystart, grab_yend;



void
DoGrab(V)
	View *V;
{
	int GrabState;
	unsigned int width, height;
	Cursor cursor;

	cursor = XCreateFontCursor(myDpy, XC_sizing);
	XSetSubwindowMode(myDpy, invGC, IncludeInferiors);
	XFlush(myDpy);
	if (XGrabPointer (myDpy, DefaultRootWindow(myDpy), False,
		ButtonPressMask|ButtonReleaseMask|ButtonMotionMask,
		GrabModeAsync, GrabModeAsync, None,
		cursor, CurrentTime) != GrabSuccess)
	{
		fprintf (stderr, "Unable to grab pointer!\n");
		exit (1);
	}
	/*
	 * Do the loop looking for a button press, drawing the image each time;
	 * since other clients may be running, make sure that the xor segments
	 * all get drawn at the same time.  
	 */
	GrabState = 0;
	while (GrabState != 2)
	{
		XEvent event;

		XtAppNextEvent(app, &event);
		switch (event.type)
		{
		      case ButtonPress:
			grab_xstart = event.xbutton.x_root;
			grab_ystart = event.xbutton.y_root;
			grab_xend = grab_xstart;
			grab_yend = grab_ystart;
			RootBox();
			GrabState = 1;
			break;
		      case MotionNotify:
			if (GrabState == 1)
			{
				RootBox();
				grab_xend = event.xbutton.x_root;
				grab_yend = event.xbutton.y_root;
				RootBox();
			}
			break;
		      case ButtonRelease:
			RootBox();
			GrabState = 2;
			break;
		      default:
			XtDispatchEvent(&event);
			continue;
		}	/* end switch */
	}	/* end while */
	XUngrabPointer(myDpy, CurrentTime);
	if (((grab_xstart - grab_xend) != 0)&&((grab_ystart - grab_yend) != 0))
	{
		V->cutbuffer = GrabImage(&width, &height);
	}
	XSync(myDpy, False);
	XSetSubwindowMode(myDpy, invGC, ClipByChildren);
}


void
CBGrabProc(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	View *V = (View *)client_data;
	int i, junk;
	Colormap *cmaps;

	if (V->cutbuffer != NULL)
	{
		XDestroyImage(V->cutbuffer);
		V->cutbuffer = (XImage *)NULL;
	}
	DoGrab(V);

	for (i=0; i<256; i++)
	{
		grabCCells[i].pixel = i;
	}
	cmaps = XListInstalledColormaps(myDpy, DefaultRootWindow(myDpy), &junk);
	XQueryColors(myDpy, cmaps[0], grabCCells, 256);
}
