/*
   File: Header.c
   Author: K.R. Sloan
   Last Modified: 13 April 1989
   Purpose: extract values from a wff header
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [name1 name2 ... nameN]\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut,Names,n)
 FILE *fdIn, *fdOut;
 char **Names;
 int n;
 {
  FrameBufferType *FBin;
  char Value[ValueLength];
  int i;
  
  FBin  = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }

  for(i=0; i<n; i++)
   {
    if (FAILURE == GetDescriptor(FBin, Names[i], Value))
     fprintf(fdOut,"' '");
    else
     fprintf(fdOut,"'%s' ",Value); 
   }
  fprintf(fdOut,"\n"); fflush(fdOut);
  (void)CloseFB(&FBin);
 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];

  Pass(stdin,stdout,&argv[ArgsParsed],argc-ArgsParsed);
  exit (0);
 }
